/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.DataPrefetchHint;
import org.eclipse.stardust.engine.api.query.FilterAndTerm;
import org.eclipse.stardust.engine.api.query.ProcessInstanceQuery;
import org.eclipse.stardust.engine.api.query.Query;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.engine.core.runtime.utils.ExecutionPermission;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.StructDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.cluster.Data2ClusterMapper;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.StringDataSubstitutionTable;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class DataValueView
extends View {
    private static final int MODEL_ID = 1;
    private static final int DATA_ID_RS_IDX = 2;
    private static final int DATA_NAME_RS_IDX = 3;
    private static final int DATA_DESCR_RS_IDX = 4;
    private static final int DV_TYPE_KEY_RS_IDX = 5;
    private static final int DV_STRING_VAL_RS_IDX = 6;
    private static final int DV_NUM_VAL_RS_IDX = 7;
    private static final int DV_OID_RS_IDX = 8;
    private static final int STRUCT_DV_TYPE_KEY_RS_IDX = 9;
    private static final int STRUCT_DV_STRING_VAL_RS_IDX = 10;
    private static final int STRUCT_DV_NUM_VAL_RS_IDX = 11;
    private static final int STRUCT_DV_OID_RS_IDX = 12;
    private static final int STRUCT_DATA_OID_RS_IDX = 13;
    private static final int STRUCT_DATA_XPATH_RS_IDX = 14;
    private static final int PROCESS_DEFINITION_RS_IDX = 15;
    private static final int DATA_MODEL_RS_IDX = 16;
    private static final int SCOPE_PROCESS_RS_IDX = 17;
    private static final int DATA_OID_RS_IDX = 18;
    private static final int DATA_PI_RS_IDX = 19;
    private static Logger log = LogUtils.getLogger(DataValueView.class);
    private StringDataSubstitutionTable substitutionTable = new StringDataSubstitutionTable();

    public DataValueView() {
        super("LogEntry");
        DbColumn dId = new DbColumn("id", "dd");
        DbColumn pId = new DbColumn("id", "pd");
        this.addParameter(ReportingCommon_Messages.ColumnDataId, String.class, false, Parameter.STRING_DEFAULT_VALUE, dId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessId, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[2];
        String endDateParam = (String)parameters[3];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[4];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[5];
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "Model", ReportingCommon_Messages.ColumnModel, String.class));
        this.addGroupColumn(new GroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class));
        this.addGroupColumn(new GroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class));
        this.addGroupColumn(new GroupColumn(this, "Description", ReportingCommon_Messages.ColumnDescription, String.class));
        this.addGroupColumn(new GroupColumn(this, "Type", ReportingCommon_Messages.ColumnType, String.class));
        this.addGroupColumn(new GroupColumn(this, "Value", ReportingCommon_Messages.Columnvalue, String.class));
    }

    protected void createDefaultParameters() {
    }

    @Override
    public String getReportType() {
        return "DataValue";
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        ArrayList<DataPrefetchHint> dataPrefetchHints = new ArrayList<DataPrefetchHint>();
        ArrayList<AbstractDataColumn> dataPrefetchColumns = new ArrayList<AbstractDataColumn>();
        this.initLoginData = this.initLoginData();
        if (this.initLoginData) {
            this.authorizationContext = AuthorizationContext.create(DataValueView.class, (String)"evaluateResultSet", (Class[])new Class[]{List.class, ResultSet.class, Object[].class});
            this.authPredicate = new AbstractAuthorization2Predicate(this.authorizationContext){};
            ProcessInstanceQuery processQuery = ProcessInstanceQuery.findAll();
            this.authPredicate.addPrefetchDataHints((Query)processQuery);
            FilterAndTerm filters = processQuery.getFilter();
            for (Object filter : filters.getParts()) {
                if (!(filter instanceof DataPrefetchHint)) continue;
                DataPrefetchHint dataPrefetchHint = (DataPrefetchHint)filter;
                dataPrefetchHints.add(dataPrefetchHint);
                if (StringUtils.isNotEmpty((String)dataPrefetchHint.getAttributeName())) {
                    StructDataPrefetchColumn structDataPrefetchColumn = new StructDataPrefetchColumn((View)this, null, null, String.class, dataPrefetchHint.getAttributeName());
                    structDataPrefetchColumn.setColumnProvider(new StructDataDescriptor((View)this, dataPrefetchHint));
                    dataPrefetchColumns.add(structDataPrefetchColumn);
                    continue;
                }
                dataPrefetchColumns.add(new DataPrefetchColumn(this, dataPrefetchHint));
            }
            ArrayList<Object> fieldRefs = new ArrayList<Object>();
            fieldRefs.add(null);
            this.authPredicate.setSelectionExtension(dataPrefetchColumns.size() * -2, fieldRefs);
        }
        if (!dataPrefetchColumns.isEmpty()) {
            try {
                ArrayList<IDataColumn> dataColumns = new ArrayList<IDataColumn>(ViewUtils.getDataColumns(this));
                dataColumns.addAll(dataPrefetchColumns);
                Map<IDataColumn, List<DataInfo>> dataInfos = this.getDataInfos(dataColumns);
                Map<IDataColumn, List<DataJoinInfo>> joinInfoMap = SqlUtils.getJoinInfo(allDeployedModels, dataColumns, dataInfos);
                this.dataMapper = new Data2ClusterMapper(this, dataPrefetchColumns, parameters, true, joinInfoMap);
            }
            catch (SQLException e) {
                log.error(e.getMessage(), e);
                throw new ProcessDatabaseQueryException(e);
            }
        }
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("id", "dd"), new DbColumn("name", "dd"), new DbColumn("description", "dd"), new DbColumn("type_key", "dv"), new DbColumn("string_value", "dv"), new DbColumn("number_value", "dv"), new DbColumn("oid", "dv"), new DbColumn("type_key", "sdv"), new DbColumn("string_value", "sdv"), new DbColumn("number_value", "sdv"), new DbColumn("oid", "sdv"), new DbColumn("oid", "sd"), new DbColumn("xpath", "sd"), new DbColumn("processDefinition", "pi"), new DbColumn("model", "dv"), new DbColumn("scopeProcessInstance", "pi"), new DbColumn("oid", "dd"), new DbColumn("processInstance", "dv")});
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("select distinct ").append(selectList);
        for (IDataPrefetchColumn iDataPrefetchColumn : dataPrefetchColumns) {
            String string = this.dataMapper.getSelectFragment(iDataPrefetchColumn);
            buffer.append(", ").append(string);
        }
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("data"), "dd"));
        String string = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "dd"), new DbColumn("data", "dv")}, " = ");
        String onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "dd"), new DbColumn("model", "dv")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("data_value")).append(' ').append("dv").append(DbUtils.getAndOnFragment(string, onFrag2));
        String string2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", "dv"), new DbColumn("scopeProcessInstance", "pi")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_instance")).append(' ').append("pi").append(DbUtils.getOnFragment(string2));
        String string3 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "dd"), new DbColumn("data", "sd")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "dd"), new DbColumn("model", "sd")}, " = ");
        buffer.append(" left outer join ").append(this.getQualifiedTableName("structured_data")).append(' ').append("sd").append(DbUtils.getAndOnFragment(string3, onFrag2));
        String string4 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "sd"), new DbColumn("xpath", "sdv")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", "sdv"), new DbColumn("scopeProcessInstance", "pi")}, " = ");
        buffer.append(" left outer join ").append(this.getQualifiedTableName("structured_data_value")).append(' ').append("sdv").append(DbUtils.getAndOnFragment(string4, onFrag2));
        String string5 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processDefinition", "pi"), new DbColumn("oid", "pd")}, " = ");
        onFrag2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "pi"), new DbColumn("model", "pd")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("process_definition")).append(' ').append("pd").append(DbUtils.getAndOnFragment(string5, onFrag2));
        for (IDataPrefetchColumn iDataPrefetchColumn : dataPrefetchColumns) {
            String ansiJoinFragment = this.dataMapper.getAnsiJoinFragment(iDataPrefetchColumn);
            buffer.append((String)(ansiJoinFragment == null ? "" : ansiJoinFragment));
        }
        if (this.dataMapper != null && this.dataMapper.foundClusterConfig()) {
            List<String> list = this.dataMapper.getClusterJoins();
            for (String clusterJoin : list) {
                buffer.append(clusterJoin);
            }
        }
        buffer.append(" where ");
        String string6 = this.piField("startTime");
        Pair<Long, Long> startEnd = this.getStartEnd(parameters);
        buffer.append(' ').append(string6).append(" >= ").append(startEnd.getFirst());
        buffer.append(" and ").append(string6).append(" <= ").append(startEnd.getSecond());
        buffer.append(" and (").append(this.sdField("oid")).append(" IS NULL ").append(" or (").append(this.sdField("oid")).append(" IS NOT NULL ").append(" and ").append(this.sdvField("type_key")).append(" IS NOT NULL ").append("))");
        buffer.append(this.getModelSelectionFragment(" AND ", parameters));
        String parameterFilters = this.getParameterFilters(parameters);
        if (!StringUtils.isEmpty((String)parameterFilters)) {
            buffer.append(parameterFilters);
        }
        return buffer.toString();
    }

    @Override
    @ExecutionPermission(id=ExecutionPermission.Id.readDataValues, scope=ExecutionPermission.Scope.data, defaults={ExecutionPermission.Default.OWNER}, administratorOverride=false)
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        Localizer localizer = new Localizer(allDeployedModels);
        boolean canFetchData = true;
        try {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            int rowIndex = -1;
            while (resultSet.next()) {
                long longValue;
                long modelOid = resultSet.getLong(16);
                if (this.initLoginData) {
                    this.authPredicate.accept((Object)resultSet);
                    long dataRtOid = resultSet.getLong(18);
                    long processOid = resultSet.getLong(19);
                    this.authorizationContext.setData(processOid, modelOid, dataRtOid);
                    canFetchData = Authorization2.hasPermission((AuthorizationContext)this.authorizationContext);
                }
                if (!canFetchData) continue;
                Object[] row = new Object[6];
                row[0] = resultSet.getString(1);
                String dataId = resultSet.getString(2);
                String dataName = resultSet.getString(3);
                String dataDescription = resultSet.getString(4);
                dataName = localizer.localizeDataName(modelOid, dataId, dataName);
                dataDescription = localizer.localizeDataDescription(modelOid, dataId, dataDescription);
                row[1] = dataId;
                row[2] = dataName;
                row[3] = dataDescription;
                resultSet.getLong(13);
                boolean structData = !resultSet.wasNull();
                int type = structData ? resultSet.getInt(9) : resultSet.getInt(5);
                String stringValue = structData ? resultSet.getString(10) : resultSet.getString(6);
                long l = longValue = structData ? resultSet.getLong(11) : resultSet.getLong(7);
                if (structData && (!structData || -1 == type)) continue;
                ++rowIndex;
                Object[] values = DataColumn.determineValue(type, stringValue, longValue);
                String xpath = resultSet.getString(14);
                if (structData && !StringUtils.isEmpty((String)xpath)) {
                    row[1] = row[1] + "_" + xpath;
                }
                row[4] = values[0];
                Object object = row[5] = values[1] != null ? values[1].toString() : null;
                if (type == 11 && !this.isCumulated()) {
                    long oid = structData ? resultSet.getLong(12) : resultSet.getLong(8);
                    this.substitutionTable.addColumn(rowIndex, 4, oid);
                }
                rows.add(row);
            }
            LogUtils.enterInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[][] postProcessResults(Object[][] results, Connection connection, Object[] parameters) {
        Object[][] modifiedResults = new Object[0][0];
        try {
            try {
                modifiedResults = this.substitutionTable.substitute(results, connection, this.getDefaultSchemaName(), parameters);
            }
            catch (SQLException e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            this.substitutionTable.clear();
        }
        return modifiedResults;
    }
}

