/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;

public class DistinctEvaluator {
    private Set distinctValues = new HashSet();
    private Set distinctValuesOnResume;
    private boolean resumed;

    public DistinctEvaluator() {
        this.resume();
    }

    public void addValue(Object value) {
        this.distinctValues.add(value);
        this.resumed = false;
    }

    public Set getDistinctValues() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedDistrinctEvaluator);
        }
        return Collections.unmodifiableSet(this.distinctValuesOnResume);
    }

    public boolean isDistinct() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedDistrinctEvaluator);
        }
        return this.distinctValuesOnResume.size() == 1;
    }

    public boolean isEmpty() {
        if (!this.resumed) {
            throw new UnsupportedOperationException(ReportingCommon_Messages.ExceptionCallNotallowedAgainstUnresumedDistrinctEvaluator);
        }
        return this.distinctValuesOnResume.isEmpty();
    }

    public void resume() {
        this.distinctValuesOnResume = this.distinctValues;
        this.distinctValues = new HashSet();
        this.resumed = true;
    }
}

