/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBMSKey;
import org.eclipse.stardust.reporting.common.ColumnProvider;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IOneOfManyColumns;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;

public class ForeignDataColumn
extends GroupColumn
implements IOneOfManyColumns {
    private static Logger log = LogUtils.getLogger(ForeignDataColumn.class);
    private String qualifiedForeignColumnName;
    private ForeignDataDescriptor foreignDataDescriptor;
    private Parameter valueFilterParameter;

    public ForeignDataColumn(View view, String name, String label, Class type, String qualifiedForeignColumnName) {
        this(view, name, label, type, qualifiedForeignColumnName, true);
    }

    public ForeignDataColumn(View view, String name, String label, Class type, String qualifiedForeignColumnName, boolean initParameter) {
        super(view, name, label, type, false, true);
        LogUtils.enterInternal(log, "ForeignDataColumn(,," + type + ", " + qualifiedForeignColumnName + ")");
        this.qualifiedForeignColumnName = qualifiedForeignColumnName;
        this.adjustViewCumulation();
        LogUtils.exitInternal(log, "ForeignDataColumn()");
    }

    @Override
    public void initViewParameter() {
        super.initViewParameter();
        this.valueFilterParameter = this.isNumeric() || this.isBoolean() ? this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getName()), this.getType(), false, Parameter.NUMERIC_DEFAULT_VALUE, null) : this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getName()), this.getType(), false, Parameter.STRING_DEFAULT_VALUE, null);
        super.addParameter(this.valueFilterParameter);
    }

    public ForeignDataColumn(View view, String name, String label, Class type, Properties properties) {
        this(view, name, label, type, properties.getProperty("qualifiedForeignColumnName").length() > 0 ? properties.getProperty("qualifiedForeignColumnName") : null);
    }

    public String getQualifiedForeignColumnName() {
        return this.qualifiedForeignColumnName;
    }

    public void setQualifiedForeignColumnName(String qualifiedForeignColumnName) {
        this.qualifiedForeignColumnName = qualifiedForeignColumnName;
    }

    public String getQualifiedTableName() {
        String[] names = this.getQualifiedForeignColumnName().split("\\.");
        StringBuffer buffer = new StringBuffer();
        int n = 0;
        while (n < names.length - 1) {
            if (n > 0) {
                buffer.append('.');
            }
            buffer.append(names[n]);
            ++n;
        }
        return buffer.toString();
    }

    public String getForeignColumnName() {
        String[] names = this.getQualifiedForeignColumnName().split("\\.");
        return this.getQualifiedForeignColumnName().split("\\.")[names.length - 1];
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.valueFilterParameter.setName(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)name));
        if (log.isDebugEnabled()) {
            log.debug("Value Filter renamed to " + this.valueFilterParameter.getName());
        }
    }

    @Override
    public void setType(Class type) {
        if (log.isDebugEnabled()) {
            log.debug("=> setType(" + type + ")");
        }
        super.setType(type);
        this.adjustViewCumulation();
        this.valueFilterParameter.setType(type);
        if (this.isNumeric() || this.isBoolean()) {
            this.valueFilterParameter.setDefaultValue(Parameter.NUMERIC_DEFAULT_VALUE);
        } else {
            this.valueFilterParameter.setDefaultValue(Parameter.STRING_DEFAULT_VALUE);
        }
    }

    public Parameter getValueFilterParameter() {
        return this.valueFilterParameter;
    }

    protected String getDataValueFilter(Object[] parameters) {
        StringBuffer buffer = new StringBuffer();
        String stringifiedParameterValue = parameters[this.getValueFilterParameter().getIndex() - 1].toString();
        String[] parameterParts = stringifiedParameterValue.split(",");
        String tableAlias = this.getColumnProvider().getName();
        if (this.isTimestamp()) {
            if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                int idx = 0;
                while (idx < parameterParts.length) {
                    parameterParts[idx] = parameterParts[idx].trim();
                    ++idx;
                }
                if (parameterParts.length == 2 && parameterParts[0].startsWith("[") && parameterParts[1].endsWith("]")) {
                    parameterParts[0] = parameterParts[0].substring(1).trim();
                    parameterParts[1] = parameterParts[1].substring(0, parameterParts[1].length() - 1).trim();
                    String timestampFormatter = " timestamp(''{0}'')";
                    Object dbms = null;
                    if (DBMSKey.ORACLE == dbms) {
                        timestampFormatter = " timestamp''{0}''";
                    }
                    buffer.append(String.valueOf(tableAlias) + "." + this.getForeignColumnName()).append(" between ").append(MessageFormat.format(timestampFormatter, parameterParts[0])).append(" and ").append(MessageFormat.format(timestampFormatter, parameterParts[1]));
                } else if (log.isDebugEnabled()) {
                    log.debug("Only interval format [yyyy-mm-dd-hh.mi.ss.zzzzzz,yyyy-mm-dd-hh.mi.ss.zzzzzz] is supported.");
                    log.debug("No filtering applied for " + tableAlias + "." + this.getForeignColumnName());
                }
            }
        } else {
            int n = 0;
            while (n < parameterParts.length) {
                stringifiedParameterValue = parameterParts[n].trim();
                if (this.isNumeric() || this.isBoolean()) {
                    if (stringifiedParameterValue.length() != 0) {
                        if (n == 0) {
                            buffer.append(" (");
                        } else {
                            buffer.append(" or ");
                        }
                        buffer.append(String.valueOf(tableAlias) + "." + this.getForeignColumnName());
                        buffer.append(" = ");
                        buffer.append(stringifiedParameterValue);
                    }
                } else if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                    if (n == 0) {
                        buffer.append(" (");
                    } else {
                        buffer.append(" or ");
                    }
                    buffer.append(String.valueOf(tableAlias) + "." + this.getForeignColumnName());
                    buffer.append(" like '");
                    buffer.append(stringifiedParameterValue);
                    buffer.append("'");
                }
                ++n;
            }
            if (buffer.length() > 0) {
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<column type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' columntype='");
        buffer.append(this.getType().getName());
        buffer.append("'>\n");
        buffer.append("<property name='qualifiedForeignColumnName'>" + (this.getQualifiedForeignColumnName() != null ? this.getQualifiedForeignColumnName() : "")).append("</property>\n");
        buffer.append("</column>\n");
        return buffer.toString();
    }

    @Override
    public ColumnProvider getColumnProvider() {
        return this.foreignDataDescriptor;
    }

    @Override
    public void setColumnProvider(ColumnProvider columnProvider) {
        Assert.isNotNull((Object)columnProvider, (String)ReportingCommon_Messages.ColumnNullValueIsNotAllowedForForeignDataDescriptor);
        if (!this.getView().allowsUserDefinedDataColumns().contains(columnProvider.getClass())) {
            throw new RuntimeException(ReportingCommon_Messages.ExceptionDataFieldsCannotBeDefinedForThisView);
        }
        this.foreignDataDescriptor = (ForeignDataDescriptor)columnProvider;
        this.setDbColumnRef(new DbColumnRef(this.getForeignColumnName(), null, this.getColumnProvider().getName()));
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    public boolean isTimestamp() {
        boolean isTimestamp = Timestamp.class.isAssignableFrom(this.getType());
        if (log.isDebugEnabled()) {
            log.debug("Foreign data column " + this.getName() + " is of type " + this.getType() + "(" + isTimestamp + ")");
        }
        return isTimestamp;
    }
}

