/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Properties;
import org.eclipse.stardust.reporting.common.AbstractColumnProvider;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.View;

public class ForeignDataDescriptor
extends AbstractColumnProvider {
    private static Logger log = LogUtils.getLogger(ForeignDataDescriptor.class);
    private String qualifiedForeignJoinColumnName;
    private String joinColumnName;
    private boolean useOuterJoin;

    public ForeignDataDescriptor(View view, String name, String qualifiedForeignJoinColumnName, String joinColumnName, boolean useOuterJoins) {
        super(view, name);
        LogUtils.enterInternal(log, "ForeignDataDescriptor(,," + qualifiedForeignJoinColumnName + ", " + joinColumnName + ", " + useOuterJoins + ")");
        this.qualifiedForeignJoinColumnName = qualifiedForeignJoinColumnName;
        this.joinColumnName = joinColumnName;
        this.useOuterJoin = useOuterJoins;
        LogUtils.exitInternal(log, "ForeignDataDescriptor()");
    }

    public ForeignDataDescriptor(View view, String name, Properties properties) {
        this(view, name, properties.getProperty("qualifiedForeignJoinColumnName").length() > 0 ? properties.getProperty("qualifiedForeignJoinColumnName") : null, properties.getProperty("joinColumnName").length() > 0 ? properties.getProperty("joinColumnName") : null, properties.getProperty("useOuterJoin") == null || properties.getProperty("useOuterJoin").length() > 0 ? Boolean.valueOf(properties.getProperty("useOuterJoin")) : false);
    }

    public String getForeignJoin(GroupColumn joinColumn) {
        StringBuffer buffer = new StringBuffer();
        if (this.isUseOuterJoin()) {
            buffer.append(" left outer join ");
        } else {
            buffer.append(" inner join ");
        }
        String[] parts = this.getQualifiedForeignJoinColumnName().split("\\.");
        String aliasedoinColumn = joinColumn.getDbColumnRef().getTableAliasedColumnId();
        String schemaName = parts[0];
        String tableName = parts[1];
        String columnName = parts[2];
        String alias = this.getName();
        buffer.append(schemaName).append(".").append(tableName).append(" ").append(alias);
        buffer.append(" ON(");
        buffer.append(alias).append(".").append(columnName);
        buffer.append(" = ");
        buffer.append(aliasedoinColumn);
        buffer.append(") ");
        return buffer.toString();
    }

    public String getJoinColumnName() {
        return this.joinColumnName;
    }

    public void setJoinColumnName(String joinColumnName) {
        this.joinColumnName = joinColumnName;
    }

    public String getQualifiedForeignJoinColumnName() {
        return this.qualifiedForeignJoinColumnName;
    }

    public void setQualifiedForeignJoinColumnName(String qualifiedForeignJoinColumnName) {
        this.qualifiedForeignJoinColumnName = qualifiedForeignJoinColumnName;
    }

    public boolean isUseOuterJoin() {
        return this.useOuterJoin;
    }

    public void setUseOuterJoin(boolean useOuterJoins) {
        this.useOuterJoin = useOuterJoins;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQualifiedTableName() {
        String[] names = this.getQualifiedForeignJoinColumnName().split("\\.");
        StringBuffer buffer = new StringBuffer();
        int n = 0;
        while (n < names.length - 1) {
            if (n > 0) {
                buffer.append('.');
            }
            buffer.append(names[n]);
            ++n;
        }
        return buffer.toString();
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append("columnProvider");
        buffer.append(" type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("'>\n");
        buffer.append("<property name='qualifiedForeignJoinColumnName'>" + (this.getQualifiedForeignJoinColumnName() != null ? this.getQualifiedForeignJoinColumnName() : "")).append("</property>\n");
        buffer.append("<property name='joinColumnName'>" + (this.getJoinColumnName() != null ? this.getJoinColumnName() : "")).append("</property>\n");
        buffer.append("<property name='useOuterJoin'>" + this.isUseOuterJoin()).append("</property>\n");
        for (GroupColumn column : this.getGroupColumns()) {
            buffer.append(column.getXMLSpecification());
        }
        buffer.append("</").append("columnProvider").append(">\n");
        return buffer.toString();
    }
}

