/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Timestamp;

public class Interval {
    private Timestamp lowerTimestamp;
    private Timestamp upperTimestamp;
    private long lowerTimestampMillis;
    private long upperTimestampMillis;

    public Interval(Timestamp lowerTimestamp, Timestamp upperTimestamp) {
        this.setLowerTimestamp(lowerTimestamp);
        this.setUpperTimestamp(upperTimestamp);
    }

    public Timestamp getLowerTimestamp() {
        return this.lowerTimestamp;
    }

    private void setLowerTimestamp(Timestamp lowerTimestamp) {
        this.lowerTimestamp = lowerTimestamp;
        this.lowerTimestampMillis = lowerTimestamp.getTime();
    }

    public Timestamp getUpperTimestamp() {
        return this.upperTimestamp;
    }

    private void setUpperTimestamp(Timestamp upperTimestamp) {
        this.upperTimestamp = upperTimestamp;
        this.upperTimestampMillis = upperTimestamp.getTime();
    }

    public boolean startedBeforeInterval(long processStartTime) {
        return processStartTime < this.lowerTimestampMillis;
    }

    public boolean endedBeforeInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() < this.lowerTimestampMillis;
    }

    public boolean startedInInterval(long processStartTime) {
        return processStartTime >= this.lowerTimestampMillis && processStartTime < this.upperTimestampMillis;
    }

    public boolean endedInInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() >= this.lowerTimestampMillis && processEndTime.getTime() < this.upperTimestampMillis;
    }

    public boolean startedAfterInterval(long processStartTime) {
        return processStartTime >= this.upperTimestampMillis;
    }

    public boolean endedAfterInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() >= this.upperTimestampMillis;
    }

    public boolean equals(Object other) {
        boolean isEqual;
        if (this == other) {
            isEqual = true;
        } else if (!(other instanceof Interval)) {
            isEqual = false;
        } else {
            Interval interval = (Interval)other;
            isEqual = (this.lowerTimestamp != null ? this.lowerTimestamp.equals(interval.lowerTimestamp) : interval.lowerTimestamp == null) && (this.upperTimestamp != null ? this.upperTimestamp.equals(interval.upperTimestamp) : interval.upperTimestamp == null);
        }
        return isEqual;
    }

    public int hashCode() {
        int result = this.lowerTimestamp != null ? this.lowerTimestamp.hashCode() : 0;
        result = 29 * result + (this.upperTimestamp != null ? this.upperTimestamp.hashCode() : 0);
        return result;
    }
}

