/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.LogEntryQuery;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class LogEntryView
extends View {
    private static Logger log = LogUtils.getLogger(LogEntryView.class);

    public LogEntryView() {
        super("LogEntry");
        this.tableNames = new HashMap();
        this.tableNames.put("log_entry", "le");
        this.tableNames.put("workflowuser", "wu");
        this.tableNames.put("activity_instance", "ai");
        DbColumn leCode = new DbColumn("code", "le");
        this.addParameter(ReportingCommon_Messages.ColumnCode, Long.class, false, Parameter.STRING_DEFAULT_VALUE, leCode.getQualifiedName());
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn((View)this, "OID", ReportingCommon_Messages.ColumnOid, Long.class, "le", "oid"));
        this.addGroupColumn(new GroupColumn((View)this, "Type", ReportingCommon_Messages.ColumnType, String.class, "le", "type"));
        this.addGroupColumn(new GroupColumn((View)this, "Code", ReportingCommon_Messages.ColumnCode, String.class, "le", "code"));
        this.addGroupColumn(new GroupColumn((View)this, "Subject", ReportingCommon_Messages.ColumnSubject, String.class, "le", "subject"));
        this.addGroupColumn(new GroupColumn((View)this, "Timestamp", ReportingCommon_Messages.ColumnTimeStamp, Date.class, "le", "stamp"));
        this.addGroupColumn(new GroupColumn((View)this, "UserAccount", ReportingCommon_Messages.ColumnUserAccount, String.class, "wu", "account"));
        this.addGroupColumn(new GroupColumn((View)this, "UserFirstName", ReportingCommon_Messages.ColumnUserFirstName, String.class, "wu", "firstName"));
        this.addGroupColumn(new GroupColumn((View)this, "UserLastName", ReportingCommon_Messages.ColumnUserLastName, String.class, "wu", "lastName"));
    }

    protected void createDefaultParameters() {
    }

    @Override
    public String getReportType() {
        return "LogEntry";
    }

    @Override
    public String getWhereString(Object[] parameters) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        StringBuffer buffer = new StringBuffer();
        DbColumn partition = new DbColumn(dbDescriptor.quoteIdentifier("partition"), "le");
        String predicate = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("workflowUser", "le"), new DbColumn("oid", "wu")}, " = ");
        buffer.append(partition).append(" = ").append(this.getPartitionInfo().getPartitionOid()).append(" and ").append(predicate);
        buffer.append(this.getParameterFilters(parameters));
        return buffer.toString();
    }

    @Override
    public List allowsUserDefinedDataColumns() {
        ArrayList classList = new ArrayList();
        return classList;
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        try {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                long modelOid = resultSet.getLong(9);
                boolean initLoginData = this.initLoginData();
                boolean canFetchLogEntry = true;
                if (initLoginData) {
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllLogEntries", (Class[])new Class[]{LogEntryQuery.class});
                    authorizationContext.setModel(modelOid);
                    canFetchLogEntry = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                }
                if (!canFetchLogEntry) continue;
                Object[] row = new Object[this.getLeafFields().size()];
                int n = 0;
                while (n < this.getLeafFields().size()) {
                    Column column = (Column)this.getLeafFields().get(n);
                    if (log.isDebugEnabled()) {
                        log.debug("Column " + column.getName() + " type " + column.getType());
                    }
                    row[n] = column.getType() == Date.class ? new Date(resultSet.getLong(n + 1)) : (column.getType() == Long.class ? new Long(resultSet.getLong(n + 1)) : (column.getType() == Integer.class ? new Integer(resultSet.getInt(n + 1)) : (column.getType() == String.class ? resultSet.getString(n + 1) : (column.getType() == Timestamp.class ? new Timestamp(resultSet.getLong(n + 1)) : resultSet.getObject(n + 1)))));
                    if (log.isDebugEnabled()) {
                        log.debug("Retrieving row " + row[n]);
                    }
                    ++n;
                }
                rows.add(row);
            }
            Object[][] rowSet = this.convertRowsToRowSet(rows);
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return rowSet;
        }
        catch (SQLException e) {
            log.debug(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) {
        LogUtils.enterInternal(log, "getQueryString()");
        StringBuffer queryString = new StringBuffer();
        queryString.append("select ");
        queryString.append(this.getSelectString());
        queryString.append(", ");
        queryString.append(DbUtils.getColumnList(DbUtils.getCurrentDbDescriptor(), new IDbColumn[]{new DbColumn("model", "ai")}));
        queryString.append(" from ");
        queryString.append(this.getFromString());
        String whereClause = this.getWhereString(parameters);
        if (whereClause != null && whereClause.trim().length() > 0) {
            queryString.append(" where ");
            queryString.append(whereClause);
        }
        LogUtils.exitInternal(log, "getQueryString()");
        return queryString.toString();
    }
}

