/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.ActivityInstanceQuery;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class OrganizationalWorklistView
extends View {
    private static Logger log = LogUtils.getLogger(OrganizationalWorklistView.class);

    public OrganizationalWorklistView() {
        super("OrganizationalWorklist");
        DbColumn paId = new DbColumn("id", "mpd");
        DbColumn aId = new DbColumn("id", "ad");
        DbColumn aiStartTime = new DbColumn("startTime", "ai");
        DbColumn aiLastMod = new DbColumn("lastModificationTime", "ai");
        this.addParameter(ReportingCommon_Messages.ColumnParticipantIds, String.class, false, Parameter.STRING_DEFAULT_VALUE, paId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityIds, String.class, false, Parameter.STRING_DEFAULT_VALUE, aId.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), aiStartTime.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), aiLastMod.getQualifiedName());
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[4];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[5];
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "Model", ReportingCommon_Messages.ColumnModel, String.class));
        this.addGroupColumn(new GroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, Long.class));
        this.addGroupColumn(new GroupColumn(this, "Type", ReportingCommon_Messages.ColumnType, String.class));
        this.addGroupColumn(new GroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class));
        this.addGroupColumn(new GroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class));
        this.addGroupColumn(new GroupColumn(this, "Description", ReportingCommon_Messages.ColumnDescription, String.class));
        this.addGroupColumn(new GroupColumn(this, "Department ID", ReportingCommon_Messages.ColumnDepartementId, String.class));
        this.addGroupColumn(new GroupColumn(this, "Department OID", ReportingCommon_Messages.ColumnDepartementOid, Long.class));
        this.addGroupColumn(new GroupColumn(this, "TotalAssignedItemCount", ReportingCommon_Messages.ColumnTotalAssignedItemCount, Integer.class));
        this.addGroupColumn(new GroupColumn(this, "TotalPerformedItemCount", ReportingCommon_Messages.ColumnTotalPerformendItemCount, Integer.class));
        this.addGroupColumn(new GroupColumn(this, "WorkingTimeOnUnfinishedActivities", ReportingCommon_Messages.ColumnTimeOnUnfinishedActivities, Long.class));
        this.addGroupColumn(new GroupColumn(this, "WorkingTimeOnCompletedActivties", ReportingCommon_Messages.ColumnTimeOnCompletedActivities, Long.class));
        this.addGroupColumn(new GroupColumn(this, "TotalWorkingTime", ReportingCommon_Messages.ColumnTotalWorkingTime, Long.class));
        this.addGroupColumn(new GroupColumn(this, "FullTimeEquivalent", ReportingCommon_Messages.ColumnFullTimeEquivalent, Long.class));
        this.addGroupColumn(new GroupColumn(this, "PercentageWorkload", ReportingCommon_Messages.ColumnPercentageWorkLoad, BigDecimal.class));
    }

    @Override
    public String getReportType() {
        return "OrganizationalWorklist";
    }

    private String getSubQuery() {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        StringBuffer buffer = new StringBuffer(300);
        DbColumn wuOid = new DbColumn("oid", "wu");
        String onPredicate = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{wuOid, new DbColumn("workflowUser", "ump")}, " = ");
        String wherePredicate = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("participant", "ump"), new DbColumn("oid", "mpd")}, " = ");
        buffer.append("select ").append(wuOid);
        buffer.append(" from ");
        buffer.append(this.getQualifiedTableName("workflowuser")).append(' ').append("wu").append(" inner join ");
        buffer.append(this.getQualifiedTableName("user_participant")).append(' ').append("ump").append(DbUtils.getOnFragment(onPredicate)).append(" where ").append(wherePredicate);
        return buffer.toString();
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) {
        StringBuffer buffer = new StringBuffer(500);
        String modelParticipantWorklistQuery = this.getWorkListQuery(false, parameters);
        String workflowUserWorklistQuery = this.getWorkListQuery(true, parameters);
        buffer.append(modelParticipantWorklistQuery);
        buffer.append(" UNION ");
        buffer.append(workflowUserWorklistQuery);
        buffer.append(" order by 1");
        return buffer.toString();
    }

    private String getWorkListQuery(boolean includeUserParticipants, Object[] parameters) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("oid", "mpd"), new DbColumn("type", "mpd"), new DbColumn("id", "mpd"), new DbColumn("name", "mpd"), new DbColumn("description", "mpd"), new DbColumn("oid", "ai"), new DbColumn("startTime", "ai"), new DbColumn("lastModificationTime", "ai"), new DbColumn("state", "ai"), new DbColumn("currentPerformer", "ai"), new DbColumn("performedBy", "ai"), new DbColumn("model", "mpd"), new DbColumn("oid", "ad"), new DbColumn("currentDepartment", "ai"), new DbColumn("processInstance", "ai"), new DbColumn("currentUserPerformer", "ai"), new DbColumn("oid", "dptm"), new DbColumn("id", "dptm")});
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("select ").append(selectList);
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("participant"), "mpd"));
        String onFrag1 = "";
        if (!includeUserParticipants) {
            onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "mpd"), new DbColumn("currentPerformer", "ai")}, " = ");
        } else {
            String userParticipantAlias = "ump";
            DbColumn modelParticipantOid = new DbColumn("oid", "mpd");
            DbColumn userParticipantColumn = new DbColumn("participant", userParticipantAlias);
            String userParticipantJoin = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{modelParticipantOid, userParticipantColumn}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("user_participant")).append(' ').append(userParticipantAlias).append(DbUtils.getOnFragment(userParticipantJoin));
            DbColumn performedBy = new DbColumn("performedBy", "ai");
            DbColumn userParticipantOid = new DbColumn("oid", userParticipantAlias);
            onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{performedBy, userParticipantOid}, " = ");
        }
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity_instance")).append(' ').append("ai").append(DbUtils.getOnFragment(onFrag1));
        onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("activity", "ai"), new DbColumn("oid", "ad")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity")).append(' ').append("ad").append(DbUtils.getOnFragment(onFrag1));
        onFrag1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("currentDepartment", "ai"), new DbColumn("oid", "dptm")}, " = ");
        buffer.append(" left outer join ").append(this.getQualifiedTableName("department")).append(' ').append("dptm").append(DbUtils.getOnFragment(onFrag1));
        String modelSelectionFragment = this.getModelSelectionFragment(" WHERE ", parameters);
        buffer.append(modelSelectionFragment);
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        Localizer localizer = new Localizer(allDeployedModels);
        try {
            Object[] row;
            String modelId = null;
            long modelOid = 0L;
            long participantOID = 0L;
            long departmentOID = 0L;
            String departmentId = null;
            String participantType = null;
            int performedInstanceCount = 0;
            int assignedInstanceCount = 0;
            long workingTimeOnUnfinishedActivitiesMillis = 0L;
            long workingTimeOnCompletedActivitiesMillis = 0L;
            long totalWorkingTimeMillis = 0L;
            long fteMillis = 0L;
            long startTime = 0L;
            String participantID = null;
            String participantName = null;
            String participantDescription = null;
            NumberFormat format = NumberFormat.getInstance(Locale.US);
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                boolean initLoginData = this.initLoginData();
                boolean canFetchOrganizationWorklist = true;
                modelOid = resultSet.getLong(13);
                if (initLoginData) {
                    long currentPerformer = resultSet.getLong(11);
                    long activityRtOid = resultSet.getLong(14);
                    long department = resultSet.getLong(15);
                    long processInstanceOid = resultSet.getLong(16);
                    long currentUserPerformer = resultSet.getLong(17);
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllParticipants", (Class[])new Class[0]);
                    authorizationContext.setModel(modelOid);
                    AuthorizationContext authorizationContext2 = AuthorizationContext.create(QueryService.class, (String)"getAllActivityInstances", (Class[])new Class[]{ActivityInstanceQuery.class});
                    authorizationContext2.setActivityData(processInstanceOid, activityRtOid, modelOid, currentPerformer, currentUserPerformer, department);
                    boolean bl = canFetchOrganizationWorklist = Authorization2.hasPermission((AuthorizationContext)authorizationContext) && Authorization2.hasPermission((AuthorizationContext)authorizationContext2);
                }
                if (!canFetchOrganizationWorklist) continue;
                if (participantOID == 0L) {
                    modelId = resultSet.getString(1);
                    participantOID = resultSet.getLong(2);
                    participantType = this.convertType(resultSet.getInt(3));
                    participantID = resultSet.getString(4);
                    participantName = resultSet.getString(5);
                    participantDescription = resultSet.getString(6);
                    startTime = resultSet.getLong(8);
                    departmentOID = resultSet.getLong(15);
                    departmentId = resultSet.getString(19);
                    participantDescription = localizer.localizeRoleDescription(modelOid, participantID, participantDescription);
                    participantName = localizer.localizeRoleName(modelOid, participantID, participantName);
                }
                if (participantOID != resultSet.getLong(2) || departmentOID != resultSet.getLong(15)) {
                    departmentOID = resultSet.getLong(15);
                    departmentId = resultSet.getString(19);
                    row = new Object[15];
                    row[0] = modelId;
                    row[1] = new Long(participantOID);
                    row[2] = participantType;
                    row[3] = participantID;
                    row[4] = participantName;
                    row[5] = participantDescription;
                    row[6] = departmentId;
                    row[7] = new Long(departmentOID);
                    row[8] = new Integer(assignedInstanceCount);
                    row[9] = new Integer(performedInstanceCount);
                    row[10] = new Long(workingTimeOnUnfinishedActivitiesMillis / 1000L / 60L);
                    row[11] = new Long(workingTimeOnCompletedActivitiesMillis / 1000L / 60L);
                    row[12] = new Long(totalWorkingTimeMillis / 1000L / 60L);
                    fteMillis = System.currentTimeMillis() - startTime;
                    row[13] = new Long(fteMillis / 1000L / 60L);
                    double percentage = 100.0 * (double)totalWorkingTimeMillis / (double)fteMillis;
                    if (log.isDebugEnabled()) {
                        log.debug(format.format(percentage));
                    }
                    row[14] = new BigDecimal(format.format(percentage));
                    rows.add(row);
                    modelId = resultSet.getString(1);
                    participantOID = resultSet.getLong(2);
                    participantType = this.convertType(resultSet.getInt(3));
                    participantID = resultSet.getString(4);
                    participantName = resultSet.getString(5);
                    participantDescription = resultSet.getString(6);
                    startTime = resultSet.getLong(8);
                    performedInstanceCount = 0;
                    assignedInstanceCount = 0;
                    totalWorkingTimeMillis = 0L;
                    workingTimeOnUnfinishedActivitiesMillis = 0L;
                    workingTimeOnCompletedActivitiesMillis = 0L;
                    participantDescription = localizer.localizeRoleDescription(modelOid, participantID, participantDescription);
                    participantName = localizer.localizeRoleName(modelOid, participantID, participantName);
                }
                if (resultSet.getLong(11) != 0L) {
                    ++assignedInstanceCount;
                    workingTimeOnUnfinishedActivitiesMillis += resultSet.getLong(9) - resultSet.getLong(8);
                } else {
                    ++performedInstanceCount;
                    workingTimeOnCompletedActivitiesMillis += resultSet.getLong(9) - resultSet.getLong(8);
                }
                totalWorkingTimeMillis += resultSet.getLong(9) - resultSet.getLong(8);
            }
            if (participantOID != 0L) {
                row = new Object[15];
                row[0] = modelId;
                row[1] = new Long(participantOID);
                row[2] = participantType;
                row[3] = participantID;
                row[4] = participantName;
                row[5] = participantDescription;
                row[6] = departmentId;
                row[7] = new Long(departmentOID);
                row[8] = new Integer(assignedInstanceCount);
                row[9] = new Integer(performedInstanceCount);
                row[10] = new Long(workingTimeOnUnfinishedActivitiesMillis / 1000L / 60L);
                row[11] = new Long(workingTimeOnCompletedActivitiesMillis / 1000L / 60L);
                row[12] = new Long(totalWorkingTimeMillis / 1000L / 60L);
                fteMillis = System.currentTimeMillis() - startTime;
                row[13] = new Long(fteMillis / 1000L / 60L);
                double percentage = 100.0 * (double)totalWorkingTimeMillis / (double)fteMillis;
                row[14] = new BigDecimal(format.format(percentage));
                rows.add(row);
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    private String convertType(int type) {
        switch (type) {
            case 0: {
                return ReportingCommon_Messages.TextRole;
            }
        }
        return ReportingCommon_Messages.TextOrganisation;
    }
}

