/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class PartitionInfoImpl
implements PartitionInfo {
    public static final String CARNOT_REPORTING_PARTITION = "CARNOT_REPORTING_PARTITION";
    private static final Logger log = LogUtils.getLogger(PartitionInfoImpl.class);
    private Connection connection;
    private String partitionId;
    private int partitionOid;
    private View.TableQualifier tableQualifier;
    private DBDescriptor dbDescriptor;

    public PartitionInfoImpl(String partitionId, Connection connection, View.TableQualifier tableQualifier, DBDescriptor dbDescriptor) {
        this.partitionId = partitionId;
        this.connection = connection;
        this.tableQualifier = tableQualifier;
        this.dbDescriptor = dbDescriptor;
    }

    public PartitionInfoImpl(String partitionId, Connection connection, View.TableQualifier tableQualifier) {
        this(partitionId, connection, tableQualifier, null);
    }

    @Override
    public String getPartitionId() {
        return this.partitionId;
    }

    @Override
    public synchronized int getPartitionOid() {
        if (this.connection != null) {
            this.evaluatePartitionOid();
            this.connection = null;
        }
        return this.partitionOid;
    }

    private void evaluatePartitionOid() {
        if (this.dbDescriptor == null) {
            this.dbDescriptor = DbUtils.getCurrentDbDescriptor();
        }
        Statement statement = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                String partitionTable = this.tableQualifier.getQualifiedTableName(this.dbDescriptor.quoteIdentifier("partition"));
                String selectList = DbUtils.getColumnList(this.dbDescriptor, new IDbColumn[]{new DbColumn("oid"), new DbColumn("id")});
                buffer.append("SELECT ").append(selectList).append(" FROM ").append(partitionTable);
                statement = this.connection.prepareStatement(buffer.toString());
                statement.execute();
                ResultSet resultSet = statement.getResultSet();
                HashMap<String, Integer> partitions = new HashMap<String, Integer>();
                while (resultSet.next()) {
                    partitions.put(resultSet.getString(2), new Integer(resultSet.getInt(1)));
                }
                if (partitions.isEmpty()) {
                    throw new RuntimeException(ReportingCommon_Messages.NoPartitionInAuditTrail);
                }
                if (StringUtils.isEmpty((String)this.partitionId)) {
                    this.partitionId = Parameters.instance().getString(CARNOT_REPORTING_PARTITION);
                    if (StringUtils.isEmpty((String)this.partitionId)) {
                        if (1 == partitions.size()) {
                            this.partitionId = (String)partitions.keySet().iterator().next();
                        } else {
                            throw new RuntimeException(ReportingCommon_Messages.PartitionNeedsToBeSpecified);
                        }
                    }
                }
                if (!partitions.containsKey(this.partitionId)) {
                    String errorMsg = NLS.bind((String)ReportingCommon_Messages.SpecifiedPartitionDoesNotExist, (Object)this.partitionId);
                    throw new RuntimeException(errorMsg);
                }
                this.partitionOid = (Integer)partitions.get(this.partitionId);
            }
            catch (SQLException e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException x) {
                    log.error(x);
                    throw new RuntimeException(x);
                }
            }
        }
    }
}

