/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.ITransition;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.Cumulants;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class PathView
extends View {
    private static final int COL_IDX_MODEL_ID = 1;
    private static final int COL_IDX_MODEL = 5;
    private static final int COL_IDX_DIFF = 6;
    private static Logger log = LogUtils.getLogger(PathView.class);

    public PathView() {
        super("LogEntry");
        DbColumn pId = new DbColumn("id", "pd");
        this.addParameter(ReportingCommon_Messages.ColumnProcessId, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "Model", ReportingCommon_Messages.ColumnModel, String.class));
        this.addGroupColumn(new GroupColumn(this, "ProcessID", ReportingCommon_Messages.ColumnProcessId, String.class));
        this.addGroupColumn(new GroupColumn(this, "ActivityIDs", ReportingCommon_Messages.ColumnActivityIds, String.class));
        this.addGroupColumn(new GroupColumn(this, "Duration", ReportingCommon_Messages.ColumnDuration, Long.class));
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[1];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[2];
    }

    @Override
    public String getReportType() {
        return "Path";
    }

    @Override
    public List allowsUserDefinedDataColumns() {
        ArrayList classList = new ArrayList();
        return classList;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        if (log.isDebugEnabled()) {
            log.debug("=> executeQuery()");
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            ArrayList rows = new ArrayList();
            DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
            String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m"), new DbColumn("id", "pd"), new DbColumn("id", "ad"), new DbColumn("oid", "pi"), new DbColumn("model", "pd")});
            StringBuffer buffer = new StringBuffer(500);
            buffer.append("select ").append(selectList);
            DbColumn lastMod = new DbColumn("lastModificationTime", "ai");
            DbColumn startTime = new DbColumn("startTime", "ai");
            buffer.append(", ").append(lastMod).append("-").append(startTime);
            buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("activity_instance"), "ai"));
            String predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("activity", "ai"), new DbColumn("oid", "ad")}, " = ");
            String predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ai"), new DbColumn("model", "ad")}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("activity")).append(' ').append("ad").append(DbUtils.getAndOnFragment(predicate1, predicate2));
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processDefinition", "ad"), new DbColumn("oid", "pd")}, " = ");
            predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ad"), new DbColumn("model", "pd")}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("process_definition")).append(' ').append("pd").append(DbUtils.getAndOnFragment(predicate1, predicate2));
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processInstance", "ai"), new DbColumn("oid", "pi")}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("process_instance")).append(' ').append("pi").append(DbUtils.getOnFragment(predicate1));
            String order = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "pd"), new DbColumn("oid", "pi"), new DbColumn("id", "ad")});
            String modelSelectionFragment = this.getModelSelectionFragment(" WHERE ", parameterValues);
            buffer.append(modelSelectionFragment);
            buffer.append(" order by ").append(order);
            ps = connection.prepareStatement(buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug("Executing query: " + buffer.toString());
            }
            rs = SqlUtils.performQuery((PreparedStatement)ps, buffer.toString());
            IProcessDefinition processDefinition = null;
            long processInstanceOID = 0L;
            String modelId = null;
            TreeMap<String, Long> durationMap = new TreeMap<String, Long>();
            List pathes = Collections.EMPTY_LIST;
            HashMap pathCumulants = new HashMap();
            boolean initLoginData = this.initLoginData();
            boolean canFetchProcessDefinition = true;
            while (rs.next()) {
                AuthorizationContext authorizationContext;
                IModel model;
                if (log.isDebugEnabled()) {
                    log.debug(String.valueOf(rs.getString(2)) + " " + rs.getString(3) + " " + rs.getLong(4) + " " + rs.getLong(6));
                }
                if (processDefinition == null) {
                    model = PathView.findModelByOID(allDeployedModels, rs.getInt(5));
                    modelId = rs.getString(1);
                    processDefinition = model.findProcessDefinition(rs.getString(2));
                    if (processDefinition == null) {
                        throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.ExceptionCannotFindProcessDefinition, (Object)rs.getString(2)));
                    }
                    if (initLoginData) {
                        authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllProcessDefinitions", (Class[])new Class[0]);
                        authorizationContext.setModel((long)rs.getInt(5));
                        canFetchProcessDefinition = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                    }
                    if (canFetchProcessDefinition) {
                        pathes = this.collectAllPathes(processDefinition);
                    }
                    processInstanceOID = rs.getLong(4);
                }
                if (processInstanceOID != rs.getLong(4)) {
                    if (log.isDebugEnabled()) {
                        log.debug("New process instance " + rs.getLong(4));
                    }
                    this.onProcessInstanceChange(pathes, durationMap, pathCumulants);
                    processInstanceOID = rs.getLong(4);
                    durationMap.clear();
                }
                if (!processDefinition.getId().equals(rs.getString(2))) {
                    if (log.isDebugEnabled()) {
                        log.debug("New process definition " + rs.getString(2));
                    }
                    if (initLoginData) {
                        AuthorizationContext authorizationContext2 = AuthorizationContext.create(QueryService.class, (String)"getAllProcessDefinitions", (Class[])new Class[0]);
                        authorizationContext2.setModel((long)rs.getInt(5));
                        canFetchProcessDefinition = Authorization2.hasPermission((AuthorizationContext)authorizationContext2);
                    }
                    if (canFetchProcessDefinition) {
                        this.onProcessDefinitionChange(modelId, pathes, pathCumulants, processDefinition, rows);
                    }
                    model = ModelManagerFactory.getCurrent().findModel((long)rs.getInt(5));
                    modelId = rs.getString(1);
                    processDefinition = model.findProcessDefinition(rs.getString(2));
                    if (processDefinition == null) {
                        throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.ExceptionCannotFindProcessDefinition, (Object)rs.getString(2)));
                    }
                    if (initLoginData) {
                        authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllProcessDefinitions", (Class[])new Class[0]);
                        authorizationContext.setModel((long)rs.getInt(5));
                        canFetchProcessDefinition = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                    }
                    if (canFetchProcessDefinition) {
                        pathes = this.collectAllPathes(processDefinition);
                    }
                }
                durationMap.put(rs.getString(3), new Long(rs.getLong(6)));
            }
            this.onProcessInstanceChange(pathes, durationMap, pathCumulants);
            this.onProcessDefinitionChange(modelId, pathes, pathCumulants, processDefinition, rows);
            if (log.isDebugEnabled()) {
                log.debug("All " + rows.size() + " pathes computed");
            }
            Object[][] objectArray = this.convertRowsToRowSet(rows);
            return objectArray;
        }
        catch (Exception e) {
            log.error(e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
        }
    }

    private List collectAllPathes(IProcessDefinition processDefinition) {
        if (log.isDebugEnabled()) {
            log.debug("=> collectAllPathes(" + processDefinition.getId() + ")");
        }
        ArrayList pathes = new ArrayList();
        Iterator activities = processDefinition.getAllActivities();
        IActivity startActivity = null;
        while (activities.hasNext()) {
            startActivity = (IActivity)activities.next();
            if (startActivity.getAllInTransitions().hasNext()) continue;
            return this.traversePathes(startActivity, pathes, new ArrayList());
        }
        return pathes;
    }

    private List traversePathes(IActivity activity, List pathes, List currentPath) {
        if (log.isDebugEnabled()) {
            log.debug("=> traversePathes(" + activity.getId() + ", List pathes, List currentPath)");
        }
        currentPath.add(activity);
        Iterator iterator = activity.getAllOutTransitions();
        if (!iterator.hasNext()) {
            pathes.add(currentPath);
            return pathes;
        }
        int n = 0;
        while (iterator.hasNext()) {
            ITransition transition = (ITransition)iterator.next();
            if (n == 0) {
                this.traversePathes(transition.getToActivity(), pathes, currentPath);
            } else {
                this.traversePathes(transition.getToActivity(), pathes, (List)((ArrayList)currentPath).clone());
            }
            ++n;
        }
        return pathes;
    }

    private void onProcessInstanceChange(List pathes, Map durationMap, Map pathCumulants) {
        if (log.isDebugEnabled()) {
            log.debug("=> onProcessInstanceChange(List pathes, Map durationMap, Map pathCumulants)");
        }
        int n = 0;
        while (n < pathes.size()) {
            List path = (List)pathes.get(n);
            boolean pathTraversed = true;
            long totalPathDuration = 0L;
            int m = 0;
            while (m < path.size()) {
                IActivity activity = (IActivity)path.get(m);
                Long duration = (Long)durationMap.get(activity.getId());
                if (duration == null) {
                    pathTraversed = false;
                    if (!log.isDebugEnabled()) break;
                    log.debug("Unvisited activity " + activity.getId());
                    break;
                }
                totalPathDuration += duration.longValue();
                ++m;
            }
            if (pathTraversed) {
                Cumulants cumulants = (Cumulants)pathCumulants.get(path);
                if (cumulants == null) {
                    cumulants = new Cumulants();
                    pathCumulants.put(path, cumulants);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Adding path duration " + totalPathDuration);
                }
                cumulants.addValue(totalPathDuration);
            }
            ++n;
        }
    }

    private void onProcessDefinitionChange(String modelId, List pathes, Map pathCumulants, IProcessDefinition processDefinition, List rows) {
        if (log.isDebugEnabled()) {
            log.debug("=> onProcessInstanceChange(List pathes, Map durationMap, Map pathCumulants)");
        }
        String procId = null;
        if (processDefinition != null) {
            procId = processDefinition.getId();
        }
        log.debug("onProcessDefinitionChange(List pathes, Map pathCumulants, " + procId + ", Vector rows)");
        int n = 0;
        while (n < pathes.size()) {
            List path = (List)pathes.get(n);
            Cumulants cumulants = (Cumulants)pathCumulants.get(path);
            if (log.isDebugEnabled()) {
                log.debug("path = " + path);
                log.debug("cumulants = " + cumulants);
            }
            if (cumulants != null) {
                cumulants.resume();
                Object[] row = new Object[4];
                StringBuffer activityIDs = new StringBuffer();
                row[0] = modelId;
                row[1] = procId;
                if (log.isDebugEnabled()) {
                    log.debug("Process " + row[0]);
                }
                int m = 0;
                while (m < path.size()) {
                    IActivity activity = (IActivity)path.get(m);
                    if (m != 0) {
                        activityIDs.append(", ");
                    }
                    activityIDs.append(activity.getId());
                    ++m;
                }
                row[2] = activityIDs.toString();
                row[3] = cumulants.getAverage();
                if (log.isDebugEnabled()) {
                    log.debug("Adding row[" + row[0] + ", " + row[1] + ", " + row[2] + "]");
                }
                rows.add(row);
            }
            ++n;
        }
    }
}

