/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.PredefinedForeignDataFactory;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;

public class PredefinedForeignDataDescriptor
extends ForeignDataDescriptor {
    private static final String PROPERTY_TABLE_NAME = "tableName";
    private static final String PROPERTY_TABLE_ID = "tableId";
    private String tableId;

    public PredefinedForeignDataDescriptor(View view, String name, String tableId, String joinColumnName, boolean useOuterJoins) {
        super(view, name, "", joinColumnName, useOuterJoins);
        this.tableId = tableId;
    }

    public PredefinedForeignDataDescriptor(View view, String name, Properties properties) {
        super(view, name, properties);
        this.tableId = properties.getProperty(PROPERTY_TABLE_ID);
        if (StringUtils.isEmpty((String)this.tableId)) {
            if (!StringUtils.isEmpty((String)properties.getProperty(PROPERTY_TABLE_NAME))) {
                this.tableId = "STARTING_PROCESS_ID";
            } else {
                throw new InternalException(NLS.bind((String)ReportingCommon_Messages.TableIdCanNotBeReadForDataSet, (Object)name));
            }
        }
    }

    @Override
    public String getQualifiedTableName() {
        return PredefinedForeignDataFactory.getTableName(this);
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append("columnProvider");
        buffer.append(" type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("'>\n");
        buffer.append("<property name='qualifiedForeignJoinColumnName'>" + (this.getQualifiedForeignJoinColumnName() != null ? this.getQualifiedForeignJoinColumnName() : "")).append("</property>\n");
        buffer.append("<property name='joinColumnName'>" + (this.getJoinColumnName() != null ? this.getJoinColumnName() : "")).append("</property>\n");
        buffer.append("<property name='useOuterJoin'>" + this.isUseOuterJoin()).append("</property>\n");
        buffer.append("<property name='").append(PROPERTY_TABLE_ID).append("'>" + this.getTableId()).append("</property>\n");
        for (GroupColumn column : this.getGroupColumns()) {
            buffer.append(column.getXMLSpecification());
        }
        buffer.append("</").append("columnProvider").append(">\n");
        return buffer.toString();
    }

    public String getTableId() {
        return this.tableId;
    }
}

