/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;

public class ProcessInstanceStateCumulants {
    private static Logger log = LogUtils.getLogger(ProcessInstanceStateCumulants.class);
    private int completedProcessesCount;
    private int processesCompletedInIntervalCount;
    private int startedProcessesCount;
    private int processesStartedInIntervalCount;
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private final long lowerTimestamp;
    private final long upperTimestamp;
    private final boolean useIntervalEnds;

    public ProcessInstanceStateCumulants(long lowerTimestamp, long upperTimestamp, boolean useIntervalEnds) {
        this.lowerTimestamp = lowerTimestamp;
        this.upperTimestamp = upperTimestamp;
        this.useIntervalEnds = useIntervalEnds;
    }

    public void process(long processStartTime, Timestamp processEndTime, int processState) {
        if (processEndTime == null) {
            if (log.isDebugEnabled()) {
                log.debug("null (process end)");
            }
        } else if (log.isDebugEnabled()) {
            log.debug(String.valueOf(this.dateFormat.format(new Date(processEndTime.getTime()))) + " (process end)");
        }
        if (this.useIntervalEnds) {
            if (processState == 2 && (this.endedBeforeInterval(processEndTime) || this.endedInInterval(processEndTime))) {
                ++this.completedProcessesCount;
            }
            if (!this.startedAfterInterval(processStartTime) && (processState != 2 || processState == 2 && this.endedAfterInterval(processEndTime))) {
                ++this.startedProcessesCount;
            }
        } else {
            if (processState == 2 && this.endedBeforeInterval(processEndTime)) {
                ++this.completedProcessesCount;
            }
            if (this.startedBeforeInterval(processStartTime) && (processState != 2 || processState == 2 && (this.endedInInterval(processEndTime) || this.endedAfterInterval(processEndTime)))) {
                ++this.startedProcessesCount;
            }
        }
        if (processState == 2 && this.endedInInterval(processEndTime)) {
            ++this.processesCompletedInIntervalCount;
        }
        if (this.startedInInterval(processStartTime)) {
            ++this.processesStartedInIntervalCount;
        }
    }

    public int getCompletedProcessesCount() {
        return this.completedProcessesCount;
    }

    public int getProcessesCompletedInIntervalCount() {
        return this.processesCompletedInIntervalCount;
    }

    public int getProcessesStartedInIntervalCount() {
        return this.processesStartedInIntervalCount;
    }

    public int getStartedProcessesCount() {
        return this.startedProcessesCount;
    }

    private boolean startedBeforeInterval(long processStartTime) {
        return processStartTime < this.lowerTimestamp;
    }

    private boolean endedBeforeInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() < this.lowerTimestamp;
    }

    private boolean startedInInterval(long processStartTime) {
        return processStartTime >= this.lowerTimestamp && processStartTime < this.upperTimestamp;
    }

    private boolean endedInInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() >= this.lowerTimestamp && processEndTime.getTime() < this.upperTimestamp;
    }

    private boolean startedAfterInterval(long processStartTime) {
        return processStartTime >= this.upperTimestamp;
    }

    private boolean endedAfterInterval(Timestamp processEndTime) {
        return processEndTime != null && processEndTime.getTime() >= this.upperTimestamp;
    }
}

