/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.stardust.reporting.common.AbstractCumulationAspect;
import org.eclipse.stardust.reporting.common.GroupByValuesComparator;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.Interval;
import org.eclipse.stardust.reporting.common.IntervalComparator;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessInstanceStateCumulants;
import org.eclipse.stardust.reporting.common.View;

public class ProcessInstanceStateCumulationAspect
extends AbstractCumulationAspect {
    private static Logger log = LogUtils.getLogger(ProcessInstanceStateCumulationAspect.class);
    private long lowerTimestamp;
    private long upperTimestamp;
    private final boolean useIntervalEnds;
    private Map groupProcessListMap;
    private Map cumulantsGroupPerInterval = new TreeMap(new IntervalComparator());
    private Map processPerIntervallAndGroup = new TreeMap(new IntervalGroupKeyComparator());

    public ProcessInstanceStateCumulationAspect(View view, long startTimestamp, long endTimestamp, boolean useIntervalEnds) {
        super(view, startTimestamp, endTimestamp);
        LogUtils.enterInternal(log, "ProcessInstanceStateCumulationAspect");
        this.useIntervalEnds = useIntervalEnds;
        this.groupProcessListMap = new TreeMap(new GroupByValuesComparator());
        if (this.handleGrouping()) {
            this.groupByColumnIndexes = new int[view.getGroupByGroupColumns().size()];
            int n = 0;
            while (n < view.getGroupByGroupColumns().size()) {
                this.groupByColumnIndexes[n] = view.getColumnIndexUncumulated((GroupColumn)view.getGroupByGroupColumns().get(n));
                ++n;
            }
        }
        LogUtils.exitInternal(log, "ProcessInstanceStateCumulationAspect");
    }

    @Override
    public List getCumulatedRows() {
        LogUtils.enterInternal(log, "getCumulatedRows()");
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Map.Entry entry : this.cumulantsGroupPerInterval.entrySet()) {
            Interval interval = (Interval)entry.getKey();
            Map cumulantsGroup = (Map)entry.getValue();
            Iterator groupValues = this.view.isProvidingEmptyGroupValues() ? this.view.getCumulationKeyIterator() : this.groupProcessListMap.keySet().iterator();
            while (groupValues.hasNext()) {
                Object[] groupValue = (Object[])groupValues.next();
                ProcessInstanceStateCumulants cumulants = (ProcessInstanceStateCumulants)cumulantsGroup.get(groupValue);
                if (cumulants == null && !this.view.isProvidingEmptyGroupValues()) {
                    log.error("No vector for group by keys.");
                    continue;
                }
                Object[] row = new Object[this.view.getLeafFields().size()];
                ProcessData processData = (ProcessData)this.processPerIntervallAndGroup.get(new IntervalGroupKey(interval, groupValue));
                if (processData != null) {
                    row[0] = processData.getModelId();
                    row[1] = processData.getProcessID();
                    row[2] = processData.getProcessName();
                    row[3] = processData.getProcessDescription();
                } else {
                    row[0] = null;
                    row[1] = null;
                    row[2] = null;
                    row[3] = null;
                }
                row[4] = interval.getLowerTimestamp();
                if (cumulants != null) {
                    row[5] = new Integer(cumulants.getCompletedProcessesCount());
                    row[6] = new Integer(cumulants.getProcessesCompletedInIntervalCount());
                    row[7] = new Integer(cumulants.getStartedProcessesCount());
                    row[8] = new Integer(cumulants.getProcessesStartedInIntervalCount());
                } else {
                    row[5] = null;
                    row[6] = null;
                    row[7] = null;
                    row[8] = null;
                }
                if (this.handleGrouping()) {
                    int n = 0;
                    while (n < groupValue.length) {
                        int index;
                        GroupColumn groupColumn = (GroupColumn)this.view.getGroupByGroupColumns().get(n);
                        if (!groupColumn.isPredefined() && -1 != (index = this.view.getLeafFields().indexOf(groupColumn))) {
                            row[index] = groupValue[n];
                        }
                        ++n;
                    }
                }
                rows.add(row);
            }
        }
        LogUtils.exitInternal(log, "getCumulatedRows()");
        return rows;
    }

    @Override
    public void processRows(List uncumulatedRows) {
        LogUtils.enterInternal(log, "processRows()");
        Iterator iter = this.groupProcessListMap.keySet().iterator();
        while (iter.hasNext()) {
            this.groupProcessListMap.put(iter.next(), null);
        }
        for (Object[] row : uncumulatedRows) {
            ArrayList<ProcessData> processes;
            Object[] groupValues = new Object[]{(Long)row[4]};
            if (this.handleGrouping()) {
                groupValues = new Object[this.groupByColumnIndexes.length];
                int n = 0;
                while (n < this.groupByColumnIndexes.length) {
                    groupValues[n] = row[this.groupByColumnIndexes[n]];
                    ++n;
                }
            }
            if ((processes = (ArrayList<ProcessData>)this.groupProcessListMap.get(groupValues)) == null) {
                processes = new ArrayList<ProcessData>();
                this.groupProcessListMap.put(groupValues, processes);
            }
            processes.add(new ProcessData((String)row[0], (String)row[1], (String)row[2], (String)row[3], ((Timestamp)row[9]).getTime(), (Timestamp)row[10], (Integer)row[5]));
        }
        this.moveInterval(this.startTimestamp);
        while (this.upperTimestamp <= this.endTimestamp && this.lowerTimestamp != this.endTimestamp) {
            TreeMap<Object[], ProcessInstanceStateCumulants> cumulantsGroup;
            Interval interval = new Interval(new Timestamp(this.lowerTimestamp), new Timestamp(this.upperTimestamp));
            if (log.isDebugEnabled()) {
                log.debug("New Interval: (" + interval.getLowerTimestamp() + ", " + interval.getUpperTimestamp());
            }
            if ((cumulantsGroup = (TreeMap<Object[], ProcessInstanceStateCumulants>)this.cumulantsGroupPerInterval.get(interval)) == null) {
                cumulantsGroup = new TreeMap<Object[], ProcessInstanceStateCumulants>(new GroupByValuesComparator());
                this.cumulantsGroupPerInterval.put(interval, cumulantsGroup);
            }
            for (Object[] groupValue : this.groupProcessListMap.keySet()) {
                List processes = (List)this.groupProcessListMap.get(groupValue);
                if (processes == null) {
                    log.error("No vector for group by keys.");
                    continue;
                }
                ProcessInstanceStateCumulants cumulants = (ProcessInstanceStateCumulants)cumulantsGroup.get(groupValue);
                if (cumulants == null) {
                    cumulants = new ProcessInstanceStateCumulants(this.lowerTimestamp, this.upperTimestamp, this.useIntervalEnds);
                    cumulantsGroup.put(groupValue, cumulants);
                }
                Iterator iterator = processes.iterator();
                ProcessData processData = null;
                while (iterator.hasNext()) {
                    processData = (ProcessData)iterator.next();
                    cumulants.process(processData.getStartTime(), processData.getEndTime(), processData.getState());
                }
                if (processData == null) continue;
                this.processPerIntervallAndGroup.put(new IntervalGroupKey(interval, groupValue), processData);
            }
            this.moveInterval();
        }
        LogUtils.exitInternal(log, "processRows()");
    }

    @Override
    public void processRow(Object[] uncumulatedRow) {
        LogUtils.exitInternal(log, "processRows()");
        this.processRows(Arrays.asList(new Object[]{uncumulatedRow}));
        LogUtils.exitInternal(log, "processRows()");
    }

    protected void moveInterval() {
        this.moveInterval(this.upperTimestamp);
    }

    protected void moveInterval(long newLowerTimestamp) {
        this.lowerTimestamp = newLowerTimestamp;
        this.upperTimestamp = this.incrementTimestamp(this.lowerTimestamp, this.view.getIntervalType());
    }

    private static class IntervalGroupKey {
        private Interval interval;
        private Object[] groupValues;

        private IntervalGroupKey(Interval interval, Object[] groupValues) {
            this.interval = interval;
            this.groupValues = groupValues;
        }
    }

    private static class IntervalGroupKeyComparator
    implements Comparator {
        private IntervalComparator intervalComparator = new IntervalComparator();
        private GroupByValuesComparator groupValuesComparator = new GroupByValuesComparator();

        private IntervalGroupKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            IntervalGroupKey key1 = (IntervalGroupKey)o1;
            IntervalGroupKey key2 = (IntervalGroupKey)o2;
            int intervalResult = this.intervalComparator.compare(key1.interval, key2.interval);
            if (intervalResult != 0) {
                return intervalResult;
            }
            return this.groupValuesComparator.compare(key1.groupValues, key2.groupValues);
        }
    }

    protected static class ProcessData {
        private String modelId;
        private String processID;
        private String processName;
        private String processDescription;
        private long startTime;
        private Timestamp endTime;
        private int state;

        public ProcessData(String modelId, String processID, String processName, String processDescription, long startTime, Timestamp endTime, int state) {
            this.modelId = modelId;
            this.processID = processID;
            this.processName = processName;
            this.processDescription = processDescription;
            this.startTime = startTime;
            this.endTime = endTime;
            this.state = state;
        }

        public Timestamp getEndTime() {
            return this.endTime;
        }

        public String getProcessDescription() {
            return this.processDescription;
        }

        public String getModelId() {
            return this.modelId;
        }

        public String getProcessID() {
            return this.processID;
        }

        public String getProcessName() {
            return this.processName;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getState() {
            return this.state;
        }
    }
}

