/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.query.ProcessInstanceQuery;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.AbstractProcessInstanceView;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.ForeignDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelPropertyColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessInstanceStateCumulationAspect;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;

public class ProcessInstanceStateView
extends AbstractProcessInstanceView {
    private static Logger log = LogUtils.getLogger(ProcessInstanceStateView.class);

    public ProcessInstanceStateView() {
        super("ProcessState");
        DbColumn pId = new DbColumn("id", "p");
        DbColumn pName = new DbColumn("name", "p");
        DbColumn piOid = new DbColumn("oid", "pi");
        this.addParameter(ReportingCommon_Messages.ColumnProcessId, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessName, String.class, false, Parameter.STRING_DEFAULT_VALUE, pName.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false, Parameter.STRING_DEFAULT_VALUE, piOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceState, Integer.class, false, Parameter.STRING_DEFAULT_VALUE, "pi.state");
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.StartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.EndeDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnProcessDuration, Long.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter(ReportingCommon_Messages.ColumnProcessWorktime, Long.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter(ReportingCommon_Messages.ColumUseIntervalEnds, Boolean.class, false, "true", null);
        this.addParameter("UseOuterJoins", Boolean.class, false, "false", null);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(this.createPredefinedColumn("Model", ReportingCommon_Messages.ColumnModel, String.class, false, new DbColumnRef("id", "model", "m")));
        this.addGroupColumn(this.createPredefinedColumn("ID", ReportingCommon_Messages.ColumnId, String.class, false, new DbColumnRef("id", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("Name", ReportingCommon_Messages.ColumnName, String.class, false, new DbColumnRef("name", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("Description", ReportingCommon_Messages.ColumnDescription, String.class, false, new DbColumnRef("description", "process_definition", "p")));
        this.addGroupColumnCumulated(new GroupColumn((View)this, "IntervalTimestamp", ReportingCommon_Messages.ColumnIntervalTimesTamp, Timestamp.class, true, false));
        this.addGroupColumnCumulated(new GroupColumn(this, "CompletedProcesses", ReportingCommon_Messages.ColumnCompletedProcess, Integer.class));
        this.addGroupColumnCumulated(new GroupColumn(this, "ProcessesCompletedInInterval", ReportingCommon_Messages.ColumnProcessesCompletedInterval, Integer.class));
        this.addGroupColumnCumulated(new GroupColumn(this, "ActiveProcesses", ReportingCommon_Messages.ColumnActiveProcesses, Integer.class));
        this.addGroupColumnCumulated(new GroupColumn(this, "ProcessesStartedInInterval", ReportingCommon_Messages.ColumnProcessesStartedInInterval, Integer.class));
        this.addGroupColumn(this.createPredefinedColumn("OID", ReportingCommon_Messages.ColumnOid, Long.class, false, new DbColumnRef("oid", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("State", ReportingCommon_Messages.ColumnState, Integer.class, false, new DbColumnRef("state", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartingUser", ReportingCommon_Messages.ColumnStartingUser, Long.class, false, new DbColumnRef("startingUser", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartingActivityInstance", ReportingCommon_Messages.ColumnStartingActivityInstance, Long.class, false, new DbColumnRef("startingActivityInstance", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("RootProcessInstance", ReportingCommon_Messages.ColumnRootProcessInstance, Long.class, false, new DbColumnRef("rootProcessInstance", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartTimestamp", ReportingCommon_Messages.ColumnStartTimeStamp, Timestamp.class, false, new DbColumnRef("startTime", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("EndTimestamp", ReportingCommon_Messages.ColumnEndTimeStamp, Timestamp.class, false, new DbColumnRef("terminationTime", "process_instance", "pi")));
        this.setCumulated(true);
    }

    @Override
    public String getReportType() {
        return "ProcessState";
    }

    @Override
    public boolean canBeCumulated() {
        return true;
    }

    @Override
    public boolean mustBeCumulated() {
        return true;
    }

    @Override
    public List allowsUserDefinedDataColumns() {
        ArrayList<Class> classList = new ArrayList<Class>();
        classList.add(DataColumn.class);
        classList.add(StructDataDescriptor.class);
        classList.add(ForeignDataDescriptor.class);
        classList.add(ModelPropertyColumn.class);
        return classList;
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[10];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[11];
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        Localizer localizer = new Localizer(allDeployedModels);
        LogUtils.enterInternal(log, "evaluateResultSet()");
        boolean initLoginData = this.initLoginData();
        boolean canFetchProcess = true;
        try {
            Pair<Long, Long> startEnd = this.getStartEnd(parameterValues);
            long startTime = (Long)startEnd.getFirst();
            long endTime = (Long)startEnd.getSecond();
            boolean useIntervalEnds = this.useIntervalEnds(parameterValues);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            ProcessInstanceStateCumulationAspect cumulationAspect = new ProcessInstanceStateCumulationAspect(this, startTime, endTime, useIntervalEnds);
            while (resultSet.next()) {
                Long processWorktime;
                Long processDuration;
                long modelOid = resultSet.getLong(2);
                long processOid = resultSet.getLong(4);
                long scopeProcessInstanceOid = resultSet.getLong(14);
                if (initLoginData) {
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllProcessInstances", (Class[])new Class[]{ProcessInstanceQuery.class});
                    authorizationContext.setProcessData(scopeProcessInstanceOid, processOid, modelOid);
                    canFetchProcess = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                }
                if (!canFetchProcess) continue;
                Object[] row = new Object[this.getLeafColumnsUncumulated().size()];
                row[0] = resultSet.getString(1);
                String processId = resultSet.getString(3);
                String processName = resultSet.getString(5);
                String processDescription = resultSet.getString(6);
                processName = localizer.localizeProcessName(modelOid, processId, processName);
                processDescription = localizer.localizeProcessDescription(modelOid, processId, processDescription);
                row[1] = processId;
                row[2] = processName;
                row[3] = processDescription;
                row[4] = new Long(resultSet.getLong(7));
                row[5] = new Integer(resultSet.getInt(8));
                row[6] = new Long(resultSet.getLong(9));
                row[7] = new Long(resultSet.getLong(10));
                row[8] = new Long(resultSet.getLong(11));
                row[9] = new Timestamp(resultSet.getLong(12));
                if (resultSet.getLong(13) == 0L) {
                    row[10] = null;
                    processDuration = new Long((System.currentTimeMillis() - resultSet.getLong(12)) / 1000L);
                    processWorktime = new Long(this.worktimeCalculator.calculateWorktime(new Date(resultSet.getLong(12)), new Date(System.currentTimeMillis()), null));
                } else {
                    row[10] = new Timestamp(resultSet.getLong(13));
                    processDuration = new Long((resultSet.getLong(13) - resultSet.getLong(12)) / 1000L);
                    processWorktime = new Long(this.worktimeCalculator.calculateWorktime(new Date(resultSet.getLong(12)), new Date(resultSet.getLong(13)), null));
                }
                if (!ProcessInstanceStateView.matchValueInSecondsToPattern(processDuration, this.getDurationPattern(parameterValues)) || !ProcessInstanceStateView.matchValueInSecondsToPattern(processWorktime, this.getWorktimePattern(parameterValues))) continue;
                int columnIndex = 15;
                int n = 11;
                while (n < 11 + this.getUserDefinedColumnsCount()) {
                    Column column = (Column)this.getLeafColumnsUncumulated().get(n);
                    if (column instanceof DataColumn) {
                        Object[] values = DataColumn.determineValue(resultSet.getObject(columnIndex) == null ? -1 : resultSet.getInt(columnIndex), resultSet.getString(columnIndex + 1), resultSet.getLong(columnIndex + 2));
                        row[n] = values[1];
                        columnIndex += 2;
                    } else if (column instanceof ForeignDataColumn) {
                        Object value;
                        ForeignDataColumn foreignDataColumn = (ForeignDataColumn)column;
                        row[n] = value = SqlUtils.getColumnValue(foreignDataColumn, resultSet, columnIndex);
                    } else if (column instanceof ModelPropertyColumn) {
                        ModelPropertyColumn modelPropertyColumn = (ModelPropertyColumn)column;
                        IModel model = ProcessInstanceStateView.findModelByOID(allDeployedModels, resultSet.getInt(1));
                        IProcessDefinition processDefinition = model.findProcessDefinition(resultSet.getString(2));
                        Object pdAttribute = processDefinition.getAttribute(modelPropertyColumn.getPropertyFullName());
                        row[n] = pdAttribute != null ? pdAttribute.toString() : "";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Adding user defined column " + n + " = " + row[n] + " retrieval column index " + columnIndex);
                    }
                    ++columnIndex;
                    ++n;
                }
                rows.add(row);
                if (1000 != rows.size()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(rows.size() + " uncumulated rows collected.");
                }
                cumulationAspect.processRows(rows);
                rows = new ArrayList();
            }
            if (rows.size() != 0) {
                if (log.isDebugEnabled()) {
                    log.debug(rows.size() + " uncumulated rows collected.");
                }
                cumulationAspect.processRows(rows);
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(cumulationAspect.getCumulatedRows());
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }
}

