/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.stardust.common.OneElementIterator;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.engine.core.runtime.utils.ExecutionPermission;
import org.eclipse.stardust.reporting.common.AbstractProcessInstanceView;
import org.eclipse.stardust.reporting.common.ActivityMetricsColumn;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.CumulationAspect;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.EnumStructDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupByValuesComparator;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.Interval;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelPropertyColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.PredefinedForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.PredefinedForeignDataFactory;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataColumn;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.StringDataSubstitutionTable;

public class ProcessInstanceView
extends AbstractProcessInstanceView {
    static Logger log = LogUtils.getLogger(ProcessInstanceView.class);
    static Logger perf = LogUtils.getLogger(String.valueOf(ProcessInstanceView.class.getName()) + "PERF", "DEBUG");
    boolean addTotalActiveTimeColumn;
    private StringDataSubstitutionTable substitutionTable = new StringDataSubstitutionTable();
    private AuthorizationContext checkReadDataContext;
    private AbstractAuthorization2Predicate checkReadDataPredicate;

    public ProcessInstanceView() {
        super("ProcessInstance");
        DbColumn pId = new DbColumn("id", "p");
        DbColumn pName = new DbColumn("name", "p");
        DbColumn piOid = new DbColumn("oid", "pi");
        DbColumn piState = new DbColumn("state", "pi");
        this.addParameter(ReportingCommon_Messages.ColumnProcessId, String.class, false, Parameter.STRING_DEFAULT_VALUE, pId.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessName, String.class, false, Parameter.STRING_DEFAULT_VALUE, pName.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceOid, Long.class, false, Parameter.STRING_DEFAULT_VALUE, piOid.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnProcessInstanceState, Integer.class, false, "2", piState.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ColumnProcessDuration, Long.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter(ReportingCommon_Messages.ColumnProcessWorktime, Long.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter(ReportingCommon_Messages.ColumnUseIntervalEnds, Boolean.class, false, "true", null);
        this.addParameter(ReportingCommon_Messages.ColumnUseOuterJoins, Boolean.class, false, "false", null);
        this.addParameter(ReportingCommon_Messages.ColumnIntervalPiStateFilter, String.class, false, ProcessInstanceIntervalStateFilter.STARTED_LITERAL, null);
        this.addParameter(ReportingCommon_Messages.ColumnSubProcessId, String.class, false, Parameter.STRING_DEFAULT_VALUE, "spiat.sub_pd_id");
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[12];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[13];
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(this.createPredefinedColumn("ModelID", ReportingCommon_Messages.ColumnModelId, String.class, false, new DbColumnRef("id", "model", "m")));
        this.addGroupColumn(this.createPredefinedColumn("ID", ReportingCommon_Messages.ColumnId, String.class, false, new DbColumnRef("id", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("Name", ReportingCommon_Messages.ColumnName, String.class, false, new DbColumnRef("name", "process_definition", "p")));
        this.addGroupColumn(this.createPredefinedColumn("Description", ReportingCommon_Messages.ColumnDescription, String.class, false, new DbColumnRef("description", "process_definition", "p")));
        this.addGroupColumnCumulated(new GroupColumn((View)this, "IntervalTimestamp", ReportingCommon_Messages.ColumnIntervalTimestamp, Timestamp.class, true, false));
        this.addGroupColumnCumulated(new GroupColumn((View)this, "Volume", ReportingCommon_Messages.ColumnVolume, Integer.class, true, false));
        this.addGroupColumn(this.createPredefinedColumn("OID", ReportingCommon_Messages.ColumnOid, Long.class, false, new DbColumnRef("oid", "process_instance", "pi")));
        this.addGroupColumn(this.createPredefinedColumn("State", ReportingCommon_Messages.ColumnState, Integer.class, false, new DbColumnRef("state", "process_instance", "pi")));
        this.addGroupColumn(this.createPredefinedColumn("StartingUser", ReportingCommon_Messages.ColumnStartingUser, Long.class, false, new DbColumnRef("startingUser", "process_instance", "pi")));
        this.addGroupColumn(this.createPredefinedColumn("StartingActivityInstance", ReportingCommon_Messages.ColumnStartingActivityInstance, Long.class, false, new DbColumnRef("startingActivityInstance", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("RootProcessInstance", ReportingCommon_Messages.ColumnRootProcessInstance, Long.class, false, new DbColumnRef("rootProcessInstance", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("StartTimestamp", ReportingCommon_Messages.ColumnStartTimeStamp, Timestamp.class, false, new DbColumnRef("startTime", "process_instance", "pi")));
        this.addGroupColumnUncumulated(this.createPredefinedColumn("EndTimestamp", ReportingCommon_Messages.ColumnEndTimeStamp, Timestamp.class, false, new DbColumnRef("terminationTime", "process_instance", "pi")));
        this.addGroupColumn(new GroupColumn((View)this, "ProcessDuration", ReportingCommon_Messages.ColumnProcessDuration, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "ProcessWorktime", ReportingCommon_Messages.ColumnProcessWorktime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "TotalActiveTime", ReportingCommon_Messages.ColumnTotalActiveTime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "SubTotalActiveTime", ReportingCommon_Messages.ColumnSubTotalActiveTime, Long.class, true, true));
        this.addGroupColumn(new GroupColumn((View)this, "SubProcessesWorktime", ReportingCommon_Messages.ColumnSubProcessesWorkTime, Long.class, true, true));
        this.addOptionalColumnProvider(PredefinedForeignDataFactory.STARTING_PROCESS_ID.getInstance(this, ReportingCommon_Messages.ColumnStartingActivityInstance, ReportingCommon_Messages.ColumnStartingProcessId, String.class, "id"));
    }

    @Override
    protected int getUncumulatedTimestampColumnIndex() {
        return 9;
    }

    @Override
    protected int getCumulatedTimestampColumnIndex() {
        return 4;
    }

    @Override
    protected int getCumulatedVolumeColumnIndex() {
        return 5;
    }

    @Override
    public String getReportType() {
        return "ProcessInstance";
    }

    @Override
    public boolean canBeCumulated() {
        return true;
    }

    @Override
    public List allowsUserDefinedDataColumns() {
        ArrayList<Class> classList = new ArrayList<Class>();
        classList.add(DataColumn.class);
        classList.add(EnumStructDataColumn.class);
        classList.add(StructDataDescriptor.class);
        classList.add(ActivityMetricsColumn.class);
        classList.add(ForeignDataDescriptor.class);
        classList.add(ModelPropertyColumn.class);
        classList.add(PredefinedForeignDataDescriptor.class);
        classList.add(DataPrefetchColumn.class);
        return classList;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        Localizer localizer = new Localizer(allDeployedModels);
        LogUtils.enterInternal(log, "evaluateResultSet()");
        LogUtils.enterInternal(perf, "evaluateResultSet()");
        boolean canFetchProcess = true;
        try {
            Pair<Long, Long> startEnd = this.getStartEnd(parameterValues);
            long startTime = (Long)startEnd.getFirst();
            long endTime = (Long)startEnd.getSecond();
            List<Object[]> rows = new ArrayList();
            StateFilterCumulationAspect cumulationAspect = null;
            if (this.isCumulated()) {
                cumulationAspect = new StateFilterCumulationAspect(this, startTime, endTime, this.getPiIntervalStateFilter(parameterValues), this.useIntervalEnds(parameterValues));
            }
            int rowIndex = -1;
            while (resultSet.next()) {
                long modelOid = resultSet.getLong(2);
                long processOid = resultSet.getLong(4);
                long scopeProcessInstanceOid = resultSet.getLong(14);
                if (this.initLoginData) {
                    this.authPredicate.accept((Object)resultSet);
                    this.authorizationContext.setProcessData(scopeProcessInstanceOid, processOid, modelOid);
                    canFetchProcess = Authorization2.hasPermission((AuthorizationContext)this.authorizationContext);
                }
                if (!canFetchProcess) continue;
                Object[] row = new Object[this.getLeafColumnsUncumulated().size()];
                ++rowIndex;
                row[0] = resultSet.getString(1);
                String processId = resultSet.getString(3);
                String processName = resultSet.getString(5);
                String processDescription = resultSet.getString(6);
                processName = localizer.localizeProcessName(modelOid, processId, processName);
                processDescription = localizer.localizeProcessDescription(modelOid, processId, processDescription);
                row[1] = processId;
                row[2] = processName;
                row[3] = processDescription;
                Long currentProcessInstanceOid = new Long(resultSet.getLong(7));
                row[4] = currentProcessInstanceOid;
                row[5] = new Integer(resultSet.getInt(8));
                row[6] = new Long(resultSet.getLong(9));
                row[7] = new Long(resultSet.getLong(10));
                row[8] = new Long(resultSet.getLong(11));
                row[9] = new Timestamp(resultSet.getLong(12));
                if (0L == resultSet.getLong(13)) {
                    row[10] = null;
                    row[11] = new Long((System.currentTimeMillis() - resultSet.getLong(12)) / 1000L);
                    row[12] = new Long(this.worktimeCalculator.calculateWorktime(new Date(resultSet.getLong(12)), new Date(System.currentTimeMillis()), null));
                } else {
                    row[10] = new Timestamp(resultSet.getLong(13));
                    row[11] = new Long((resultSet.getLong(13) - resultSet.getLong(12)) / 1000L);
                    row[12] = new Long(this.worktimeCalculator.calculateWorktime(new Date(resultSet.getLong(12)), new Date(resultSet.getLong(13)), null));
                }
                if (!ProcessInstanceView.matchValueInSecondsToPattern((Long)row[11], this.getDurationPattern(parameterValues)) || !ProcessInstanceView.matchValueInSecondsToPattern((Long)row[12], this.getWorktimePattern(parameterValues))) continue;
                int rsColumnIndex = 15;
                if (this.isAddingTotalActiveTimeColumn()) {
                    rsColumnIndex = 19;
                }
                int rowColumnIndex = 16;
                while (rowColumnIndex < 16 + this.getUserDefinedColumnsCount()) {
                    Column column = (Column)this.getLeafColumnsUncumulated().get(rowColumnIndex);
                    if (column instanceof IDataColumn) {
                        if (this.hasReadDataPermission((IDataColumn)((Object)column), currentProcessInstanceOid, modelOid, resultSet)) {
                            int type = resultSet.getObject(rsColumnIndex) == null ? -1 : resultSet.getInt(rsColumnIndex);
                            long oid = resultSet.getLong(rsColumnIndex + 3);
                            if (type == 11 && !this.isCumulated()) {
                                if (column instanceof StructDataColumn) {
                                    // empty if block
                                }
                                this.substitutionTable.addColumn(rowIndex, rowColumnIndex, oid);
                            }
                            Object[] values = DataColumn.determineValue(type, resultSet.getString(rsColumnIndex + 1), resultSet.getLong(rsColumnIndex + 2));
                            row[rowColumnIndex] = values[1];
                        }
                        rsColumnIndex += 3;
                    } else if (column instanceof ActivityMetricsColumn) {
                        ActivityMetricsColumn activityMetricsColumn = (ActivityMetricsColumn)column;
                        if (activityMetricsColumn.getFromActivityID() == null) {
                            row[rowColumnIndex] = new Long((resultSet.getLong(rsColumnIndex) - resultSet.getLong(9)) / 1000L);
                        } else {
                            row[rowColumnIndex] = new Long((resultSet.getLong(rsColumnIndex + 1) - resultSet.getLong(rsColumnIndex)) / 1000L);
                            ++rsColumnIndex;
                        }
                    } else if (column instanceof ForeignDataColumn) {
                        Object value;
                        ForeignDataColumn foreignDataColumn = (ForeignDataColumn)column;
                        row[rowColumnIndex] = value = SqlUtils.getColumnValue(foreignDataColumn, resultSet, rsColumnIndex);
                    } else if (column instanceof ModelPropertyColumn) {
                        ModelPropertyColumn modelPropertyColumn = (ModelPropertyColumn)column;
                        IModel model = ProcessInstanceView.findModelByOID(allDeployedModels, resultSet.getInt(1));
                        IProcessDefinition processDefinition = model.findProcessDefinition(resultSet.getString(2));
                        Object pdAttribute = processDefinition.getAttribute(modelPropertyColumn.getPropertyFullName());
                        row[rowColumnIndex] = pdAttribute != null ? pdAttribute.toString() : "";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Adding user defined column " + rowColumnIndex + " = " + row[rowColumnIndex] + " retrieval column index " + rsColumnIndex);
                    }
                    ++rsColumnIndex;
                    ++rowColumnIndex;
                }
                if (this.isAddingTotalActiveTimeColumn()) {
                    row[13] = new Long(resultSet.getLong(15) / 1000L);
                    long subPiTotalActiveTime = 0L;
                    long subPiTotalWorktime = 0L;
                    while (currentProcessInstanceOid.equals(new Long(resultSet.getLong(7)))) {
                        long subPiActiveTime = resultSet.getLong(16);
                        subPiTotalActiveTime += subPiActiveTime;
                        long subPiStarttime = resultSet.getLong(17);
                        if (!resultSet.wasNull()) {
                            long subPiTermination = resultSet.getLong(18);
                            subPiTotalWorktime = subPiTermination == 0L ? (subPiTotalWorktime += this.worktimeCalculator.calculateWorktime(new Date(subPiStarttime), new Date(System.currentTimeMillis()), null)) : (subPiTotalWorktime += this.worktimeCalculator.calculateWorktime(new Date(subPiStarttime), new Date(subPiTermination), null));
                        }
                        if (resultSet.next()) continue;
                    }
                    resultSet.previous();
                    row[14] = new Long(subPiTotalActiveTime / 1000L);
                    row[15] = new Long(subPiTotalWorktime);
                    rsColumnIndex += 4;
                }
                if (this.isCumulated()) {
                    cumulationAspect.processRow(row);
                    continue;
                }
                rows.add(row);
            }
            if (log.isDebugEnabled()) {
                log.debug(rows.size() + " uncumulated rows collected.");
            }
            if (perf.isDebugEnabled()) {
                perf.debug(rows.size() + " uncumulated rows collected.");
            }
            if (this.isCumulated()) {
                rows = cumulationAspect.getCumulatedRows();
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            LogUtils.exitInternal(perf, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[][] postProcessResults(Object[][] results, Connection connection, Object[] parameters) {
        try {
            try {
                results = this.substitutionTable.substitute(results, connection, this.getDefaultSchemaName(), parameters);
            }
            catch (SQLException e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            this.substitutionTable.clear();
        }
        return results;
    }

    @Override
    public boolean canAddTotalActiveTimeColumn() {
        return true;
    }

    @Override
    public boolean isAddingTotalActiveTimeColumn() {
        return this.addTotalActiveTimeColumn;
    }

    @Override
    public void setAddingTotalActiveTimeColumn(boolean addTotalActiveTimeColumn) {
        this.addTotalActiveTimeColumn = addTotalActiveTimeColumn;
    }

    protected ProcessInstanceIntervalStateFilter getPiIntervalStateFilter(Object[] parameters) {
        String filterName = (String)parameters[10];
        if (ProcessInstanceIntervalStateFilter.ACTIVE_LITERAL.equalsIgnoreCase(filterName)) {
            return ProcessInstanceIntervalStateFilter.ACTIVE;
        }
        if (ProcessInstanceIntervalStateFilter.COMPLETE_LITERAL.equalsIgnoreCase(filterName)) {
            return ProcessInstanceIntervalStateFilter.COMPLETE;
        }
        if (ProcessInstanceIntervalStateFilter.STARTED_LITERAL.equalsIgnoreCase(filterName)) {
            return ProcessInstanceIntervalStateFilter.STARTED;
        }
        if (ProcessInstanceIntervalStateFilter.COMPLETED_LITERAL.equalsIgnoreCase(filterName)) {
            return ProcessInstanceIntervalStateFilter.COMPLETED;
        }
        return ProcessInstanceIntervalStateFilter.STARTED;
    }

    @Override
    protected StringBuffer getCumulationTimeSqlFragment(Object[] parameters) {
        if (ProcessInstanceIntervalStateFilter.STARTED == this.getPiIntervalStateFilter(parameters)) {
            return this.getBaseTimeSqlFragment(parameters);
        }
        return super.getCumulationTimeSqlFragment(parameters);
    }

    private boolean hasReadDataPermission(IDataColumn column, long processInstanceOid, long modelOid, ResultSet rs) {
        List dataValueInfos;
        DataInfo info;
        if (this.checkReadDataContext == null) {
            this.checkReadDataContext = AuthorizationContext.create(ProcessInstanceView.class, (String)"checkReadDataPermission", (Class[])new Class[0]);
        }
        if ((info = this.findDataForColumnAndModel(column, modelOid, dataValueInfos = (List)this.dataValueInfoMap.get(column))) != null) {
            long dataOId = info.getDataOid();
            this.checkReadDataContext.setData(processInstanceOid, modelOid, dataOId);
            return Authorization2.hasPermission((AuthorizationContext)this.checkReadDataContext);
        }
        return true;
    }

    @ExecutionPermission(id=ExecutionPermission.Id.readDataValues, scope=ExecutionPermission.Scope.data, defer=true, defaults={ExecutionPermission.Default.ALL})
    public void checkReadDataPermission() {
    }

    private static class ProcessInstanceIntervalStateFilter {
        public static final int NONE_VALUE = 0;
        public static final int ACTIVE_VALUE = 1;
        public static final int COMPLETE_VALUE = 2;
        public static final int STARTED_VALUE = 3;
        public static final int COMPLETED_VALUE = 4;
        public static String NONE_LITERAL = ReportingCommon_Messages.TextNone;
        public static String ACTIVE_LITERAL = ReportingCommon_Messages.TextActive;
        public static String COMPLETE_LITERAL = ReportingCommon_Messages.TextComplete;
        public static String STARTED_LITERAL = ReportingCommon_Messages.textStarted;
        public static String COMPLETED_LITERAL = ReportingCommon_Messages.TextCompleted;
        private int value;
        private String name;
        public static ProcessInstanceIntervalStateFilter NONE = new ProcessInstanceIntervalStateFilter(NONE_LITERAL, 0);
        public static ProcessInstanceIntervalStateFilter ACTIVE = new ProcessInstanceIntervalStateFilter(ACTIVE_LITERAL, 1);
        public static ProcessInstanceIntervalStateFilter COMPLETE = new ProcessInstanceIntervalStateFilter(COMPLETE_LITERAL, 2);
        public static ProcessInstanceIntervalStateFilter STARTED = new ProcessInstanceIntervalStateFilter(STARTED_LITERAL, 3);
        public static ProcessInstanceIntervalStateFilter COMPLETED = new ProcessInstanceIntervalStateFilter(COMPLETED_LITERAL, 4);

        protected int getValue() {
            return this.value;
        }

        protected String getName() {
            return this.name;
        }

        private ProcessInstanceIntervalStateFilter(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    private class StateFilterCumulationAspect
    extends CumulationAspect {
        private ProcessInstanceIntervalStateFilter intervalPiStateFilter;
        private boolean useIntervalEnds;
        private List intervals;
        private Map intervalGroupByEvaluatorsMap;

        protected StateFilterCumulationAspect(View view, long startTimestamp, long endTimestamp, ProcessInstanceIntervalStateFilter intervalStateFilter, boolean useIntervalEnds) {
            super(view);
            this.intervals = new ArrayList();
            this.intervalGroupByEvaluatorsMap = new HashMap();
            this.initializeTimestamps(startTimestamp, endTimestamp);
            this.intervalPiStateFilter = intervalStateFilter;
            this.useIntervalEnds = useIntervalEnds;
            this.moveInterval(startTimestamp);
            while (this.upperTimestamp <= endTimestamp && this.lowerTimestamp != endTimestamp) {
                this.intervals.add(new Interval(new Timestamp(this.lowerTimestamp), new Timestamp(this.upperTimestamp)));
                this.moveInterval();
            }
            for (Interval interval : this.intervals) {
                CumulationAspect.LazyInitializerMap groupByCumulantsArrayMap = new CumulationAspect.LazyInitializerMap(this, new TreeMap(new GroupByValuesComparator()), new CumulationAspect.CumulantsInitializer(this));
                CumulationAspect.LazyInitializerMap groupByDistinctEvalArrayMap = new CumulationAspect.LazyInitializerMap(this, new TreeMap(new GroupByValuesComparator()), new CumulationAspect.DistinctEvaluatorInitializer(this));
                if (this.handleGrouping()) {
                    this.groupByColumnIndexes = new int[view.getGroupByGroupColumns().size()];
                    int n = 0;
                    while (n < view.getGroupByGroupColumns().size()) {
                        this.groupByColumnIndexes[n] = view.getColumnIndexUncumulated((GroupColumn)view.getGroupByGroupColumns().get(n));
                        ++n;
                    }
                } else {
                    this.initializeEvaluators((Iterator)new OneElementIterator((Object)NULL_GROUP_VALUE), groupByCumulantsArrayMap, groupByDistinctEvalArrayMap);
                }
                this.intervalGroupByEvaluatorsMap.put(interval, new Pair((Object)groupByCumulantsArrayMap, (Object)groupByDistinctEvalArrayMap));
            }
        }

        @Override
        public List getCumulatedRows() {
            ArrayList resultList = new ArrayList();
            for (Interval interval : this.intervals) {
                Pair evaluators = (Pair)this.intervalGroupByEvaluatorsMap.get(interval);
                Map groupByCumulantsArrayMap = (Map)evaluators.getFirst();
                Map groupByDistinctEvalArrayMap = (Map)evaluators.getSecond();
                resultList.addAll(this.getCollectedRows(interval.getLowerTimestamp(), groupByCumulantsArrayMap, groupByDistinctEvalArrayMap));
            }
            return resultList;
        }

        @Override
        public void processRow(Object[] uncumulatedRow) {
            LogUtils.enterInternal(log, "processRow()");
            int processState = (Integer)uncumulatedRow[5];
            Timestamp startTime = (Timestamp)uncumulatedRow[9];
            Timestamp terminationTime = (Timestamp)uncumulatedRow[10];
            if (log.isDebugEnabled()) {
                log.debug("Interval processing");
            }
            for (Interval interval : this.intervals) {
                boolean doProcess;
                switch (this.intervalPiStateFilter.getValue()) {
                    case 3: {
                        doProcess = this.isStartedInInterval(interval, processState, startTime, terminationTime);
                        break;
                    }
                    case 4: {
                        doProcess = this.isCompletedInInterval(interval, processState, startTime, terminationTime);
                        break;
                    }
                    case 1: {
                        doProcess = this.isActiveInInterval(interval, processState, startTime, terminationTime);
                        break;
                    }
                    case 2: {
                        doProcess = this.isCompleteInInterval(interval, processState, startTime, terminationTime);
                        break;
                    }
                    default: {
                        log.error(MessageFormat.format("Cannot handle ProcessInstanceIntervalStateFilter with name = {0} and value = {1}.", this.intervalPiStateFilter.getName(), new Integer(this.intervalPiStateFilter.getValue())));
                        return;
                    }
                }
                if (!doProcess) continue;
                Pair evaluators = (Pair)this.intervalGroupByEvaluatorsMap.get(interval);
                Map groupByCumulantsArrayMap = (Map)evaluators.getFirst();
                Map groupByDistinctEvalArrayMap = (Map)evaluators.getSecond();
                this.doProcessRow(uncumulatedRow, groupByCumulantsArrayMap, groupByDistinctEvalArrayMap);
            }
            LogUtils.exitInternal(log, "processRow()");
        }

        @Override
        public void processRows(List uncumulatedRows) {
        }

        private boolean isCompleteInInterval(Interval interval, int processState, Timestamp startTime, Timestamp terminationTime) {
            if (this.useIntervalEnds) {
                return 2 == processState && (interval.endedBeforeInterval(terminationTime) || interval.endedInInterval(terminationTime));
            }
            return 2 == processState && interval.endedBeforeInterval(terminationTime);
        }

        private boolean isStartedInInterval(Interval interval, int processState, Timestamp startTime, Timestamp terminationTime) {
            return interval.startedInInterval(startTime.getTime());
        }

        private boolean isCompletedInInterval(Interval interval, int processState, Timestamp startTime, Timestamp terminationTime) {
            return 2 == processState && interval.endedInInterval(terminationTime);
        }

        private boolean isActiveInInterval(Interval interval, int processState, Timestamp startTime, Timestamp terminationTime) {
            if (this.useIntervalEnds) {
                if (2 == processState) {
                    return !interval.startedAfterInterval(startTime.getTime()) && interval.endedAfterInterval(terminationTime);
                }
                if (1 != processState) {
                    return !interval.startedAfterInterval(startTime.getTime());
                }
                return false;
            }
            if (2 == processState) {
                return interval.startedBeforeInterval(startTime.getTime()) && (interval.endedInInterval(terminationTime) || interval.endedAfterInterval(terminationTime));
            }
            if (1 != processState) {
                return interval.startedBeforeInterval(startTime.getTime());
            }
            return false;
        }
    }
}

