/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.Serialization;
import org.eclipse.stardust.engine.api.dto.ActivityInstanceAttributes;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.QualityAssuranceCode;
import org.eclipse.stardust.reporting.common.AbstractQualityAssuranceView;
import org.eclipse.stardust.reporting.common.DbAwareGroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.LargeStringResolver;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.OuterJoinExpression;

public class QualityAssuranceCodeView
extends AbstractQualityAssuranceView {
    private static Logger log = LogUtils.getLogger(QualityAssuranceCodeView.class);
    public static final String REPORT_TYPE = "QualityAssuranceCodesView";
    private static final String AI_PROPERTY_ALIAS = "aip";
    private DbAwareGroupColumn activityInstanceOidColumn;
    private DbAwareGroupColumn qaCodeKeyColumn;
    private DbAwareGroupColumn qaCodeValueColumn;
    private DbAwareGroupColumn qaAssignDateColumn;
    private List<DbAwareGroupColumn> reportColumns;
    private DbColumn modelOidColumn;
    private DbColumn aiPropertyOidColumn;

    public QualityAssuranceCodeView() {
        super(REPORT_TYPE);
    }

    @Override
    protected void createDefaultFields() {
        this.reportColumns = new ArrayList<DbAwareGroupColumn>();
        this.activityInstanceOidColumn = new DbAwareGroupColumn(this, "ActivityInstanceOid", ReportingCommon_Messages.ActivityInstanceOid, String.class);
        this.qaCodeKeyColumn = new DbAwareGroupColumn(this, "QualityAssuranceCodeKey", ReportingCommon_Messages.QualityAssuranceCodeKey, String.class);
        this.qaCodeValueColumn = new DbAwareGroupColumn(this, "QualityAssuranceCodeValue", ReportingCommon_Messages.QualityAssuranceCodeValue, String.class);
        this.qaAssignDateColumn = new DbAwareGroupColumn(this, "AssignDate", ReportingCommon_Messages.AssignDate, Date.class);
        this.reportColumns.add(this.activityInstanceOidColumn);
        this.reportColumns.add(this.qaCodeKeyColumn);
        this.reportColumns.add(this.qaCodeValueColumn);
        this.reportColumns.add(this.qaAssignDateColumn);
        this.addGroupColumns(this.reportColumns);
    }

    @Override
    public String getReportType() {
        return REPORT_TYPE;
    }

    @Override
    protected AbstractQualityAssuranceView.QaSqlStructure prepareStructure(Object[] parameters) throws SQLException {
        AbstractQualityAssuranceView.QaSqlStructure structure = super.prepareStructure(parameters);
        DbTable activityInstanceTable = structure.getFromTable();
        DbTable aiPropertyTable = new DbTable(this.getDefaultSchemaName(), "act_inst_property", AI_PROPERTY_ALIAS);
        this.modelOidColumn = structure.getModelOidColumn();
        DbColumn aiOidColumn = activityInstanceTable.getColumn("oid");
        this.aiPropertyOidColumn = aiPropertyTable.getColumn("oid");
        DbColumn aiStartTimeColumn = activityInstanceTable.getColumn("startTime");
        DbColumn aiPropertyObjectOidColumn = aiPropertyTable.getColumn("objectOID");
        DbColumn aiPropertyNameColumn = aiPropertyTable.getColumn("name");
        OuterJoinExpression joinQaStateExpression = new OuterJoinExpression(aiPropertyTable);
        joinQaStateExpression.AND(aiOidColumn, CompareOperator.EQUALS, aiPropertyObjectOidColumn);
        joinQaStateExpression.AND(aiPropertyNameColumn, CompareOperator.EQUALS, ActivityInstanceAttributes.class.getSimpleName());
        this.activityInstanceOidColumn.setDbColumn(aiOidColumn);
        this.qaAssignDateColumn.setDbColumn(aiStartTimeColumn);
        structure.addExpressions(joinQaStateExpression);
        for (DbAwareGroupColumn reportColumm : this.reportColumns) {
            DbColumn selectedColumn = reportColumm.getDbColumn();
            if (selectedColumn == null) continue;
            structure.addSelectColumn(reportColumm.getDbColumn());
        }
        structure.addSelectColumn(this.modelOidColumn);
        structure.addSelectColumn(this.aiPropertyOidColumn);
        return structure;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        Localizer localizer = new Localizer(allDeployedModels);
        this.connection = connection;
        LogUtils.enterInternal(log, "executeQuery(" + connection + ")");
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String internalQueryString = this.getQueryString(allDeployedModels, parameterValues);
            ps = connection.prepareStatement(internalQueryString);
            rs = SqlUtils.performQuery(ps, internalQueryString);
            Map<Long, String> resolvedAiAttributesStrings = this.getResolvedAiAttributesStrings(rs);
            rs = SqlUtils.performQuery(ps, internalQueryString);
            Object[][] objectArray = this.getErrorCodesResults(localizer, resolvedAiAttributesStrings, rs);
            return objectArray;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            LogUtils.exitInternal(log, "executeQuery(" + connection + ")");
        }
    }

    private Map<Long, String> getResolvedAiAttributesStrings(ResultSet resultSet) throws SQLException {
        HashSet<Long> aiAttributesOids = new HashSet<Long>();
        HashMap<Long, String> resolvedStrings = new HashMap();
        while (resultSet.next()) {
            Long aiPropertyOid = this.aiPropertyOidColumn.getLongValue(resultSet);
            if (aiPropertyOid == null || aiPropertyOid <= 0L) continue;
            aiAttributesOids.add(aiPropertyOid);
        }
        LargeStringResolver resolver = new LargeStringResolver(aiAttributesOids, "act_inst_property");
        resolvedStrings = resolver.resolve(this.connection, this.getDefaultSchemaName());
        return resolvedStrings;
    }

    private Object[][] getErrorCodesResults(Localizer localizer, Map<Long, String> resolvedStrings, ResultSet resultSet) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSet.next()) {
            if (!this.authorizationManager.isAuthorized(resultSet)) continue;
            long modelOid = this.modelOidColumn.getLongValue(resultSet);
            Set<QualityAssuranceCode> qaCodes = this.getQaCodes(resolvedStrings, resultSet);
            if (qaCodes == null || qaCodes.isEmpty()) continue;
            for (QualityAssuranceCode code : qaCodes) {
                if (code == null) continue;
                String codeKey = code.getCode();
                String description = code.getDescription();
                Object[] row = new Object[this.reportColumns.size()];
                int i = 0;
                while (i < this.reportColumns.size()) {
                    DbAwareGroupColumn column = this.reportColumns.get(i);
                    if (column.equals(this.qaCodeKeyColumn)) {
                        row[i] = codeKey;
                    } else if (column.equals(this.qaCodeValueColumn)) {
                        String codeValue = localizer.localizeQualityAssuranceCode(modelOid, codeKey, description);
                        row[i] = codeValue;
                    } else {
                        row[i] = column.getValue(resultSet);
                    }
                    ++i;
                }
                rows.add(row);
            }
        }
        return this.convertRowsToRowSet(rows);
    }

    private Set<QualityAssuranceCode> getQaCodes(Map<Long, String> resolvedStrings, ResultSet rs) throws SQLException {
        Set<QualityAssuranceCode> qaCodes = new HashSet<QualityAssuranceCode>();
        Long aiPropertyOid = this.aiPropertyOidColumn.getLongValue(rs);
        if (aiPropertyOid != null && aiPropertyOid > 0L) {
            String aiAttributesAsString = resolvedStrings.get(aiPropertyOid);
            qaCodes = this.getQaCodes(aiAttributesAsString);
        }
        return qaCodes;
    }

    private Set<QualityAssuranceCode> getQaCodes(String serializedAiAttributes) {
        Set<Object> qaCodes = new HashSet<QualityAssuranceCode>();
        ActivityInstanceAttributes aiAttributes = null;
        try {
            aiAttributes = (ActivityInstanceAttributes)Serialization.deserializeObject((byte[])Base64.decode((byte[])serializedAiAttributes.getBytes()));
        }
        catch (Exception e) {
            log.error("Exception during getting ActivityInstanceAttribute object ", e);
        }
        if (aiAttributes != null && aiAttributes.getQualityAssuranceResult() != null) {
            qaCodes = aiAttributes.getQualityAssuranceResult().getQualityAssuranceCodes();
        }
        return qaCodes;
    }
}

