/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.Serialization;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.dto.ActivityInstanceAttributes;
import org.eclipse.stardust.engine.api.dto.QualityAssuranceResult;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.runtime.QualityAssuranceUtils;
import org.eclipse.stardust.reporting.common.AbstractQualityAssuranceView;
import org.eclipse.stardust.reporting.common.DbAwareGroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ModelUtils;
import org.eclipse.stardust.reporting.common.utils.StringDataSubstitutionTable;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.OuterJoinExpression;

public class QualityAssuranceView
extends AbstractQualityAssuranceView {
    public static final String AI_PROPERTY_ALIAS_QASTATE = "aipqas";
    public static final String AI_PROPERTY_ALIAS_QARESULT = "aipqar";
    private static Logger log = LogUtils.getLogger(QualityAssuranceView.class);
    public static final String QA_VIEW_REPORT_TYPE = "QualityAssuranceView";
    private List<DbAwareGroupColumn> reportColumns;
    private DbAwareGroupColumn processDefinitionNameReportColumn;
    private DbAwareGroupColumn processDefinitionOidReportColumn;
    private DbAwareGroupColumn processInstanceOidReportColumn;
    private DbAwareGroupColumn activityNameReportColumn;
    private DbAwareGroupColumn activityOidReportColumn;
    private DbAwareGroupColumn activityInstanceOidReportColumn;
    private DbAwareGroupColumn activityInstanceStateReportColumn;
    private DbAwareGroupColumn qaStateReportColumn;
    private DbAwareGroupColumn qaResultStateReportColumn;
    private ResultStateSubstitutionTable substitutionTable = new ResultStateSubstitutionTable();
    private DbColumn modelOidColumn;
    private DbColumn activityIdColumn;
    private DbColumn processDefIdColumn;

    public QualityAssuranceView() {
        super(QA_VIEW_REPORT_TYPE);
    }

    @Override
    protected void createDefaultFields() {
        this.reportColumns = new ArrayList<DbAwareGroupColumn>();
        this.processDefinitionNameReportColumn = new DbAwareGroupColumn(this, "ProcessDefinitionName", ReportingCommon_Messages.ProcessDefinitionName, String.class);
        this.processDefinitionOidReportColumn = new DbAwareGroupColumn(this, "ProcessDefinitionOid", ReportingCommon_Messages.ProcessDefinitionOid, String.class);
        this.processInstanceOidReportColumn = new DbAwareGroupColumn(this, "ProcessInstanceOid", ReportingCommon_Messages.ProcessInstanceOid, String.class);
        this.activityNameReportColumn = new DbAwareGroupColumn(this, "ActivityName", ReportingCommon_Messages.ActivityName, String.class);
        this.activityOidReportColumn = new DbAwareGroupColumn(this, "ActivityOid", ReportingCommon_Messages.ActivityOid, String.class);
        this.activityInstanceOidReportColumn = new DbAwareGroupColumn(this, "ActivityInstanceOid", ReportingCommon_Messages.ActivityInstanceOid, String.class);
        this.activityInstanceStateReportColumn = new DbAwareGroupColumn(this, "ActivityInstanceState", ReportingCommon_Messages.ActivityInstanceState, String.class);
        this.qaStateReportColumn = new DbAwareGroupColumn(this, ReportingCommon_Messages.QualityAssuranceView_9, ReportingCommon_Messages.QualityAssuranceState, String.class);
        this.qaResultStateReportColumn = new DbAwareGroupColumn(this, ReportingCommon_Messages.QualityAssuranceView_10, ReportingCommon_Messages.QualityAssuranceResult, String.class);
        this.reportColumns.add(this.processDefinitionNameReportColumn);
        this.reportColumns.add(this.processDefinitionOidReportColumn);
        this.reportColumns.add(this.processInstanceOidReportColumn);
        this.reportColumns.add(this.activityNameReportColumn);
        this.reportColumns.add(this.activityOidReportColumn);
        this.reportColumns.add(this.activityInstanceOidReportColumn);
        this.reportColumns.add(this.activityInstanceStateReportColumn);
        this.reportColumns.add(this.qaStateReportColumn);
        this.reportColumns.add(this.qaResultStateReportColumn);
        this.addGroupColumns(this.reportColumns);
    }

    @Override
    public String getReportType() {
        return QA_VIEW_REPORT_TYPE;
    }

    @Override
    protected AbstractQualityAssuranceView.QaSqlStructure prepareStructure(Object[] parameters) throws SQLException {
        AbstractQualityAssuranceView.QaSqlStructure structure = super.prepareStructure(parameters);
        DbTable activityInstanceTable = structure.getFromTable();
        DbTable activityTable = structure.getActivityTable();
        DbTable processInstanceTable = structure.getProcessInstanceTable();
        DbTable processDefinitionTable = structure.getProcessDefinitionTable();
        DbTable aiPropertyTableForQaState = new DbTable(this.getDefaultSchemaName(), "act_inst_property", AI_PROPERTY_ALIAS_QASTATE);
        DbTable aiPropertyTableForQaResult = new DbTable(this.getDefaultSchemaName(), "act_inst_property", AI_PROPERTY_ALIAS_QARESULT);
        this.activityIdColumn = structure.getActivityIdColumn();
        DbColumn activityOidColumn = activityTable.getColumn("oid");
        this.modelOidColumn = structure.getModelOidColumn();
        this.processDefIdColumn = structure.getProcessDefinitionIdColumn();
        DbColumn aiOidColumn = activityInstanceTable.getColumn("oid");
        DbColumn processInstanceOidColumn = processInstanceTable.getColumn("oid");
        DbColumn processDefOidColumn = processDefinitionTable.getColumn("oid");
        DbColumn propertyValueStringColumnForQaState = aiPropertyTableForQaState.getColumn("string_value");
        DbColumn aiPropertyOidColumnForQaResult = aiPropertyTableForQaResult.getColumn("oid");
        DbColumn aiStateColumn = structure.getActivityInstanceStateColumn();
        DbColumn aiPropertyObjectOidColumnForQaState = aiPropertyTableForQaState.getColumn("objectOID");
        DbColumn aiPropertyNameColumnForQaState = aiPropertyTableForQaState.getColumn("name");
        OuterJoinExpression joinQaStateExpression = new OuterJoinExpression(aiPropertyTableForQaState);
        joinQaStateExpression.AND(aiOidColumn, CompareOperator.EQUALS, aiPropertyObjectOidColumnForQaState);
        joinQaStateExpression.AND(aiPropertyNameColumnForQaState, CompareOperator.EQUALS, "QualityControlUtils.State");
        DbColumn aiPropertyObjectOidColumnForQaResult = aiPropertyTableForQaResult.getColumn("objectOID");
        DbColumn aiPropertyNameColumnForQaResult = aiPropertyTableForQaResult.getColumn("name");
        OuterJoinExpression joinQaResultExpression = new OuterJoinExpression(aiPropertyTableForQaResult);
        joinQaResultExpression.AND(aiOidColumn, CompareOperator.EQUALS, aiPropertyObjectOidColumnForQaResult);
        joinQaResultExpression.AND(aiPropertyNameColumnForQaResult, CompareOperator.EQUALS, ActivityInstanceAttributes.class.getSimpleName());
        this.processDefinitionOidReportColumn.setDbColumn(processDefOidColumn);
        this.processInstanceOidReportColumn.setDbColumn(processInstanceOidColumn);
        this.activityOidReportColumn.setDbColumn(activityOidColumn);
        this.activityInstanceOidReportColumn.setDbColumn(aiOidColumn);
        this.qaStateReportColumn.setDbColumn(propertyValueStringColumnForQaState);
        this.qaResultStateReportColumn.setDbColumn(aiPropertyOidColumnForQaResult);
        this.activityInstanceStateReportColumn.setDbColumn(aiStateColumn);
        structure.addExpressions(joinQaStateExpression);
        structure.addExpressions(joinQaResultExpression);
        for (DbAwareGroupColumn reportColumm : this.reportColumns) {
            DbColumn selectedColumn = reportColumm.getDbColumn();
            if (selectedColumn == null) continue;
            structure.addSelectColumn(reportColumm.getDbColumn());
        }
        structure.addSelectColumn(this.activityIdColumn);
        structure.addSelectColumn(this.modelOidColumn);
        structure.addSelectColumn(this.processDefIdColumn);
        structure.addSelectColumn(aiStateColumn);
        return structure;
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Localizer localizer = new Localizer(allDeployedModels);
        try {
            int rowIndex = -1;
            while (resultSet.next()) {
                if (!this.authorizationManager.isAuthorized(resultSet)) continue;
                Object[] row = new Object[this.reportColumns.size()];
                long modelOid = this.modelOidColumn.getLongValue(resultSet);
                String processId = this.processDefIdColumn.getStringValue(localizer, resultSet);
                String activityId = this.activityIdColumn.getStringValue(localizer, resultSet);
                IModel activityModel = ModelUtils.findModel(allDeployedModels, modelOid);
                IProcessDefinition processDefinition = activityModel.findProcessDefinition(processId);
                IActivity activity = processDefinition.findActivity(activityId);
                if (!activity.isQualityAssuranceEnabled()) continue;
                ++rowIndex;
                int i = 0;
                while (i < this.reportColumns.size()) {
                    DbAwareGroupColumn column = this.reportColumns.get(i);
                    String value = column.getStringValue(localizer, resultSet);
                    row[i] = value;
                    if (column.equals(this.qaResultStateReportColumn)) {
                        long aiPropertyOidForQaResult = this.qaResultStateReportColumn.getLongValue(resultSet);
                        int columnIndex = i;
                        if (aiPropertyOidForQaResult > 0L) {
                            this.substitutionTable.addColumn(rowIndex, columnIndex, aiPropertyOidForQaResult);
                        }
                    }
                    if (column.equals(this.qaStateReportColumn)) {
                        String qaState = column.getStringValue(localizer, resultSet);
                        if (StringUtils.isEmpty((String)qaState)) {
                            qaState = QualityAssuranceUtils.QualityAssuranceState.NO_QUALITY_ASSURANCE.toString();
                        }
                        row[i] = qaState;
                    }
                    if (column.equals(this.processDefinitionNameReportColumn)) {
                        String processName = localizer.localizeProcessName(modelOid, processId, processId);
                        row[i] = processName;
                    }
                    if (column.equals(this.activityNameReportColumn)) {
                        String activityName = localizer.localizeActivityName(modelOid, processId, activityId, activityId);
                        row[i] = activityName;
                    }
                    ++i;
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return this.convertRowsToRowSet(rows);
    }

    @Override
    public Object[][] postProcessResults(Object[][] results, Connection connection, Object[] parameters) {
        try {
            Object[][] objectArray = this.substitutionTable.substitute(results, connection, this.getDefaultSchemaName(), parameters);
            return objectArray;
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            this.substitutionTable.clear();
        }
    }

    private class ResultStateSubstitutionTable
    extends StringDataSubstitutionTable {
        public ResultStateSubstitutionTable() {
            super("act_inst_property");
        }

        @Override
        protected Object[][] substitute(Object[][] results, int rowIndex, int columnIndex, String resolvedValue) {
            String replacementValue = null;
            try {
                ActivityInstanceAttributes aiAttributes = (ActivityInstanceAttributes)Serialization.deserializeObject((byte[])Base64.decode((byte[])resolvedValue.getBytes()));
                if (aiAttributes != null && aiAttributes.getQualityAssuranceResult() != null) {
                    QualityAssuranceResult.ResultState resultState = aiAttributes.getQualityAssuranceResult().getQualityAssuranceState();
                    replacementValue = resultState.toString();
                }
            }
            catch (Exception e) {
                log.error(ReportingCommon_Messages.QualityAssuranceView_11, e);
            }
            results[rowIndex][columnIndex] = replacementValue;
            return results;
        }
    }
}

