/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.query.DataPrefetchHint;
import org.eclipse.stardust.reporting.common.AbstractColumnProvider;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.View;

public class StructDataDescriptor
extends AbstractColumnProvider {
    private String dataId;
    private String modelId;

    public StructDataDescriptor(View view, DataPrefetchHint dataPrefetchHint) {
        super(view, null);
        QName fullQualifiedDataId = QName.valueOf(dataPrefetchHint.getDataID());
        String simpleDataId = fullQualifiedDataId.getLocalPart();
        String modelId = fullQualifiedDataId.getNamespaceURI();
        this.setDataId(simpleDataId);
        this.setModelId(modelId);
    }

    public StructDataDescriptor(View view, String name, String dataId, String modelId) {
        super(view, name);
        this.dataId = dataId;
        this.modelId = modelId;
    }

    public StructDataDescriptor(View view, String name, String dataId) {
        super(view, name);
        this.dataId = dataId;
    }

    public StructDataDescriptor(View view, String name, Properties properties) {
        this(view, name, properties.getProperty("dataId").length() > 0 ? properties.getProperty("dataId") : null);
        this.setModelId(properties.getProperty("modelId"));
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<").append("columnProvider");
        buffer.append(" type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("'>\n");
        buffer.append("<property name='dataId'>" + this.getDataId()).append("</property>\n");
        buffer.append("<property name='modelId'>" + this.getModelId()).append("</property>\n");
        for (GroupColumn column : this.getGroupColumns()) {
            buffer.append(column.getXMLSpecification());
        }
        buffer.append("</").append("columnProvider").append(">\n");
        return buffer.toString();
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructDataDescriptor other = (StructDataDescriptor)obj;
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        return !(this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId));
    }

    public boolean isInitial() {
        return StringUtils.isEmpty((String)this.dataId);
    }
}

