/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class TransitionView
extends View {
    private static final int COL_IDX_MODEL_ID = 1;
    private static final String AIF_ALIAS = "aif";
    private static final String TI_ALIAS = "ti";
    private static final String T_ALIAS = "td";
    private static final String ATO_ALIAS = "ato";
    private static final String AF_ALIAS = "af";
    private static Logger log = LogUtils.getLogger(TransitionView.class);

    public TransitionView() {
        super("LogEntry");
        this.addParameter(ReportingCommon_Messages.ViewFromActivityId, String.class, false, Parameter.STRING_DEFAULT_VALUE, "af.id");
        this.addParameter(ReportingCommon_Messages.ViewToActivityId, String.class, false, Parameter.STRING_DEFAULT_VALUE, "ato.id");
        this.addParameter(ReportingCommon_Messages.ViewProcessID, String.class, false, Parameter.STRING_DEFAULT_VALUE, "pd.id");
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ViewStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), null);
        this.addParameter(ReportingCommon_Messages.ViewEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), null);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "Model", ReportingCommon_Messages.ColumnModel, String.class));
        this.addGroupColumn(new GroupColumn((View)this, "ProcessID", ReportingCommon_Messages.ColumnProcessId, String.class, null, null));
        this.addGroupColumn(new GroupColumn((View)this, "TransitionID", ReportingCommon_Messages.ColumnTransitionId, String.class, null, null));
        this.addGroupColumn(new GroupColumn((View)this, "FromActivityID", ReportingCommon_Messages.ColumnFromActivityId, String.class, null, null));
        this.addGroupColumn(new GroupColumn((View)this, "ToActivityID", ReportingCommon_Messages.ColumnToActivityId, String.class, null, null));
        this.addGroupColumn(new GroupColumn((View)this, "Percentage", ReportingCommon_Messages.ColumnPercenTage, BigDecimal.class, null, null));
        this.addGroupColumn(new GroupColumn((View)this, "Volume", ReportingCommon_Messages.ColumnVolume, Integer.class, null, null));
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[5];
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[6];
    }

    protected void createDefaultParameters() {
    }

    @Override
    public String getReportType() {
        return "Transition";
    }

    protected Pair<Long, Long> getStartEnd(Object[] parameters) {
        String startDateParam = (String)parameters[3];
        String endDateParam = (String)parameters[4];
        return ViewUtils.getStartAndEnd(startDateParam, endDateParam);
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        if (log.isDebugEnabled()) {
            log.debug("executeQuery()");
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            DbColumn modelIdColumn = new DbColumn("id", "m");
            DbColumn pdId = new DbColumn("id", "pd");
            DbColumn afId = new DbColumn("id", AF_ALIAS);
            DbColumn tId = new DbColumn("id", T_ALIAS);
            DbColumn atoId = new DbColumn("id", ATO_ALIAS);
            DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
            String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{modelIdColumn, pdId, afId, tId, atoId});
            StringBuffer buffer = new StringBuffer(500);
            buffer.append("select ").append(selectList);
            DbColumn tiOid = new DbColumn("oid", TI_ALIAS);
            buffer.append(", count(").append(tiOid).append(")");
            buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("process_definition"), "pd"));
            String predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("processDefinition", AF_ALIAS), new DbColumn("oid", "pd")}, " = ");
            String predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", AF_ALIAS), new DbColumn("model", "pd")}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("activity")).append(' ').append(AF_ALIAS).append(DbUtils.getAndOnFragment(predicate1, predicate2));
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("sourceActivity", T_ALIAS), new DbColumn("oid", AF_ALIAS)}, " = ");
            predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", T_ALIAS), new DbColumn("model", AF_ALIAS)}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("transition")).append(' ').append(T_ALIAS).append(DbUtils.getAndOnFragment(predicate1, predicate2));
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", ATO_ALIAS), new DbColumn("targetActivity", T_ALIAS)}, " = ");
            predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", ATO_ALIAS), new DbColumn("model", T_ALIAS)}, " = ");
            buffer.append(" inner join ").append(this.getQualifiedTableName("activity")).append(' ').append(ATO_ALIAS).append(DbUtils.getAndOnFragment(predicate1, predicate2));
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("transition", TI_ALIAS), new DbColumn("oid", T_ALIAS)}, " = ");
            predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", TI_ALIAS), new DbColumn("model", T_ALIAS)}, " = ");
            buffer.append(" left outer join ").append(this.getQualifiedTableName("trans_inst")).append(' ').append(TI_ALIAS).append(DbUtils.getAndOnFragment(predicate1, predicate2));
            DbColumn aifOid = new DbColumn("oid", AIF_ALIAS);
            predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{aifOid, new DbColumn("source", TI_ALIAS)}, " = ");
            buffer.append(" left outer join ").append(this.getQualifiedTableName("activity_instance")).append(' ').append(AIF_ALIAS).append(DbUtils.getOnFragment(predicate1));
            DbColumn aifLastMod = new DbColumn("lastModificationTime", AIF_ALIAS);
            Pair<Long, Long> startEnd = this.getStartEnd(parameterValues);
            buffer.append(" where").append(" (").append(aifOid).append(" is null or").append("  (").append(aifLastMod).append(" >= ").append(startEnd.getFirst()).append("   and ").append(aifLastMod).append(" <= ").append(startEnd.getSecond()).append(")) ");
            String filters = this.getParameterFilters(parameterValues);
            if (!StringUtils.isEmpty((String)filters)) {
                buffer.append(filters);
            }
            buffer.append(this.getModelSelectionFragment(" AND ", parameterValues));
            String xxxBy = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{modelIdColumn, pdId, afId, tId, atoId});
            buffer.append(" group by ").append(xxxBy);
            xxxBy = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{modelIdColumn, pdId, afId, atoId});
            buffer.append(" order by ").append(xxxBy);
            ps = connection.prepareStatement(buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug("Executing query: " + buffer.toString());
            }
            rs = SqlUtils.performQuery((PreparedStatement)ps, buffer.toString());
            ArrayList rows = new ArrayList();
            String modelId = "";
            String procDefId = "";
            String fromActivityId = "";
            long totalCount = 0L;
            ArrayList<Object[]> tempRows = new ArrayList<Object[]>();
            boolean initLoginData = this.initLoginData();
            boolean canFetchProcessDefinition = true;
            while (rs.next()) {
                if (!procDefId.equals(rs.getString(2)) || !fromActivityId.equals(rs.getString(3))) {
                    this.processRows(totalCount, tempRows);
                    rows.addAll(tempRows);
                    totalCount = 0L;
                    tempRows = new ArrayList();
                    modelId = rs.getString(1);
                    procDefId = rs.getString(2);
                    fromActivityId = rs.getString(3);
                }
                if (initLoginData) {
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllProcessDefinitions", (Class[])new Class[0]);
                    authorizationContext.setModel(-50L);
                    canFetchProcessDefinition = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                }
                if (!canFetchProcessDefinition) continue;
                Object[] row = new Object[7];
                row[0] = modelId;
                row[1] = procDefId;
                row[2] = rs.getString(4);
                row[3] = fromActivityId;
                row[4] = rs.getString(5);
                row[6] = new Integer(rs.getInt(6));
                totalCount += (long)((Integer)row[6]).intValue();
                tempRows.add(row);
            }
            if (!tempRows.isEmpty()) {
                this.processRows(totalCount, tempRows);
                rows.addAll(tempRows);
            }
            Object[][] objectArray = this.convertRowsToRowSet(rows);
            return objectArray;
        }
        catch (Exception e) {
            log.error(e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
        }
    }

    private void processRows(long totalCount, List tempRows) {
        for (Object[] tempRow : tempRows) {
            if (totalCount == 0L) {
                tempRow[5] = new BigDecimal("0.00");
                continue;
            }
            double count = ((Integer)tempRow[6]).doubleValue();
            double ratio = count / (double)totalCount * 100.0;
            NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
            log.debug(format.format(ratio));
            tempRow[5] = new BigDecimal(format.format(ratio));
        }
    }
}

