/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBMSKey;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.reporting.common.AbstractProcessInstanceView;
import org.eclipse.stardust.reporting.common.ActivityInstanceView;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.PartitionInfoImpl;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryService;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.ResultSetMetaData;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.beans.EngineContext;
import org.eclipse.stardust.reporting.common.metadata.ColumnDefinition;
import org.eclipse.stardust.reporting.common.metadata.DatabaseDefinition;
import org.eclipse.stardust.reporting.common.metadata.TableDefinition;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.worktime.IWorktimeCalculator;

public class ProcessDatabaseQueryServiceEJB
implements ProcessDatabaseQueryService {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW", "SYNONYM", "ALIAS"};
    private static final String[] TABLE_TYPES_BY_SCHEMA = new String[]{"TABLE", "VIEW", "SYNONYM"};
    private static final Logger log = LogUtils.getLogger(ProcessDatabaseQueryServiceEJB.class);
    private String driverClassName;
    private String databaseURL;
    private String databaseAccount;
    private String databasePassword;
    private String databasePartitionId;
    private String databaseDefaultSchema;
    private Set schemaPatterns;
    private static DatabaseDefinition databaseDefinition = null;
    private DataSource dataSource;
    private IWorktimeCalculator worktimeCalculator;

    public ProcessDatabaseQueryServiceEJB(String dataSourceName, String driverClassName, String databaseURL, String databaseAccount, String databasePassword, String databasePartition, String databaseDefaultSchema, String schemaPatterns, String worktimeCalculatorClassName) {
        this.driverClassName = driverClassName;
        this.databaseURL = databaseURL;
        this.databaseAccount = databaseAccount;
        this.databasePassword = databasePassword;
        this.databasePartitionId = databasePartition;
        this.databaseDefaultSchema = databaseDefaultSchema;
        if (StringUtils.isEmpty((String)databaseDefaultSchema) && !StringUtils.isEmpty((String)databaseAccount)) {
            this.databaseDefaultSchema = databaseAccount;
        }
        if (!StringUtils.isEmpty((String)dataSourceName)) {
            try {
                InitialContext ctx = new InitialContext();
                if (log.isDebugEnabled()) {
                    log.debug("Try to bind datasource '" + dataSourceName + "'.");
                }
                this.dataSource = (DataSource)ctx.lookup(dataSourceName);
                log.info("Datasource '" + dataSourceName + "' bound.");
            }
            catch (Exception ne) {
                this.dataSource = null;
                log.error(ne);
            }
        }
        if (this.dataSource == null && !StringUtils.isEmpty((String)driverClassName)) {
            try {
                JDBCDriverManager.getInstance().testConnection(driverClassName, databaseURL, databaseAccount, databasePassword);
                if (log.isDebugEnabled()) {
                    log.info("Driver " + driverClassName + " loaded.");
                }
            }
            catch (OdaException e) {
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        this.schemaPatterns = ProcessDatabaseQueryServiceEJB.getSchemaPatternsSet(schemaPatterns);
        if (!StringUtils.isEmpty((String)this.databaseDefaultSchema)) {
            this.schemaPatterns.add(this.databaseDefaultSchema);
        }
        Class<? extends IWorktimeCalculator> worktimeCalculatorClass = ViewUtils.getWorktimeCalculatorClass(worktimeCalculatorClassName);
        try {
            this.worktimeCalculator = worktimeCalculatorClass.newInstance();
            log.info("Worktime calculator class " + this.worktimeCalculator.getClass());
        }
        catch (Exception e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection() throws ProcessDatabaseQueryException {
        try {
            if (this.dataSource != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Retrieving connection from datasource");
                }
                return this.dataSource.getConnection();
            }
            if (log.isDebugEnabled()) {
                log.debug("Retrieving connection from database driver");
            }
            return JDBCDriverManager.getInstance().getConnection(this.driverClassName, this.databaseURL, this.databaseAccount, this.databasePassword, null);
        }
        catch (Exception e) {
            log.error(e);
            throw new ProcessDatabaseQueryException(NLS.bind((String)ReportingCommon_Messages.FailedToAccessDatabase, (Object)e));
        }
    }

    @Override
    public ResultSetMetaData getMetaData(View view) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "getMetaData(" + view + ")");
        ResultSetMetaData resultSetMetaData = ProcessDatabaseQueryServiceEJB.prepareMetaData(view);
        LogUtils.exitInternal(log, "getMetaData()");
        return resultSetMetaData;
    }

    private static String[] discoverActualColumnMetaData(View view, String metaDataType) throws ProcessDatabaseQueryException {
        String[] metaData = new String[view.getLeafFields().size()];
        int n = 0;
        while (n < view.getLeafFields().size()) {
            Column column = (Column)view.getLeafFields().get(n);
            if (metaDataType.equalsIgnoreCase(NAME_LITERAL)) {
                metaData[n] = column.getFullName();
            } else if (metaDataType.equalsIgnoreCase(TYPE_LITERAL)) {
                metaData[n] = column.getType().getName();
            }
            ++n;
        }
        return metaData;
    }

    public static ResultSetMetaData prepareMetaData(View view) throws ProcessDatabaseQueryException {
        String[] allColumnNames = ProcessDatabaseQueryServiceEJB.discoverActualColumnMetaData(view, NAME_LITERAL);
        String[] allColumnTypes = ProcessDatabaseQueryServiceEJB.discoverActualColumnMetaData(view, TYPE_LITERAL);
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        queryColumnNames = allColumnNames;
        queryColumnTypes = allColumnTypes;
        return new ResultSetMetaData(view.getName(), queryColumnNames, queryColumnTypes, ProcessDatabaseQueryServiceEJB.getColumnLabels(view));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public DatabaseDefinition getDatabaseDefinition() throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "getDatabaseDefinition()");
        if (databaseDefinition == null) {
            Class<ProcessDatabaseQueryServiceEJB> clazz = ProcessDatabaseQueryServiceEJB.class;
            // MONITORENTER : org.eclipse.stardust.reporting.common.beans.ProcessDatabaseQueryServiceEJB.class
            if (databaseDefinition == null) {
                this.loadMetadata();
            }
            // MONITOREXIT : clazz
        }
        LogUtils.exitInternal(log, "getDatabaseDefinition()");
        return databaseDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableDefinition updateTableDefinition(TableDefinition tableDefinition) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "updateTableDefinition()");
        TableDefinition tableDefinition2 = tableDefinition;
        synchronized (tableDefinition2) {
            this.loadTableMetaData(tableDefinition);
        }
        LogUtils.exitInternal(log, "updateTableDefinition()");
        return tableDefinition;
    }

    private static String[] getColumnLabels(View view) {
        String[] labels = new String[view.getLeafFields().size()];
        int n = 0;
        while (n < view.getLeafFields().size()) {
            Column column = (Column)view.getLeafFields().get(n);
            labels[n] = column.getLabel();
            ++n;
        }
        return labels;
    }

    @Override
    public Object[][] executeQuery(View view, Object[] parameterValues) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "executeQuery(" + view + ")");
        if (view instanceof AbstractProcessInstanceView) {
            ((AbstractProcessInstanceView)view).setWorktimeCalculator(this.worktimeCalculator);
        } else if (view instanceof ActivityInstanceView) {
            ((ActivityInstanceView)view).setWorktimeCalculator(this.worktimeCalculator);
        }
        view.setDefaultSchemaName(this.databaseDefaultSchema);
        Connection connection = this.getConnection();
        EngineContext context = null;
        try {
            context = this.getEngineContext(connection);
            context.startupEngine();
            view.setPartitionInfo(new PartitionInfoImpl(this.databasePartitionId, connection, view.getTableQualifier()));
            if (log.isDebugEnabled()) {
                log.debug("Connection retrieved");
            }
            Iterator allModelsIterator = ModelManagerFactory.getCurrent().getAllModels();
            ArrayList<IModel> allModels = new ArrayList<IModel>();
            while (allModelsIterator.hasNext()) {
                allModels.add((IModel)allModelsIterator.next());
            }
            Object[][] results = view.executeQuery(allModels, connection, parameterValues);
            Object[][] objectArray = results = view.postProcessResults(results, connection, parameterValues);
            return objectArray;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (context != null) {
                context.shutdownEngine();
            }
            LogUtils.exitInternal(log, "executeQuery(" + view + ")");
        }
    }

    private PartitionInfoImpl createPartitionInfo(Connection connection) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        if (dbDescriptor == null) {
            dbDescriptor = DbUtils.getDbDescriptor(connection);
        }
        return new PartitionInfoImpl(this.databasePartitionId, connection, new View.TableQualifier(){

            @Override
            public String getQualifiedTableName(String tableName) {
                return ProcessDatabaseQueryServiceEJB.this.getQualifiedTableName(tableName);
            }
        }, dbDescriptor);
    }

    protected List<String> getUniqueModelIds(Connection connection, PartitionInfo partitionInfo) throws ProcessDatabaseQueryException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> uniquemodelIds = new ArrayList<String>();
        try {
            StringBuffer buffer = new StringBuffer(100);
            DBDescriptor dbDescriptor = DbUtils.getDbDescriptor(connection);
            String modelTable = dbDescriptor.quoteIdentifier("model");
            String modelParttionColumn = dbDescriptor.quoteIdentifier("partition");
            DbColumn disabledColumnName = new DbColumn("disabled", "m");
            String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("id", "m")});
            buffer.append("select distinct ").append(selectList).append(" from ").append(this.getQualifiedTableName(String.valueOf(modelTable) + " m")).append(" where").append(" m.").append(modelParttionColumn).append(" = ?").append(" and ").append(disabledColumnName).append(" = ?");
            ps = connection.prepareStatement(buffer.toString());
            int partitionOid = partitionInfo.getPartitionOid();
            ps.setInt(1, partitionOid);
            ps.setBoolean(2, false);
            rs = SqlUtils.performQuery(ps, buffer.toString());
            while (rs.next()) {
                String modelId = rs.getString("id");
                uniquemodelIds.add(modelId);
            }
        }
        catch (Exception e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return uniquemodelIds;
    }

    public static boolean isValidTime(long validFrom, long validTo, long now) {
        boolean valid = false;
        if (!(validFrom >= now && validFrom != 0L || validTo <= now && validTo != 0L)) {
            valid = true;
        }
        return valid;
    }

    protected void loadMetadata() throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "loadMetadata()");
        ResultSet rs = null;
        Connection connection = this.getConnection();
        DBDescriptor dbDescriptor = DbUtils.getDbDescriptor(connection);
        try {
            try {
                databaseDefinition = new DatabaseDefinition(this);
                DatabaseMetaData metadata = connection.getMetaData();
                Iterator iter = this.schemaPatterns.iterator();
                while (iter.hasNext()) {
                    String fetchAsSchema = TABLE_SCHEM;
                    String catalogPattern = null;
                    String schemaPattern = (String)iter.next();
                    if (!DBMSKey.SYBASE.equals((Object)dbDescriptor.getDbmsKey())) {
                        schemaPattern = schemaPattern.toUpperCase();
                    }
                    if (DBMSKey.MYSQL.equals((Object)dbDescriptor.getDbmsKey())) {
                        fetchAsSchema = TABLE_CAT;
                        catalogPattern = schemaPattern;
                        schemaPattern = null;
                    }
                    rs = metadata.getTables(catalogPattern, schemaPattern, "%", TABLE_TYPES);
                    while (rs.next()) {
                        databaseDefinition.addTableDefinition(rs.getString(fetchAsSchema), rs.getString("TABLE_NAME"), rs.getString("TABLE_TYPE"));
                    }
                }
            }
            catch (Exception e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            LogUtils.exitInternal(log, "loadMetadata()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadTableMetaData(TableDefinition tableDefinition) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "loadTableMetaData()");
        Connection connection = this.getConnection();
        if (log.isDebugEnabled()) {
            log.debug("TABLE (" + tableDefinition.getSchema() + ", " + tableDefinition.getName() + ", " + tableDefinition.getType());
        }
        ResultSet columns = null;
        try {
            try {
                DatabaseMetaData metadata = connection.getMetaData();
                String escapeString = metadata.getSearchStringEscape();
                DBMSKey dbType = DbUtils.getDbType(metadata);
                if (DBMSKey.ORACLE == dbType) {
                    escapeString = escapeString.substring(0, 1);
                }
                try {
                    String searchTableName = tableDefinition.getName();
                    String searchSchemaName = tableDefinition.getSchema();
                    if (!StringUtils.isEmpty((String)escapeString)) {
                        searchTableName = this.escapeDbObjectName(searchTableName, escapeString);
                        searchSchemaName = this.escapeDbObjectName(searchSchemaName, escapeString);
                    }
                    if (DBMSKey.SYBASE != dbType) {
                        searchTableName = searchTableName.toUpperCase();
                        searchSchemaName = searchSchemaName.toUpperCase();
                    }
                    String searchSchemaPattern = "%";
                    if (Arrays.asList(TABLE_TYPES_BY_SCHEMA).contains(tableDefinition.getType())) {
                        searchSchemaPattern = searchSchemaName;
                    }
                    columns = metadata.getColumns(null, searchSchemaPattern, searchTableName, "%");
                }
                catch (SQLException x) {
                    log.warn(MessageFormat.format("Could not fetch columns for table {0} due to exception {1}.", tableDefinition.getName().toUpperCase(), x), x);
                }
                while (columns != null) {
                    if (!columns.next()) {
                        return;
                    }
                    ColumnDefinition columnDefinition = tableDefinition.addColumnDefinition(columns.getString("COLUMN_NAME"), columns.getString("TYPE_NAME"), columns.getInt("COLUMN_SIZE"), columns.getInt("DECIMAL_DIGITS"), columns.getBoolean("NULLABLE"));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("   COLUMN (" + columnDefinition.getName() + ", " + columnDefinition.getType() + ", " + columnDefinition.getCardinality());
                }
                return;
            }
            catch (Exception e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            LogUtils.exitInternal(log, "loadTableMetaData()");
        }
    }

    private String escapeDbObjectName(String dbObjectName, String escapeString) {
        return StringUtils.replace((String)dbObjectName, (String)escapeString, (String)(String.valueOf(escapeString) + escapeString));
    }

    public static Set getSchemaPatternsSet(String schemaPatterns) {
        HashSet<String> patterns = new HashSet<String>();
        Iterator iter = StringUtils.split((String)schemaPatterns, (char)',');
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            if (StringUtils.isEmpty((String)pattern)) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    public String getQualifiedTableName(String tableName) {
        return this.getQualifiedTableName(this.databaseDefaultSchema, tableName);
    }

    private String getQualifiedTableName(String schemaName, String tableName) {
        StringBuffer buffer = new StringBuffer(50);
        if (!StringUtils.isEmpty((String)schemaName)) {
            buffer.append(schemaName).append('.');
        }
        return buffer.append(tableName).toString();
    }

    public EngineContext getEngineContext(Connection connection) throws ProcessDatabaseQueryException {
        PartitionInfoImpl partitionInfo = this.createPartitionInfo(connection);
        return new EngineContext(connection, partitionInfo, this.databaseDefaultSchema);
    }

    @Override
    public EngineContext getEngineContext() throws ProcessDatabaseQueryException {
        return this.getEngineContext(this.getConnection());
    }

    @Override
    public IModel getModelByOid(long oid) {
        EngineContext context = null;
        try {
            Connection connection = this.getConnection();
            context = this.getEngineContext(connection);
            context.startupEngine();
            IModel iModel = ModelManagerFactory.getCurrent().findModel(oid);
            return iModel;
        }
        catch (Exception e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            if (context != null) {
                context.shutdownEngine();
            }
        }
    }

    @Override
    public List<IModel> getActiveModels() {
        EngineContext context = null;
        try {
            context = this.getEngineContext();
            context.startupEngine();
            List list = ModelManagerFactory.getCurrent().findActiveModels();
            return list;
        }
        catch (Exception e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            if (context != null) {
                context.shutdownEngine();
            }
        }
    }
}

