/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans.security;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.beans.security.ReadActivityInstanceDataStructure;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.OuterJoinExpression;
import org.eclipse.stardust.reporting.common.utils.sql.SqlStructure;

public class AuthorizationManager {
    private final AuthorizationContext authorizationContext;
    private final AbstractAuthorization2Predicate authorizationPredicate;
    private List<IDataPrefetchColumn> dataPrefetchColumns = new ArrayList<IDataPrefetchColumn>();
    private ReadActivityInstanceDataStructure readActivityInstanceDataStructure;

    public AuthorizationManager(AuthorizationContext authorizationContext, AbstractAuthorization2Predicate authorizationPredicate) {
        this.authorizationContext = authorizationContext;
        this.authorizationPredicate = authorizationPredicate;
    }

    public List<IDataPrefetchColumn> getDataPrefetchColumns() {
        return this.dataPrefetchColumns;
    }

    public void setDataPrefetchColumns(List<IDataPrefetchColumn> dataPrefetchColumns) {
        this.dataPrefetchColumns = dataPrefetchColumns;
    }

    public boolean isAuthorized(ResultSet rs) throws SQLException {
        this.authorizationPredicate.accept((Object)rs);
        long scopeProcessInstanceOid = this.readActivityInstanceDataStructure.getScopeProcessInstanceOid(rs);
        long activityOid = this.readActivityInstanceDataStructure.getActivityOid(rs);
        long modelOid = this.readActivityInstanceDataStructure.getModelOid(rs);
        long currentPerformer = this.readActivityInstanceDataStructure.getCurrentPerformer(rs);
        long currentUserPerformer = this.readActivityInstanceDataStructure.getCurrentUserPerformer(rs);
        long currentDepartment = this.readActivityInstanceDataStructure.getCurrentDepartment(rs);
        this.authorizationContext.setActivityDataWithScopePi(scopeProcessInstanceOid, activityOid, modelOid, currentPerformer, currentUserPerformer, currentDepartment);
        return Authorization2.hasPermission((AuthorizationContext)this.authorizationContext);
    }

    public void prepare(View view, SqlStructure sqlStructure, DbTable processInstanceTable, DbTable activityInstanceTable, Map<IDataColumn, List<DataInfo>> dataInfoMap) {
        this.readActivityInstanceDataStructure = new ReadActivityInstanceDataStructure(processInstanceTable, activityInstanceTable);
        sqlStructure.applyStructure(this.readActivityInstanceDataStructure);
        for (IDataPrefetchColumn prefetchColumn : this.dataPrefetchColumns) {
            List<DataInfo> dataInfos = dataInfoMap.get(prefetchColumn);
            if (dataInfos == null || dataInfos.isEmpty()) continue;
            String alias = view.getAliasRegistry().getAlias(prefetchColumn);
            String schemaName = view.getDefaultSchemaName();
            DbTable dataValueTable = new DbTable(schemaName, "data_value", alias);
            DbTable structDataValueTable = new DbTable(schemaName, "structured_data_value", alias);
            DbColumn typeColumn = dataValueTable.getColumn("type_key");
            DbColumn stringValueColumn = dataValueTable.getColumn("string_value");
            DbColumn dataColumn = dataValueTable.getColumn("data");
            DbColumn xpathColumn = structDataValueTable.getColumn("xpath");
            DbColumn dataValueProcessInstanceColumn = dataValueTable.getColumn("processInstance");
            DbColumn scopedProcessInstanceColumn = processInstanceTable.getColumn("scopeProcessInstance");
            boolean simpleDataPrefetchColumn = prefetchColumn instanceof DataPrefetchColumn;
            OuterJoinExpression dataValueJoinExpression = null;
            dataValueJoinExpression = simpleDataPrefetchColumn ? new OuterJoinExpression(dataValueTable) : new OuterJoinExpression(structDataValueTable);
            dataValueJoinExpression.AND(dataValueProcessInstanceColumn, CompareOperator.EQUALS, scopedProcessInstanceColumn);
            int count = 0;
            for (DataInfo dataInfo : dataInfos) {
                Long dataCriteria;
                DbColumn dataJoinColumn;
                ++count;
                if (simpleDataPrefetchColumn) {
                    dataJoinColumn = dataColumn;
                    dataCriteria = dataInfo.getDataOid();
                } else {
                    dataJoinColumn = xpathColumn;
                    dataCriteria = dataInfo.getXPathOid();
                }
                if (count == 1) {
                    dataValueJoinExpression.AND(dataJoinColumn, CompareOperator.EQUALS, dataCriteria);
                    continue;
                }
                dataValueJoinExpression.OR(dataJoinColumn, CompareOperator.EQUALS, dataCriteria);
            }
            sqlStructure.addSelectColumn(typeColumn);
            sqlStructure.addSelectColumn(stringValueColumn);
            sqlStructure.addExpressions(dataValueJoinExpression);
        }
    }
}

