/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metadata;

import java.io.Serializable;
import org.eclipse.stardust.reporting.common.metadata.IColumnDefinition;
import org.eclipse.stardust.reporting.common.metadata.TableDefinition;

public class ColumnDefinition
implements IColumnDefinition,
Serializable {
    TableDefinition tableDefinition;
    String name;
    String type;
    int cardinality;
    int precision;
    boolean nullable;

    public ColumnDefinition(TableDefinition tableDefinition, String name, String type, int cardinality, int precision, boolean nullable) {
        this.tableDefinition = tableDefinition;
        this.name = name;
        this.type = type;
        this.cardinality = cardinality;
        this.precision = precision;
        this.nullable = nullable;
    }

    @Override
    public String getDefinitionString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getName()) + ": " + this.getType());
        if (this.getCardinality() > 1) {
            buffer.append('(');
            buffer.append(this.getCardinality());
            if (this.getPrecision() > 0) {
                buffer.append('.');
                buffer.append(this.getPrecision());
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return String.valueOf(this.getTableDefinition().getSchema()) + "." + this.getTableDefinition().getName() + "." + this.getName();
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

