/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metadata.columns;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;

public class DbColumn
implements IDbColumn,
Comparable<DbColumn> {
    private Class type;
    private String name;
    private String qualifier;
    private String alias;
    private int rsIndex = -1;

    public DbColumn(String name) {
        this(name, "", "", null);
    }

    public DbColumn(String name, Class type) {
        this(name, "", "", type);
    }

    public DbColumn(String name, String qualifier) {
        this(name, qualifier, "", null);
    }

    public DbColumn(String name, String qualifier, Class type) {
        this(name, qualifier, "", type);
    }

    public DbColumn(String name, String qualifier, String alias) {
        this(name, qualifier, alias, null);
    }

    public DbColumn(String name, String qualifier, String alias, Class type) {
        this.name = name;
        this.qualifier = qualifier.trim();
        this.alias = alias.trim();
        this.type = type != null ? type : String.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public int getRsIndex() {
        return this.rsIndex;
    }

    public void setRsIndex(int rsIndex) {
        this.rsIndex = rsIndex;
    }

    @Override
    public String getQualifiedName() {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.qualifier)) {
            buffer.append(this.qualifier).append(".");
        }
        buffer.append(this.name);
        return buffer.toString();
    }

    @Override
    public String getQualifiedNameWithAlias() {
        StringBuffer buffer = new StringBuffer(this.getQualifiedName());
        if (!StringUtils.isEmpty((String)this.alias)) {
            buffer.append(" ").append(this.alias);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public String getStringValue(Localizer localizer, ResultSet rs) throws SQLException {
        String value = null;
        if (this.rsIndex != -1) {
            if (this.type == Boolean.class) {
                boolean b = this.getBooleanValue(rs);
                value = Localizer.localizeBoolean(b);
            } else if (this.type == Date.class) {
                long l = this.getLongValue(rs);
                Date d = new Date(l);
                value = Localizer.localizeDate(d);
            } else {
                value = rs.getString(this.rsIndex);
            }
        }
        return value;
    }

    public long getLongValue(ResultSet rs) throws SQLException {
        long value = 0L;
        if (this.rsIndex != -1) {
            value = rs.getLong(this.rsIndex);
        }
        return value;
    }

    public boolean getBooleanValue(ResultSet rs) throws SQLException {
        boolean value = false;
        if (this.rsIndex != -1) {
            value = rs.getBoolean(this.rsIndex);
        }
        return value;
    }

    @Override
    public int compareTo(DbColumn o) {
        return this.toString().compareTo(o.toString());
    }
}

