/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.AttributeHolder;
import org.eclipse.stardust.reporting.common.metamodel.AttributeCategory;

public class AttributeUtil {
    public static List getAttributeCategories(AttributeHolder element) {
        ArrayList<AttributeCategory> categories = new ArrayList<AttributeCategory>();
        for (String attribute : element.getAllAttributes().keySet()) {
            String categoryID = AttributeUtil.getCategoryName(attribute);
            AttributeCategory category = AttributeUtil.getExistingCategory(categoryID, categories);
            if (category != null) continue;
            category = new AttributeCategory(element, categoryID, null);
            categories.add(category);
        }
        return categories;
    }

    private static String getCategoryName(String attName) {
        if (attName.indexOf(":") < 0) {
            return null;
        }
        String[] categoryIDs = attName.split(":");
        return categoryIDs[0];
    }

    private static AttributeCategory getExistingCategory(String id, List categories) {
        for (AttributeCategory category : categories) {
            if ((id != null || category.getId() != null) && (id == null || !id.equals(category.getId()))) continue;
            return category;
        }
        return null;
    }

    public static AttributeCategory createAttributeCategory(AttributeHolder element, String id) {
        return new AttributeCategory(element, id, null);
    }
}

