/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.runtime.UnresolvedExternalReference;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.metamodel.Attribute;
import org.eclipse.stardust.reporting.common.metamodel.Link;
import org.eclipse.stardust.reporting.common.metamodel.Metamodel;
import org.eclipse.stardust.reporting.common.metamodel.Node;
import org.eclipse.stardust.reporting.common.metamodel.RootHelper;
import org.eclipse.stardust.reporting.common.metamodel.Step;
import org.eclipse.stardust.reporting.common.utils.MetaModelUtil;

public class Path {
    private static Logger log = LogUtils.getLogger(Path.class);
    Stack<Step> stack;

    public Path() {
        this.stack = new Stack();
    }

    public Path(String query) {
        if (log.isDebugEnabled()) {
            log.debug("Bootstrapping path from query " + query);
        }
        this.stack = new Stack();
        if (query == null) {
            return;
        }
        String[] steps = query.split("/");
        Node currentNode = Metamodel.getInstance().getRootNode();
        int n = 1;
        while (n < steps.length) {
            String id = steps[n];
            Link link = null;
            link = MetaModelUtil.isFullId(id) ? currentNode.getOutgoingLinkById(id) : currentNode.getOutgoingLinkByName(id);
            this.stack.push(new Step(link));
            currentNode = link.getToNode();
            ++n;
        }
    }

    public Path(Node node, String query) {
        if (log.isDebugEnabled()) {
            log.debug("Bootstrapping path from query " + query);
        }
        this.stack = new Stack();
        if (query == null) {
            return;
        }
        String[] steps = query.split("/");
        Node currentNode = node;
        int n = 1;
        while (n < steps.length) {
            String id = steps[n];
            Link link = null;
            link = MetaModelUtil.isFullId(id) ? currentNode.getOutgoingLinkById(id) : currentNode.getOutgoingLinkByName(id);
            this.stack.push(new Step(link));
            currentNode = link.getToNode();
            ++n;
        }
    }

    public int getSize() {
        return this.stack.size();
    }

    public Step getTop() {
        if (this.stack.size() == 0) {
            return null;
        }
        return (Step)this.stack.lastElement();
    }

    public Step get(int n) {
        return (Step)this.stack.get(n);
    }

    public Iterator<Step> iterator() {
        return this.stack.iterator();
    }

    public void push(Step step) {
        this.stack.push(step);
    }

    public Step pop() {
        return this.stack.pop();
    }

    public void clear() {
        this.stack.clear();
    }

    public String getPathString() {
        StringBuffer buffer = new StringBuffer("/");
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)iterator.next();
            String fullId = MetaModelUtil.getFullId(step);
            buffer.append(fullId);
            if (!iterator.hasNext()) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    public Object[][] evaluateAgainstModel(IModel model, Object[] parameterValues) {
        if (log.isDebugEnabled()) {
            log.debug("=> evaluateAganistModel(" + model);
        }
        if (this.getTop() == null) {
            return new Object[0][0];
        }
        List startObjects = new ArrayList<RootHelper>();
        startObjects.add(new RootHelper(model));
        int n = 0;
        while (n < this.getSize()) {
            try {
                startObjects = ((Step)this.stack.get(n)).traverse(startObjects, parameterValues[n]);
            }
            catch (UnresolvedExternalReference unresolvedExternalReference) {}
            ++n;
        }
        List attributes = this.getTop().getLink().getToNode().getAttributes();
        Object[][] rowSet = new Object[startObjects.size()][attributes.size()];
        int n2 = 0;
        while (n2 < startObjects.size()) {
            rowSet[n2] = new Object[attributes.size()];
            int m = 0;
            while (m < attributes.size()) {
                rowSet[n2][m] = ((Attribute)attributes.get(m)).getValueForObject(startObjects.get(n2), model);
                ++m;
            }
            ++n2;
        }
        return rowSet;
    }

    public Object evaluateAgainstModelElement(IModel model, Object modelElement, Object[] parameterValues, String attributeID) {
        LogUtils.enterInternal(log, "evaluateAgainstModelElement(" + modelElement + ")");
        if (this.getTop() == null) {
            return null;
        }
        List startObjects = new ArrayList<Object>();
        startObjects.add(modelElement);
        int n = 0;
        while (n < this.getSize()) {
            startObjects = ((Step)this.stack.get(n)).traverse(startObjects, parameterValues[n]);
            ++n;
        }
        if (startObjects.size() == 0) {
            return null;
        }
        Attribute attribute = this.getTop().getLink().getToNode().getAttributeByID(attributeID);
        Object valueForObject = attribute.getValueForObject(startObjects.get(0), model);
        LogUtils.exitInternal(log, "evaluateAgainstModelElement(" + modelElement + ")");
        return valueForObject;
    }
}

