/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.stardust.common.AttributeHolder;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IApplication;
import org.eclipse.stardust.engine.api.model.IApplicationContext;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IDataMapping;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IModelParticipant;
import org.eclipse.stardust.engine.api.model.IOrganization;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.IRole;
import org.eclipse.stardust.engine.api.model.ITransition;
import org.eclipse.stardust.engine.api.model.ITrigger;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.metamodel.AttributeCategory;
import org.eclipse.stardust.reporting.common.metamodel.AttributeFilter;
import org.eclipse.stardust.reporting.common.metamodel.AttributeUtil;
import org.eclipse.stardust.reporting.common.metamodel.Link;
import org.eclipse.stardust.reporting.common.metamodel.Metamodel;
import org.eclipse.stardust.reporting.common.metamodel.PropertyHolder;

public class Step {
    private static final Logger log = LogUtils.getLogger(Step.class);
    private Link link;
    private List attributeFilters;

    public Step(Link link) {
        this.link = link;
        this.attributeFilters = new ArrayList();
    }

    public Link getLink() {
        return this.link;
    }

    List traverse(List startObjects, Object filterParameter) {
        log.debug("=> traverse(" + startObjects + ")");
        if (startObjects.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Empty list of start objects. Returning.");
            }
            return startObjects;
        }
        ArrayList<Object> unfilteredResult = new ArrayList<Object>();
        if (log.isDebugEnabled()) {
            log.debug("Link " + this.getLink().getName() + " to Node " + this.getLink().getToNode().getName());
        }
        if (this.getLink().getToNode().equals(Metamodel.getInstance().propertiesCategory) && this.getLink().getName().equals("propertiesCategories")) {
            this.traversePropertiesCategories(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().equals(Metamodel.getInstance().propertiesCategory) && this.getLink().getName().equals("subCategories")) {
            this.traverseSubPropertiesCategories(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().equals(Metamodel.getInstance().process) && this.getLink().getName().equals("possibleSubProcesses")) {
            this.traverseSubprocesses(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().equals(Metamodel.getInstance().process) && this.getLink().getName().equals("superprocesses")) {
            this.traverseSuperprocesses(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().equals(Metamodel.getInstance().process) && this.getLink().getToNode().equals(Metamodel.getInstance().role) && this.getLink().getName().equals("startingParticipant")) {
            this.traverseStartingRoleParticipant(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().equals(Metamodel.getInstance().process) && this.getLink().getToNode().equals(Metamodel.getInstance().organization) && this.getLink().getName().equals("startingParticipant")) {
            this.traverseStartingOrganizationParticipant(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Role") && this.getLink().getName().equals("activitiesPerformedBy")) {
            this.traverseActivitiesPerformedByRole(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Role") && this.getLink().getName().equals("processesStartedBy")) {
            this.traverseProcessesStartedByRole(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Organization") && this.getLink().getName().equals("activitiesPerformedBy")) {
            this.traverseActivitiesPerformedByOrganization(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Organization") && this.getLink().getName().equals("processesStartedBy")) {
            this.traverseProcessesStartedByOrganization(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Application") && this.getLink().getName().equals("activitiesPerformedBy")) {
            this.traverseActivitiesExecutingApplication(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Application") && this.getLink().getName().equals("applicationContexts")) {
            this.traverseApplicationContexts(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Activity") && this.getLink().getName().equals("previous")) {
            this.traversePreviousActivities(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Activity") && this.getLink().getName().equals("next")) {
            this.traverseNextActivities(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Activity") && this.getLink().getName().equals("hasInputData")) {
            this.traverseInData(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Activity") && this.getLink().getName().equals("hasOutputData")) {
            this.traverseOutData(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Activity") && this.getLink().getName().equals("hasData")) {
            this.traverseData(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Data") && this.getLink().getName().equals("inputFor")) {
            this.traverseInputFor(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Data") && this.getLink().getName().equals("outputOf")) {
            this.traverseOutputOf(startObjects, unfilteredResult);
        } else if (this.getLink().getFromNode().getName().equals("Data") && this.getLink().getName().equals("dataFor")) {
            this.traverseDataFor(startObjects, unfilteredResult);
        } else {
            String methodName = null;
            if (this.getLink().getToNode().equals(Metamodel.getInstance().property) && this.getLink().getFromNode().equals(Metamodel.getInstance().propertiesCategory)) {
                methodName = "getAttributes";
            } else if (this.getLink().getToNode().equals(Metamodel.getInstance().property) && this.getLink().getName().equals("properties")) {
                methodName = "getAllAttributes";
            } else {
                String prefix = null;
                prefix = this.getLink().getCardinality() == 1 ? "getAll" : "get";
                methodName = String.valueOf(prefix) + this.getLink().getName().substring(0, 1).toUpperCase() + this.getLink().getName().substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Traverse method name: " + methodName);
            }
            Method method = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Start object: " + startObjects.get(0).getClass());
                }
                method = startObjects.get(0).getClass().getMethod(methodName, new Class[0]);
            }
            catch (SecurityException e) {
                log.error(e);
            }
            catch (NoSuchMethodException e) {
                log.error(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Traversal method: " + method.getName());
            }
            if (method != null) {
                try {
                    int n = 0;
                    while (n < startObjects.size()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Traversing object " + startObjects.get(n));
                        }
                        if (method.getReturnType().equals(Iterator.class)) {
                            Iterator iterator = (Iterator)method.invoke(startObjects.get(n), new Object[0]);
                            while (iterator.hasNext()) {
                                unfilteredResult.add(iterator.next());
                            }
                        } else if (method.getReturnType().equals(List.class)) {
                            List list = (List)method.invoke(startObjects.get(n), new Object[0]);
                            if (log.isDebugEnabled()) {
                                log.debug("List retrieved with size " + list.size());
                            }
                            unfilteredResult.addAll(list);
                        } else if (method.getReturnType().equals(Map.class)) {
                            Map map = (Map)method.invoke(startObjects.get(n), new Object[0]);
                            if (log.isDebugEnabled()) {
                                log.debug("Map retrieved with size " + map.size());
                            }
                            for (String key : map.keySet()) {
                                Object value = map.get(key);
                                String stringifiedValue = value == null ? "" : value.toString();
                                unfilteredResult.add(new PropertyHolder(key, stringifiedValue));
                            }
                        } else {
                            Object object = method.invoke(startObjects.get(n), new Object[0]);
                            if (log.isDebugEnabled()) {
                                log.debug("Retrieved object " + object);
                            }
                            if (object != null) {
                                unfilteredResult.add(object);
                            }
                        }
                        ++n;
                    }
                }
                catch (IllegalArgumentException e) {
                    log.error(e);
                }
                catch (IllegalAccessException e) {
                    log.error(e);
                }
                catch (InvocationTargetException e) {
                    log.error(e);
                }
            }
        }
        ArrayList result = new ArrayList();
        Iterator iterator = unfilteredResult.iterator();
        String getIDMethodName = "getId";
        Method getIDMethod = null;
        while (iterator.hasNext()) {
            String stringFilter;
            Object object = iterator.next();
            if (log.isDebugEnabled()) {
                log.debug("Filtering object " + object);
            }
            if (getIDMethod == null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Retrieve method " + getIDMethodName + " from " + object);
                    }
                    getIDMethod = object.getClass().getMethod(getIDMethodName, new Class[0]);
                }
                catch (SecurityException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
            }
            if ((stringFilter = (String)filterParameter) != null && stringFilter.length() > 0) {
                String id;
                try {
                    id = object instanceof IApplicationContext ? "Pups" : (String)getIDMethod.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    log.error(e);
                    throw new RuntimeException(e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Comparing filter regular expression " + filterParameter + " with " + id);
                }
                if (id == null || id.length() == 0 || !id.matches(stringFilter)) continue;
            }
            result.add(object);
        }
        return result;
    }

    protected void addAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilters.add(attributeFilter);
    }

    public List getAttributeFilters() {
        return this.attributeFilters;
    }

    private void traversePropertiesCategories(List startObjects, List result) {
        log.debug("==> traversePropertiesCategories(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            List list = AttributeUtil.getAttributeCategories((AttributeHolder)startObjects.get(i));
            log.debug("Properties category list: " + list.size() + " in " + startObjects.get(i));
            result.addAll(list);
            ++i;
        }
    }

    private void traverseSubPropertiesCategories(List startObjects, List result) {
        log.debug("==> traverseSubPropertyCategories(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            List list = ((AttributeCategory)startObjects.get(i)).getAttributeCategories();
            log.debug("Properties category list: " + list.size() + " in " + startObjects.get(i));
            result.addAll(list);
            ++i;
        }
    }

    private void traverseSubprocesses(List startObjects, List result) {
        log.debug("==> traverseSubprocesses(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IProcessDefinition processDefinition = (IProcessDefinition)startObjects.get(i);
            Iterator activities = processDefinition.getAllActivities();
            while (activities.hasNext()) {
                IActivity activity = (IActivity)activities.next();
                IProcessDefinition subprocessDefinition = activity.getImplementationProcessDefinition();
                if (subprocessDefinition == null) continue;
                result.add(subprocessDefinition);
            }
            ++i;
        }
    }

    private void traverseSuperprocesses(List startObjects, List result) {
        log.debug("==> traverseSuperprocesses(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IProcessDefinition processDefinition = (IProcessDefinition)startObjects.get(i);
            if (model == null) {
                model = (IModel)processDefinition.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition superProcessDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = superProcessDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    IProcessDefinition subprocessDefinition = activity.getImplementationProcessDefinition();
                    if (subprocessDefinition == null || subprocessDefinition != processDefinition || result.contains(superProcessDefinition)) continue;
                    result.add(superProcessDefinition);
                }
            }
            ++i;
        }
    }

    private void traverseStartingRoleParticipant(List startObjects, List result) {
        log.debug("==> traverseStartingRoleParticipant(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IProcessDefinition processDefinition = (IProcessDefinition)startObjects.get(i);
            if (model == null) {
                model = (IModel)processDefinition.getModel();
            }
            Iterator triggers = processDefinition.getAllTriggers();
            while (triggers.hasNext()) {
                IModelParticipant performer;
                ITrigger trigger = (ITrigger)triggers.next();
                String performerID = trigger.getStringAttribute("carnot:engine:participant");
                if (performerID == null || !((performer = model.findParticipant(performerID)) instanceof IRole)) continue;
                result.add(performer);
            }
            ++i;
        }
    }

    private void traverseStartingOrganizationParticipant(List startObjects, List result) {
        log.debug("==> traverseStartingOrganizationParticipant(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IProcessDefinition processDefinition = (IProcessDefinition)startObjects.get(i);
            if (model == null) {
                model = (IModel)processDefinition.getModel();
            }
            Iterator triggers = processDefinition.getAllTriggers();
            while (triggers.hasNext()) {
                IModelParticipant performer;
                ITrigger trigger = (ITrigger)triggers.next();
                String performerID = trigger.getStringAttribute("carnot:engine:participant");
                if (performerID == null || !((performer = model.findParticipant(performerID)) instanceof IOrganization)) continue;
                result.add(performer);
            }
            ++i;
        }
    }

    private void traverseApplicationContexts(List startObjects, List result) {
        log.debug("==> traverseApplicationContexts(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            Iterator iterator = ((IApplication)startObjects.get(i)).getAllContexts();
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
            ++i;
        }
    }

    private void traverseActivitiesExecutingApplication(List startObjects, List result) {
        if (log.isDebugEnabled()) {
            log.debug("==> traverseActivitiesExecutingApplication(" + startObjects + ")");
        }
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IApplication application = (IApplication)startObjects.get(i);
            if (model == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Type of root: " + application.getModel());
                }
                model = (IModel)application.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    if (activity.getApplication() == null || !activity.getApplication().getId().equals(application.getId())) continue;
                    result.add(activity);
                }
            }
            ++i;
        }
    }

    private void traverseActivitiesPerformedByRole(List startObjects, List result) {
        if (log.isDebugEnabled()) {
            log.debug("==> traverseActivitiesPerformedByRole(" + startObjects + ")");
        }
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IRole role = (IRole)startObjects.get(i);
            if (model == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Type of root: " + role.getModel());
                }
                model = (IModel)role.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    if (log.isDebugEnabled()) {
                        log.debug("Performer of activity " + activity.getId() + ": " + activity.getPerformer());
                    }
                    if (activity.getPerformer() == null || !activity.getPerformer().getId().equals(role.getId())) continue;
                    result.add(activity);
                }
            }
            ++i;
        }
    }

    private void traverseProcessesStartedByRole(List startObjects, List result) {
        log.debug("==> traverseProcessesStartedByRole(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IRole role = (IRole)startObjects.get(i);
            if (model == null) {
                log.debug("Type of root: " + role.getModel());
                model = (IModel)role.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllTriggers();
                while (activities.hasNext()) {
                    ITrigger activity = (ITrigger)activities.next();
                    String performer = activity.getStringAttribute("carnot:engine:participant");
                    if (performer == null) continue;
                    result.add(model.findParticipant(performer));
                    log.debug("Trigger Type: " + performer);
                }
            }
            ++i;
        }
    }

    private void traverseActivitiesPerformedByOrganization(List startObjects, List result) {
        if (log.isDebugEnabled()) {
            log.debug("==> traverseActivitiesPerformedByOrganisation(" + startObjects + ")");
        }
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IOrganization organization = (IOrganization)startObjects.get(i);
            if (model == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Type of root: " + organization.getModel());
                }
                model = (IModel)organization.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    if (log.isDebugEnabled()) {
                        log.debug("Performer of activity " + activity.getId() + ": " + activity.getPerformer());
                    }
                    if (activity.getPerformer() == null || !activity.getPerformer().getId().equals(organization.getId())) continue;
                    result.add(activity);
                }
            }
            ++i;
        }
    }

    private void traverseProcessesStartedByOrganization(List startObjects, List result) {
        log.debug("==> traverseProcessesStartedByOrganisation(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IOrganization organization = (IOrganization)startObjects.get(i);
            if (model == null) {
                log.debug("Type of root: " + organization.getModel());
                model = (IModel)organization.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllTriggers();
                while (activities.hasNext()) {
                    ITrigger activity = (ITrigger)activities.next();
                    String performer = activity.getStringAttribute("carnot:engine:participant");
                    if (performer == null) continue;
                    result.add(model.findParticipant(performer));
                    log.debug("Trigger Type: " + performer);
                }
            }
            ++i;
        }
    }

    private void traversePreviousActivities(List startObjects, List result) {
        log.debug("==> traversePreviousActivities(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IActivity activity = (IActivity)startObjects.get(i);
            Iterator transitions = activity.getAllInTransitions();
            while (transitions.hasNext()) {
                ITransition processDefinition = (ITransition)transitions.next();
                result.add(processDefinition.getFromActivity());
            }
            ++i;
        }
    }

    private void traverseNextActivities(List startObjects, List result) {
        log.debug("==> traverseNextActivities(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IActivity activity = (IActivity)startObjects.get(i);
            Iterator transitions = activity.getAllOutTransitions();
            while (transitions.hasNext()) {
                ITransition processDefinition = (ITransition)transitions.next();
                result.add(processDefinition.getToActivity());
            }
            ++i;
        }
    }

    private void traverseInData(List startObjects, List result) {
        log.debug("==> traverseInData(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IActivity activity = (IActivity)startObjects.get(i);
            Iterator transitions = activity.getAllInDataMappings();
            while (transitions.hasNext()) {
                IDataMapping dataMapping = (IDataMapping)transitions.next();
                result.add(dataMapping.getData());
            }
            ++i;
        }
    }

    private void traverseOutData(List startObjects, List result) {
        log.debug("==> traverseInData(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IActivity activity = (IActivity)startObjects.get(i);
            Iterator transitions = activity.getAllOutDataMappings();
            while (transitions.hasNext()) {
                IDataMapping dataMapping = (IDataMapping)transitions.next();
                result.add(dataMapping.getData());
            }
            ++i;
        }
    }

    private void traverseData(List startObjects, List result) {
        log.debug("==> traverseData(" + startObjects + ")");
        int i = 0;
        while (i < startObjects.size()) {
            IActivity activity = (IActivity)startObjects.get(i);
            Iterator transitions = activity.getAllDataMappings();
            while (transitions.hasNext()) {
                IDataMapping dataMapping = (IDataMapping)transitions.next();
                if (result.contains(dataMapping)) continue;
                result.add(dataMapping.getData());
            }
            ++i;
        }
    }

    private void traverseInputFor(List startObjects, List result) {
        log.debug("==> traverseInData(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IData data = (IData)startObjects.get(i);
            if (model == null) {
                log.debug("Type of root: " + data.getModel());
                model = (IModel)data.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    Iterator dataMappings = activity.getAllInDataMappings();
                    while (dataMappings.hasNext()) {
                        IDataMapping dataMapping = (IDataMapping)dataMappings.next();
                        if (dataMapping.getData().getId() != data.getId()) continue;
                        result.add(activity);
                    }
                }
            }
            ++i;
        }
    }

    private void traverseOutputOf(List startObjects, List result) {
        log.debug("==> traverseInData(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IData data = (IData)startObjects.get(i);
            if (model == null) {
                log.debug("Type of root: " + data.getModel());
                model = (IModel)data.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    Iterator dataMappings = activity.getAllOutDataMappings();
                    while (dataMappings.hasNext()) {
                        IDataMapping dataMapping = (IDataMapping)dataMappings.next();
                        if (dataMapping.getData().getId() != data.getId()) continue;
                        result.add(activity);
                    }
                }
            }
            ++i;
        }
    }

    private void traverseDataFor(List startObjects, List result) {
        log.debug("==> traverseInData(" + startObjects + ")");
        IModel model = null;
        int i = 0;
        while (i < startObjects.size()) {
            IData data = (IData)startObjects.get(i);
            if (model == null) {
                log.debug("Type of root: " + data.getModel());
                model = (IModel)data.getModel();
            }
            Iterator processDefinitions = model.getAllProcessDefinitions();
            while (processDefinitions.hasNext()) {
                IProcessDefinition processDefinition = (IProcessDefinition)processDefinitions.next();
                Iterator activities = processDefinition.getAllActivities();
                while (activities.hasNext()) {
                    IActivity activity = (IActivity)activities.next();
                    Iterator dataMappings = activity.getAllDataMappings();
                    while (dataMappings.hasNext()) {
                        IDataMapping dataMapping = (IDataMapping)dataMappings.next();
                        if (dataMapping.getData().getId() != data.getId() || result.contains(activity)) continue;
                        result.add(activity);
                    }
                }
            }
            ++i;
        }
    }
}

