/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.eclipse.stardust.reporting.common.parser.IErrorHandler;

public class DefaultErrorHandler
implements IErrorHandler {
    private boolean failOnError = false;
    private List<String> errorMessages = new ArrayList<String>();

    @Override
    public void handleError(String[] tokenNames, RecognitionException e) {
        String errorMsg = this.getErrorMessage(e);
        if (this.failOnError) {
            throw new RuntimeException(errorMsg);
        }
        this.errorMessages.add(errorMsg);
    }

    @Override
    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    private String getErrorMessage(RecognitionException e) {
        Token token = e.token;
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Invalid Syntax in line: ");
        errorMessageBuilder.append(token.getLine());
        errorMessageBuilder.append(" position: ");
        errorMessageBuilder.append(token.getCharPositionInLine()).append("\n");
        errorMessageBuilder.append("'").append(token.getText()).append("'");
        errorMessageBuilder.append(" is no valid syntax at this position.");
        return errorMessageBuilder.toString();
    }
}

