/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.parser;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;

public class ParsedExpression
implements Comparable<ParsedExpression> {
    private final String text;
    private final int startIndex;
    private final int endIndex;

    public ParsedExpression(CommonTree child) {
        CommonToken ct = (CommonToken)child.token;
        this.text = child.getText();
        this.startIndex = ct.getStartIndex();
        this.endIndex = ct.getStopIndex();
    }

    public String getText() {
        return this.text;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int compareTo(ParsedExpression other) {
        return new Integer(this.startIndex).compareTo(other.getStartIndex());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.endIndex;
        result = 31 * result + this.startIndex;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParsedExpression other = (ParsedExpression)obj;
        if (this.endIndex != other.endIndex) {
            return false;
        }
        if (this.startIndex != other.startIndex) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

