/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class LargeStringResolver {
    private int inClauseBatchSize = 500;
    private final Set<Long> oidsToResolve;
    private String dataTypeToFilter;

    public LargeStringResolver(Set<Long> oidsToResolve) {
        this.oidsToResolve = oidsToResolve;
    }

    public LargeStringResolver(Set<Long> oidsToResolve, String dataTypeToFilter) {
        this.oidsToResolve = oidsToResolve;
        this.dataTypeToFilter = dataTypeToFilter;
    }

    public Map<Long, String> resolve(Connection connection, String schemaName) throws SQLException {
        HashMap<Long, String> resolvedLargeStrings = new HashMap<Long, String>();
        if (this.oidsToResolve.isEmpty()) {
            return resolvedLargeStrings;
        }
        DBDescriptor dbDescriptor = DbUtils.getDbDescriptor(connection);
        boolean dbIsTrimmingTrailingBlanks = dbDescriptor.isTrimmingTrailingBlanks();
        List<List<Long>> oidBlocks = this.getOidBlocks();
        String selectFieldList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("objectid", "sv"), new DbColumn("data_type", "sv"), new DbColumn("data", "sv")});
        String orderFieldList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("data_type", "sv"), new DbColumn("objectid", "sv"), new DbColumn("oid", "sv")});
        String whereFieldList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("objectid", "sv")});
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("Select ");
        queryBuilder.append(selectFieldList);
        queryBuilder.append(" from ");
        if (StringUtils.isNotEmpty((String)schemaName)) {
            queryBuilder.append(schemaName);
            queryBuilder.append(".");
        }
        queryBuilder.append("STRING_DATA");
        queryBuilder.append(" ").append("sv");
        int count = 0;
        for (List<Long> oidBlock : oidBlocks) {
            if (++count == 1) {
                queryBuilder.append(" where ");
                LargeStringResolver.appendInClause(whereFieldList, queryBuilder, oidBlock);
                continue;
            }
            queryBuilder.append(" or ");
            LargeStringResolver.appendInClause(whereFieldList, queryBuilder, oidBlock);
        }
        if (StringUtils.isNotEmpty((String)this.dataTypeToFilter)) {
            queryBuilder.append(" and ");
            queryBuilder.append("sv");
            queryBuilder.append(".");
            queryBuilder.append("data_type");
            queryBuilder.append(" = ");
            queryBuilder.append(SqlUtils.quoteParameter(this.dataTypeToFilter));
        }
        queryBuilder.append(" order by ");
        queryBuilder.append(orderFieldList);
        PreparedStatement ps = connection.prepareStatement(queryBuilder.toString());
        ResultSet rs = SqlUtils.performQuery(ps, queryBuilder.toString());
        while (rs.next()) {
            Long objectId = rs.getLong(1);
            String data = rs.getString(3);
            String trimmedData = this.trimStringPortion(data, dbIsTrimmingTrailingBlanks);
            if (!resolvedLargeStrings.containsKey(objectId) && StringUtils.isNotEmpty((String)trimmedData)) {
                resolvedLargeStrings.put(objectId, trimmedData);
                continue;
            }
            String existing = (String)resolvedLargeStrings.get(objectId);
            existing = existing.concat(trimmedData);
            resolvedLargeStrings.put(objectId, existing);
        }
        return resolvedLargeStrings;
    }

    private static void appendInClause(String whereFieldList, StringBuilder queryBuilder, List<Long> oidBlock) {
        queryBuilder.append(whereFieldList);
        queryBuilder.append(" IN(");
        for (Long oid : oidBlock) {
            queryBuilder.append(oid);
            queryBuilder.append(",");
        }
        queryBuilder.deleteCharAt(queryBuilder.length() - 1);
        queryBuilder.append(")");
    }

    protected List<List<Long>> getOidBlocks() {
        ArrayList<List<Long>> oidBlocks = new ArrayList<List<Long>>();
        ArrayList<Long> oidBlock = new ArrayList<Long>();
        int count = 0;
        for (Long oid : this.oidsToResolve) {
            oidBlock.add(oid);
            if (++count != this.inClauseBatchSize) continue;
            oidBlocks.add(oidBlock);
            count = 0;
            oidBlock = new ArrayList();
        }
        if (!oidBlock.isEmpty()) {
            oidBlocks.add(oidBlock);
        }
        return oidBlocks;
    }

    public String trimStringPortion(String portion, boolean dbIsTrimmingTrailingBlanks) {
        if (StringUtils.isNotEmpty((String)portion)) {
            int endMarkerIndex;
            String possibleEndMarker;
            if (dbIsTrimmingTrailingBlanks && (possibleEndMarker = portion.substring(endMarkerIndex = portion.length() - 1)).equals("\\")) {
                portion = portion.substring(0, portion.length() - 1);
            }
            return portion;
        }
        return null;
    }
}

