/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.IDataColumn;

public class ModelUtils {
    private static final Date MINUS_INFINITY_DATE = new Date(0L);
    private static final Date PLUS_INFINITY_DATE = new Date(Long.MAX_VALUE);

    public static IModel findModel(List<IModel> allModels, long modelOid) {
        for (IModel model : allModels) {
            if ((long)model.getModelOID() != modelOid) continue;
            return model;
        }
        return null;
    }

    public static IModel findActiveModel(List<IModel> allModels, List<IDataColumn> dataColumns) {
        List<IModel> activeModels = ModelUtils.findActiveModels(allModels);
        for (IModel model : activeModels) {
            if (!ModelUtils.matches(model, dataColumns)) continue;
            return model;
        }
        return null;
    }

    protected static boolean matches(IModel model, List<IDataColumn> dataColumns) {
        for (IDataColumn dataColumn : dataColumns) {
            if (model.findData(dataColumn.getDataId()) != null) continue;
            return false;
        }
        return true;
    }

    public static List<IModel> findActiveModels(List<IModel> allModels) {
        Date now = new Date();
        List result = CollectionUtils.newList();
        Set namespaces = CollectionUtils.newSet();
        for (IModel model : allModels) {
            String ns;
            if (model.getId().equals("PredefinedModel") || model.getBooleanAttribute("carnot:engine:disabled")) continue;
            Date from = (Date)model.getAttribute("carnot:engine:validFrom");
            Date to = (Date)model.getAttribute("carnot:engine:validTo");
            if (from == null) {
                from = MINUS_INFINITY_DATE;
            }
            if (to == null) {
                to = PLUS_INFINITY_DATE;
            }
            if (now.before(from) || !now.before(to) || namespaces.contains(ns = model.getId())) continue;
            result.add(model);
            namespaces.add(ns);
        }
        return result;
    }
}

