/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.struct.ClientXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.cluster.IData2ClusterMapper;
import org.eclipse.stardust.reporting.common.monitoring.Monitoring;
import org.eclipse.stardust.reporting.common.utils.sql.legacy.DataColumnJoinStructure;

public class SqlUtils {
    private static Logger log = LogUtils.getLogger(SqlUtils.class);
    public static final String PREFIX_SUBQUERY_ID = "CARNOT.Reporting.MQT.SubQueryId.";
    public static final String STARTING_PROC_DEF_SUBQUERY_ID = "StartingProcDef";
    public static final String SUB_PI_ACTIVE_TIME_SUBQUERY_ID = "SubPiActiveTime";
    public static final String PI_ACTIVE_TIME_SUBQUERY_ID = "PiActiveTime";

    private static DataInfo findDataValueInfo(IModel model, IDataColumn dataColumn, List<DataInfo> dataValueInfos) {
        if (dataValueInfos != null) {
            for (DataInfo info : dataValueInfos) {
                if ((long)model.getModelOID() != info.getModelOid() || !dataColumn.getDataId().equals(info.getDataId()) || !CompareHelper.areEqual((Object)dataColumn.getAttributeName(), (Object)info.getXPath())) continue;
                return info;
            }
        }
        return null;
    }

    private static List<StructDataColumn> findSameParentColumns(IModel model, StructDataColumn structDataColumn, List<IDataColumn> dataColumns) {
        ArrayList<StructDataColumn> sameParentColumns = new ArrayList<StructDataColumn>();
        TypedXPath parentXPath = SqlUtils.getParentXPath(model, structDataColumn);
        if (parentXPath != null && parentXPath.isList()) {
            for (IDataColumn dc : dataColumns) {
                StructDataColumn sdc;
                TypedXPath sdcParentXPath;
                if (!(dc instanceof StructDataColumn) || (sdcParentXPath = SqlUtils.getParentXPath(model, sdc = (StructDataColumn)dc)) == null || !parentXPath.getXPath().equals(sdcParentXPath.getXPath())) continue;
                sameParentColumns.add(sdc);
            }
        }
        return sameParentColumns;
    }

    private static TypedXPath getParentXPath(IModel model, StructDataColumn structDataColumn) {
        String dataTypeDefinitionId;
        Set allXPath;
        ClientXPathMap xPathMap;
        TypedXPath typedXPath;
        String dataId = structDataColumn.getDataId();
        String xPath = structDataColumn.getXpath();
        IData data = model.findData(dataId);
        if (data != null && (typedXPath = (xPathMap = new ClientXPathMap(allXPath = StructuredTypeRtUtils.getAllXPaths((IModel)model, (String)(dataTypeDefinitionId = (String)data.getAttribute("carnot:engine:dataType"))))).getXPath(xPath)) != null) {
            return typedXPath.getParentXPath();
        }
        return null;
    }

    public static Map<IDataColumn, List<DataJoinInfo>> getJoinInfo(List<IModel> allDeployedModels, List<IDataColumn> dataColumns, Map<IDataColumn, List<DataInfo>> dataValueInfoMap) {
        HashMap<IDataColumn, List<DataJoinInfo>> joinInfoMap = new HashMap<IDataColumn, List<DataJoinInfo>>();
        for (IModel model : allDeployedModels) {
            for (IDataColumn dataColumn : dataColumns) {
                List<DataInfo> dataValueInfos;
                DataInfo dataValueInfo = SqlUtils.findDataValueInfo(model, dataColumn, dataValueInfos = dataValueInfoMap.get(dataColumn));
                if (dataValueInfo == null) continue;
                DataJoinInfo joinInfo = new DataJoinInfo();
                joinInfo.setDataColumn(dataColumn);
                joinInfo.setDataValueInfo(dataValueInfo);
                if (dataValueInfo != null && dataColumn instanceof StructDataColumn) {
                    StructDataColumn structDataColumn = (StructDataColumn)dataColumn;
                    List<StructDataColumn> sameParentColumns = SqlUtils.findSameParentColumns(model, structDataColumn, dataColumns);
                    joinInfo.setSameParentColumns(sameParentColumns);
                }
                if (!joinInfoMap.containsKey(dataColumn)) {
                    joinInfoMap.put(dataColumn, new ArrayList());
                }
                List joinInfoList = (List)joinInfoMap.get(dataColumn);
                joinInfoList.add(joinInfo);
            }
        }
        return joinInfoMap;
    }

    public static DataColumnJoinStructure getJoinStructure(List<IDataColumn> dataColumns, IData2ClusterMapper dataMapper) throws SQLException {
        return new DataColumnJoinStructure(dataMapper, dataColumns);
    }

    public static ResultSet performQuery(PreparedStatement stmt, String sqlString) throws SQLException {
        Monitoring.traceSql(sqlString);
        long tStart = System.currentTimeMillis();
        try {
            ResultSet resultSet = stmt.executeQuery();
            return resultSet;
        }
        finally {
            Monitoring.traceSlowSql(tStart, System.currentTimeMillis(), sqlString);
        }
    }

    public static void closeQuery(PreparedStatement ps, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    public static String getMqtForSubQuery(View view, String subQueryId) {
        if (view == null) {
            throw new IllegalArgumentException(ReportingCommon_Messages.ExceptionArgumentViewIsNotAllowedToBeNull);
        }
        if (StringUtils.isEmpty((String)subQueryId)) {
            throw new IllegalArgumentException(ReportingCommon_Messages.ExceptionArgumentSubQueryIdIsNotAllowdToBeEmpty);
        }
        String mqtName = Parameters.instance().getString(PREFIX_SUBQUERY_ID + subQueryId, "");
        if (!StringUtils.isEmpty((String)mqtName) && -1 == mqtName.indexOf(".")) {
            mqtName = view.getQualifiedTableName(mqtName);
        }
        return mqtName;
    }

    public static String quoteParameter(String parameter) {
        String result = null;
        if (StringUtils.isNotEmpty((String)parameter)) {
            StringBuffer paramBuffer = new StringBuffer();
            paramBuffer.append("'");
            paramBuffer.append(parameter);
            paramBuffer.append("'");
            result = paramBuffer.toString();
        }
        return result;
    }

    public static Class getJavaTypeFromSQLType(String sqlType, int cardinality, int precision) {
        if (sqlType == null) {
            return Long.class;
        }
        if (sqlType.toLowerCase().startsWith("varchar")) {
            return String.class;
        }
        if (sqlType.toLowerCase().startsWith("timestamp")) {
            return Timestamp.class;
        }
        if (sqlType.toLowerCase().startsWith("decimal")) {
            return BigDecimal.class;
        }
        return Long.class;
    }

    public static Object getColumnValue(Column column, ResultSet resultSet, int resultSetIndex) throws SQLException {
        return SqlUtils.getColumnValue(column.getType(), resultSet, resultSetIndex);
    }

    public static Object getColumnValue(Class javaType, ResultSet resultSet, int resultSetIndex) throws SQLException {
        Object o = null;
        o = javaType == Date.class ? new Date(resultSet.getLong(resultSetIndex)) : (javaType == Long.class ? new Long(resultSet.getLong(resultSetIndex)) : (javaType == Integer.class ? new Integer(resultSet.getInt(resultSetIndex)) : (javaType == BigDecimal.class ? resultSet.getBigDecimal(resultSetIndex) : (javaType == String.class ? resultSet.getString(resultSetIndex) : (javaType == Timestamp.class ? new Timestamp(resultSet.getLong(resultSetIndex)) : resultSet.getObject(resultSetIndex))))));
        return o;
    }
}

