/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import com.infinity.bpm.thirdparty.emf.common.util.URI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.struct.emfxsd.runtime.CustomURIConverter;

public class WorkspaceURIConverter
extends CustomURIConverter {
    public InputStream createInputStream(URI arg0, Map<?, ?> arg1) throws IOException {
        if (StringUtils.isEmpty((String)arg0.scheme())) {
            String platformResourcePath = this.getWorkspaceRelativePath(arg0);
            try {
                return PlatformResourceURIHandlerImpl.WorkbenchHelper.createPlatformResourceInputStream((String)platformResourcePath, arg1);
            }
            catch (Exception exception) {
                throw new PublicException("Could not resolve xsd for uri '" + arg0 + "' in eclipse workspace");
            }
        }
        return super.createInputStream(arg0, arg1);
    }

    private String getWorkspaceRelativePath(URI uri) {
        String workSpaceRelativePath;
        Map customMap = this.getCustomMap();
        if (customMap != null && customMap.containsKey("carnot:engine:resource:mapping:eclipseWorkspaceFile")) {
            workSpaceRelativePath = (String)customMap.get("carnot:engine:resource:mapping:eclipseWorkspaceFile");
        } else {
            IResource resource = this.findWorkspaceResource(uri.path());
            if (resource == null) {
                resource = this.findClassPathResource(uri.path());
            }
            workSpaceRelativePath = resource != null ? resource.getFullPath().toString() : null;
        }
        return workSpaceRelativePath;
    }

    private IResource findClassPathResource(String classPathRelativePath) {
        IProject[] allProjects;
        IWorkspace workSpace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workSpaceRoot = workSpace.getRoot();
        IProject[] iProjectArray = allProjects = workSpaceRoot.getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject javaProject = this.createJavaProject(project);
            if (javaProject != null) {
                try {
                    IPackageFragmentRoot[] srcFolders = javaProject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < srcFolders.length) {
                        IFolder folder;
                        IFile file;
                        IResource tmpResource = srcFolders[i].getCorrespondingResource();
                        if (tmpResource instanceof IFolder && (file = (folder = (IFolder)tmpResource).getFile(classPathRelativePath)).exists()) {
                            return file;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return null;
    }

    private IResource findWorkspaceResource(String workSpaceRelativePath) {
        IWorkspace workSpace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workSpaceRoot = workSpace.getRoot();
        try {
            IFile file = workSpaceRoot.getFile((IPath)new Path(workSpaceRelativePath));
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IJavaProject createJavaProject(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

