/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.common.Functor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.TransformingIterator;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.engine.core.persistence.jdbc.DB2DbDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBMSKey;
import org.eclipse.stardust.engine.core.persistence.jdbc.DerbyDbDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.MySqlDbDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.OracleDbDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.SybaseDbDescriptor;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.ArrayIterator;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.InnerJoinExpression;
import org.eclipse.stardust.reporting.common.utils.sql.OuterJoinExpression;

public class DbUtils {
    public static final String AND_OPERATOR = " AND ";
    public static final String OR_OPERATOR = " OR ";
    public static final String WHERE_CLAUSE = " WHERE ";
    private static final Logger log = LogUtils.getLogger(DbUtils.class);
    public static final String DBDESCRIPTOR_PREFIX = "ag.carnot.db.jdbc.dbdescriptor.";
    public static final String DBDESCRIPTOR_PROP = "ag.carnot.db.jdbc.dbdescriptor.AuditTrail";

    public static DBDescriptor getCurrentDbDescriptor() {
        return (DBDescriptor)Parameters.instance().get(DBDESCRIPTOR_PROP);
    }

    public static DBDescriptor getDbDescriptor(Connection connection) {
        OracleDbDescriptor descriptor = null;
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            DBMSKey dbType = DbUtils.getDbType(metadata);
            if (DBMSKey.ORACLE.equals((Object)dbType)) {
                descriptor = new OracleDbDescriptor();
            } else if (DBMSKey.DB2_UDB.equals((Object)dbType)) {
                descriptor = new DB2DbDescriptor();
            } else if (DBMSKey.DERBY.equals((Object)dbType)) {
                descriptor = new DerbyDbDescriptor();
            } else if (DBMSKey.SYBASE.equals((Object)dbType)) {
                descriptor = new SybaseDbDescriptor();
            } else if (DBMSKey.MYSQL.equals((Object)dbType)) {
                descriptor = new MySqlDbDescriptor();
            }
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return descriptor;
    }

    public static DBMSKey getDbType(DatabaseMetaData metaData) {
        try {
            String databaseName = metaData.getDatabaseProductName().toUpperCase();
            if (databaseName.startsWith(DBMSKey.ORACLE.getId().toUpperCase())) {
                return DBMSKey.ORACLE;
            }
            if (databaseName.startsWith(DBMSKey.DB2_UDB.getId().toUpperCase())) {
                return DBMSKey.DB2_UDB;
            }
            if (databaseName.endsWith(DBMSKey.DERBY.getId().toUpperCase())) {
                return DBMSKey.DERBY;
            }
            if (databaseName.endsWith("ADAPTIVE SERVER ENTERPRISE")) {
                return DBMSKey.SYBASE;
            }
            if (databaseName.startsWith(DBMSKey.MYSQL.getId().toUpperCase())) {
                return DBMSKey.MYSQL;
            }
            log.warn(MessageFormat.format("Unknown database: {0}. Falling back to {1}.", databaseName, DBMSKey.ORACLE.getId().toUpperCase()));
            return DBMSKey.ORACLE;
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    public static String getColumnList(DBDescriptor dbDescriptor, IDbColumn columnName) {
        return DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{columnName}, ", ", null);
    }

    public static String getColumnList(DBDescriptor dbDescriptor, IDbColumn[] columnNames) {
        return DbUtils.getColumnList(dbDescriptor, columnNames, ", ", null);
    }

    public static String getColumnList(DBDescriptor dbDescriptor, IDbColumn[] columnNames, String delimiter) {
        return DbUtils.getColumnList(dbDescriptor, columnNames, delimiter, null);
    }

    public static String getColumnList(Collection<DbColumn> columns) {
        StringBuffer buffer = new StringBuffer();
        if (columns.isEmpty() || columns == null) {
            buffer.append("*");
        } else {
            Iterator<DbColumn> i = columns.iterator();
            while (i.hasNext()) {
                DbColumn cn = i.next();
                buffer.append(cn);
                if (!i.hasNext()) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    public static void indexColumns(Collection<DbColumn> columns) {
        int paramIndex = 0;
        for (DbColumn cn : columns) {
            cn.setRsIndex(++paramIndex);
        }
    }

    public static int getRsIndex(String columnName, String alias, List<DbColumn> columns) {
        DbColumn column = new DbColumn(columnName, alias);
        return DbUtils.getRsIndex(column, columns);
    }

    public static int getRsIndex(String columnName, List<DbColumn> columns) {
        int paramIndex = 0;
        for (DbColumn cn : columns) {
            ++paramIndex;
            if (!cn.getName().equals(columnName)) continue;
            return paramIndex;
        }
        return -1;
    }

    public static int getRsIndex(DbColumn column, List<DbColumn> columns) {
        int paramIndex = 0;
        for (DbColumn cn : columns) {
            ++paramIndex;
            if (!cn.toString().equals(column.toString())) continue;
            return paramIndex;
        }
        return -1;
    }

    public static String getColumnList(final DBDescriptor dbDescriptor, IDbColumn[] columnNames, String delimiter, final Functor functor) {
        ArrayIterator arrayIter = new ArrayIterator(columnNames);
        TransformingIterator tranformingIter = new TransformingIterator((Iterator)arrayIter, new Functor(){

            public Object execute(Object source) {
                IDbColumn columnName = (IDbColumn)source;
                String identifier = dbDescriptor.quoteIdentifier(columnName.getName());
                DbColumn tmp = new DbColumn(identifier, columnName.getQualifier(), columnName.getAlias());
                if (functor == null) {
                    return tmp.getQualifiedName();
                }
                return functor.execute((Object)tmp);
            }
        });
        return StringUtils.join((Iterator)tranformingIter, (String)delimiter);
    }

    public static InnerJoinExpression getInnerJoin(DbTable tableToJoin, DbColumn sourceColumn, DbColumn targetColumn) {
        InnerJoinExpression innerJoin = new InnerJoinExpression(tableToJoin);
        innerJoin.AND(sourceColumn, CompareOperator.EQUALS, targetColumn);
        return innerJoin;
    }

    public static OuterJoinExpression getOuterJoin(DbTable tableToJoin, DbColumn sourceColumn, DbColumn targetColumn) {
        OuterJoinExpression outerJoin = new OuterJoinExpression(tableToJoin);
        outerJoin.AND(sourceColumn, CompareOperator.EQUALS, targetColumn);
        return outerJoin;
    }

    public static String getOnFragment(String predicate) {
        StringBuffer buffer = new StringBuffer(" on(");
        buffer.append(predicate).append(")");
        return buffer.toString();
    }

    public static String getAndOnFragment(String predicate1, String predicate2) {
        String[] predicates = new String[]{predicate1, predicate2};
        return DbUtils.getOnFragment(StringUtils.join((Iterator)new ArrayIterator(predicates), (String)AND_OPERATOR));
    }

    public static String getAndOnFragment(String predicate1, String predicate2, String predicate3) {
        String[] predicates = new String[]{predicate1, predicate2, predicate3};
        return DbUtils.getOnFragment(StringUtils.join((Iterator)new ArrayIterator(predicates), (String)AND_OPERATOR));
    }

    public static String getOrOnFragment(String predicate1, String predicate2) {
        String[] predicates = new String[]{predicate1, predicate2};
        return DbUtils.getOnFragment(StringUtils.join((Iterator)new ArrayIterator(predicates), (String)OR_OPERATOR));
    }

    public static String getOrOnFragment(String predicate1, String predicate2, String predicate3) {
        String[] predicates = new String[]{predicate1, predicate2, predicate3};
        return DbUtils.getOnFragment(StringUtils.join((Iterator)new ArrayIterator(predicates), (String)OR_OPERATOR));
    }

    public static String getQualifiedTableName(String schemaName, String tableName) {
        StringBuffer buffer = new StringBuffer();
        if (!DbUtils.isQualified(schemaName, tableName)) {
            buffer.append(schemaName).append('.');
        }
        buffer.append(tableName);
        return buffer.toString();
    }

    public static String getPartitionSqlFragment(PartitionInfo partitionInfo, String schemaName, String tableName, String tableAlias) {
        return DbUtils.getPartitionSqlFragment(partitionInfo, schemaName, tableName, tableAlias, "model");
    }

    public static String getPartitionSqlFragment(String schema, PartitionInfo partitionInfo, DbTable tableToSelect) {
        StringBuffer buffer = new StringBuffer();
        DbColumn tableToSelectModelColumn = tableToSelect.getColumn("model");
        DbTable modelTable = new DbTable(schema, "model", "m");
        DbColumn modelTableOidColumn = modelTable.getColumn("oid");
        DbColumn modelTablePartitionColumn = modelTable.getColumn("partition");
        if (tableToSelect.equals(modelTable)) {
            buffer.append(modelTable);
            buffer.append(" where ").append(modelTablePartitionColumn).append(" = ").append(partitionInfo.getPartitionOid());
        } else {
            buffer.append(modelTable);
            buffer.append(" inner join ");
            buffer.append(tableToSelect);
            buffer.append(" on(");
            buffer.append(tableToSelectModelColumn);
            buffer.append(" = ");
            buffer.append(modelTableOidColumn);
            buffer.append(AND_OPERATOR);
            buffer.append(modelTablePartitionColumn);
            buffer.append(" = ");
            buffer.append(partitionInfo.getPartitionOid());
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static String getPartitionSqlFragment(PartitionInfo partitionInfo, String schemaName, String tableName, String tableAlias, String modelColumnName) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        String joinTableName = DbUtils.getQualifiedTableName(schemaName, tableName);
        String modelTableName = DbUtils.getQualifiedTableName(schemaName, "model");
        StringBuffer buffer = new StringBuffer();
        String predicateList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn(modelColumnName, tableAlias), new DbColumn("oid", "m")}, " = ");
        DbColumn partitionCol = new DbColumn(dbDescriptor.quoteIdentifier("partition"), "m");
        if (joinTableName.equals(modelTableName)) {
            partitionCol = new DbColumn(dbDescriptor.quoteIdentifier("partition"), tableAlias);
            buffer.append(modelTableName).append(" ").append(tableAlias);
            buffer.append(" where ").append(partitionCol).append(" = ").append(partitionInfo.getPartitionOid());
        } else {
            buffer.append(modelTableName).append(" m");
            buffer.append(" inner join ").append(joinTableName).append(' ').append(tableAlias).append(" on (").append(partitionCol).append(" = ").append(partitionInfo.getPartitionOid()).append(AND_OPERATOR).append(predicateList).append(")");
        }
        return buffer.toString();
    }

    public static boolean isQualified(String schemaName, String tableName) {
        boolean isQualified = false;
        if (tableName.startsWith(schemaName)) {
            isQualified = true;
        }
        return isQualified;
    }

    public static String buildPredicate(Object value1, CompareOperator operator, Object value2) {
        if (value1 instanceof String) {
            value1 = DbUtils.quoteValue(value1);
        }
        if (value2 instanceof String) {
            value2 = DbUtils.quoteValue(value2);
        }
        StringBuffer condition = new StringBuffer();
        condition.append(value1);
        condition.append(" ");
        condition.append((Object)operator);
        condition.append(" ");
        condition.append(value2);
        return condition.toString();
    }

    public static String quoteIdentifier(String identifier) {
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        return dbDescriptor.quoteIdentifier(identifier);
    }

    public static String quoteValue(Object o) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("'");
        buffer.append(o);
        buffer.append("'");
        return buffer.toString();
    }
}

