/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.utils.sql.ISqlExpression;
import org.eclipse.stardust.reporting.common.utils.sql.JoinExpression;
import org.eclipse.stardust.reporting.common.utils.sql.SortExpression;
import org.eclipse.stardust.reporting.common.utils.sql.WhereExpression;

public class SqlStructure {
    private List<DbColumn> selectColumns = new ArrayList<DbColumn>();
    private List<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
    private DbTable fromTable = null;
    private final PartitionInfo partitionInfo;
    private final String schemaName;

    public SqlStructure(PartitionInfo partitionInfo, String schemaName) {
        this.partitionInfo = partitionInfo;
        this.schemaName = schemaName;
    }

    public List<DbColumn> getSelectColumns() {
        return this.selectColumns;
    }

    public boolean hasColumn(DbColumn selectColumn) {
        for (DbColumn column : this.selectColumns) {
            if (!column.toString().equals(selectColumn.toString())) continue;
            return true;
        }
        return false;
    }

    public void addSelectColumn(DbColumn selectColumn) {
        Assert.isNotNull((Object)selectColumn);
        int index = this.getSelectListIndex(selectColumn);
        if (index < 0) {
            this.selectColumns.add(selectColumn);
        } else {
            this.selectColumns.set(index, selectColumn);
        }
        DbUtils.indexColumns(this.selectColumns);
    }

    public int getSelectListIndex(DbColumn selectColumn) {
        Assert.isNotNull((Object)selectColumn);
        int i = 0;
        while (i < this.selectColumns.size()) {
            DbColumn column = this.selectColumns.get(i);
            if (column.toString().equals(selectColumn.toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DbTable getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(DbTable fromTable) {
        this.fromTable = fromTable;
    }

    public List<ISqlExpression> getExpressions() {
        return this.expressions;
    }

    public void addExpressions(ISqlExpression expression) {
        for (ISqlExpression tmpExpression : this.expressions) {
            if (!expression.getSql().equals(tmpExpression.getSql())) continue;
            return;
        }
        this.expressions.add(expression);
    }

    public List<JoinExpression> getJoins() {
        ArrayList<JoinExpression> joins = new ArrayList<JoinExpression>();
        for (ISqlExpression expression : this.expressions) {
            if (!(expression instanceof JoinExpression)) continue;
            joins.add((JoinExpression)expression);
        }
        return joins;
    }

    public WhereExpression getWhere() {
        for (ISqlExpression expression : this.expressions) {
            if (!(expression instanceof WhereExpression)) continue;
            return (WhereExpression)expression;
        }
        return null;
    }

    public SortExpression getSortBy() {
        for (ISqlExpression expression : this.expressions) {
            if (!(expression instanceof SortExpression)) continue;
            return (SortExpression)expression;
        }
        return null;
    }

    public String getSql() {
        String fromStatement = DbUtils.getPartitionSqlFragment(this.schemaName, this.partitionInfo, this.getFromTable());
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        buffer.append(DbUtils.getColumnList(this.getSelectColumns()));
        buffer.append(" from ").append(fromStatement);
        for (JoinExpression join : this.getJoins()) {
            buffer.append(join);
        }
        buffer.append(this.getWhere());
        buffer.append(this.getSortBy());
        return buffer.toString();
    }

    public String toString() {
        return this.getSql();
    }

    public void applyStructure(SqlStructure structure) {
        for (DbColumn selectColumn : structure.getSelectColumns()) {
            this.addSelectColumn(selectColumn);
        }
        List<ISqlExpression> expressions = structure.getExpressions();
        for (ISqlExpression expression : expressions) {
            this.addExpressions(expression);
        }
    }
}

