/*******************************************************************************
 * Copyright (c) 2011 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
 
grammar ExpressionGrammar;

options {
    language = Java;
    output = AST;
}

@lexer::header {
package org.eclipse.stardust.reporting.common.parser.generated;
}

@parser::header {
package org.eclipse.stardust.reporting.common.parser.generated;
import org.eclipse.stardust.reporting.common.parser.IErrorHandler;
}

@members {
    private IErrorHandler errorHandler = null;
    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
    
    public IErrorHandler getErrorHandler() {
        return errorHandler;
    }
    
    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
    {
        if(errorHandler != null)
        {
            errorHandler.handleError(tokenNames, e);
        }
    }
}

unit
    : base_unit
    | LPAREN unit RPAREN
    ;
  
base_unit
    : QUOTED_STRING
    | DOUBLEQUOTED_STRING
    | numeric_unit
    | boolean_unit
    | NULL
    | ID
    | REPORTING_PARAMETER
    ;
    
boolean_unit
    : TRUE
    | FALSE
    ;

numeric_unit
    : NUMBER_VALUE
    ;

compare_statement  
    : (EQ | NOT_EQ | LT | LEQ | GT | GEQ | LIKE)
    ;  

is_null_statment
    : IS NOT? NULL
    ;  

between_statement
    : BETWEEN unit AND unit
    ;
   
in_statement 
    : IN LPAREN (unit (COMMA unit)*) RPAREN  
    ;
    
and_or_statement 
    : OR
    | AND
;
   
condition_statement
    : ((NOT?) unit ((compare_statement unit) | is_null_statment | between_statement | in_statement) )
    ;

/*start point: 
  parses an 'sql where' expression build by the expression builder */   
parseExpression :
    condition_statement (and_or_statement condition_statement)* EOF
;
      
AND :   'and'   ;
BETWEEN : 'between' ;
IN : 'in' ;
IS : 'is' ;
LIKE : 'like' ;
NOT : 'not' ;
NULL : 'null' ;
OR : 'or' ;
TRUE    :   'true';
FALSE : 'false';
QUOTED_STRING
    :   ('n')? '\'' ('\'\'' | ~('\''))* '\''
    ;
DOUBLEQUOTED_STRING
    : '"' ( ~('"') )* '"'
    ;          
REPORTING_PARAMETER
    :   '${' ('a' .. 'z' | 'A' .. 'Z') ('a'..'z' | '0'..'9' | '_' | '.' | '(' | ')')* '}'
    ;   
ID 
    :   ('a' .. 'z' | 'A' .. 'Z') ('a' .. 'z' | 'A' .. 'Z' |  '0' .. '9' | '_' | '#')*
    ;
COMMA
    : ','
    ;
RPAREN
    : ')'
    ;
LPAREN
    : '('
    ;
LT
    : '<'
    ;    
LEQ
    : '<='
    ;       
EQ
    : '='
    ;
NOT_EQ
    : '<>'
    ;
GT
    : '>'
    ;
GEQ
    : '>='
    ;
fragment
POINT
    : '.'
    ;    
NUMBER_VALUE
    : INTEGER POINT INTEGER?
    | INTEGER
    ;    
fragment
INTEGER
    : '0' .. '9' ( '0' .. '9' )*
    ;
WS  : (' '|'\r'|'\t'|'\n') {$channel=HIDDEN;}
    ;