/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.ide.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.reporting.ide.integration.Reporting_Model_Messages;
import org.osgi.framework.Bundle;

public class ReportRunner {
    private static final String HOME = "HOME";
    private static final String DEFINITION_OVERVIEW_RPTDESIGN = "DefinitionOverview.rptdesign";
    private static final String CARNOT_DS_LIBRARY_RPTLIBRARY = "CARNOT-ds-library.rptlibrary";
    private static final String TEMP_FOLDER_OFFSET = "CARNOT/reports/";
    private static final int STREAM_BUFFER_SIZE = 1024;
    private final String dataSourceslibFileName;
    private final String designFileName;
    private static ReportRunner runner;
    private String tempFolder;

    public static ReportRunner instance() {
        if (runner == null) {
            runner = new ReportRunner();
        }
        return runner;
    }

    void startReportOnModel(String modelFileName, String modelId) {
        this.startReportOnModel(modelFileName, modelId, "html");
    }

    void startReportOnModel(String modelFileName, String modelId, String format) {
        try {
            ReportRunner.prepareReports(this.tempFolder);
        }
        catch (CoreException e) {
            throw new PublicException(Reporting_Model_Messages.EXP_CouldNotCreateCopyOfReportingFiles, (Throwable)e);
        }
        catch (IOException e) {
            throw new PublicException(Reporting_Model_Messages.EXP_CouldNotCreateCopyOfReportingFiles, (Throwable)e);
        }
        SessionHandleAdapter adapter = SessionHandleAdapter.getInstance();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(this.dataSourceslibFileName);
                ModuleHandle handle = adapter.init(this.dataSourceslibFileName, (InputStream)stream);
                Library library = (Library)handle.getModule();
                OdaDataSource dataSource = (OdaDataSource)library.findDataSource("CARNOT Process Model");
                String fileName = (String)dataSource.getProperty((Module)library, HOME);
                modelFileName = ";" + modelFileName;
                if (StringUtils.isEmpty((String)fileName) || !fileName.equals(modelFileName)) {
                    dataSource.setProperty(HOME, (Object)modelFileName);
                    handle.saveAs(this.dataSourceslibFileName);
                }
                ((InputStream)stream).close();
                stream = null;
                stream = new FileInputStream(this.designFileName);
                adapter.init(this.designFileName, (InputStream)stream);
                String parameterCarryingFormat = String.valueOf(format) + "&__overwrite=true&hideMenu=true";
                if (!StringUtils.isEmpty((String)modelId)) {
                    parameterCarryingFormat = String.valueOf(parameterCarryingFormat) + "&ModelID=" + URLEncoder.encode(modelId, "UTF-8");
                }
                WebViewer.display((String)this.designFileName, (String)parameterCarryingFormat, (boolean)true);
            }
            catch (Exception e) {
                throw new InternalException(MessageFormat.format(Reporting_Model_Messages.EXP_CannotStartReportForModel, modelFileName), (Throwable)e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    throw new InternalException("", (Throwable)e);
                }
            }
        }
    }

    private ReportRunner() {
        try {
            this.tempFolder = String.valueOf(ReportRunner.getTempFolder()) + TEMP_FOLDER_OFFSET;
        }
        catch (IOException e) {
            throw new PublicException(Reporting_Model_Messages.EXP_CouldNotCreateCopyOfReportingFiles, (Throwable)e);
        }
        this.dataSourceslibFileName = String.valueOf(this.tempFolder) + CARNOT_DS_LIBRARY_RPTLIBRARY;
        this.designFileName = String.valueOf(this.tempFolder) + DEFINITION_OVERVIEW_RPTDESIGN;
        ReportRunner.touchReportFiles();
        WebViewer.startup((String)"viewer");
    }

    private static void prepareReports(String destinationPath) throws CoreException, IOException {
        String overviewDesign = ReportRunner.getSystemPath("org.eclipse.stardust.reporting.reports.core", new String[]{"reports/carnot/DefinitionOverview.rptdesign"});
        String sourcePath = overviewDesign.substring(0, overviewDesign.lastIndexOf("/") + 1);
        new File(destinationPath).mkdirs();
        File folder = new File(sourcePath);
        File[] files = folder.listFiles();
        int idx = 0;
        while (idx < files.length) {
            if (!files[idx].isDirectory()) {
                File target = new File(String.valueOf(destinationPath) + "/" + files[idx].getName());
                ReportRunner.copy(files[idx], target);
            }
            ++idx;
        }
    }

    private static String getTempFolder() throws IOException {
        File temp = File.createTempFile("CARNOT", ".tmp");
        temp.deleteOnExit();
        String path = StringUtils.replace((String)temp.getAbsolutePath(), (String)"\\", (String)"/");
        return path.substring(0, path.lastIndexOf("/") + 1);
    }

    private static void touchReportFiles() {
        String pluginId = "org.eclipse.stardust.reporting.reports.core";
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            if (bundle == null) {
                throw new InternalException(MessageFormat.format(Reporting_Model_Messages.EXP_BundleHasNotBeenLoadedYet, pluginId));
            }
            Enumeration enumerator = bundle.getEntryPaths("reports/carnot");
            while (enumerator.hasMoreElements()) {
                String elem = (String)enumerator.nextElement();
                URL entryUrl = bundle.getEntry(elem);
                if (entryUrl == null) continue;
                Platform.asLocalURL((URL)entryUrl).getPath();
            }
        }
        catch (IOException e) {
            throw new PublicException(Reporting_Model_Messages.EXP_CouldNotCreateCopyOfReportingFiles, (Throwable)e);
        }
    }

    private static String getSystemPath(String pluginId, String[] entryNames) throws IOException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new InternalException(MessageFormat.format(Reporting_Model_Messages.EXP_BundleHasNotBeenLoadedYet, pluginId));
        }
        String systemPath = "";
        boolean found = false;
        int idx = 0;
        while (idx < entryNames.length) {
            URL entryUrl = bundle.getEntry(entryNames[idx]);
            if (entryUrl != null) {
                found = true;
                systemPath = Platform.asLocalURL((URL)entryUrl).getPath();
                break;
            }
            ++idx;
        }
        if (!found) {
            throw new InternalException(MessageFormat.format(Reporting_Model_Messages.EXP_BundleDoesNotContain, pluginId, StringUtils.join(Arrays.asList(entryNames).iterator(), (String)", ")));
        }
        return StringUtils.replace((String)systemPath, (String)"\\", (String)"/");
    }

    private static void copy(File source, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int length;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

