/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.ide.integration;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.actions.EditDomainAwareAction;
import org.eclipse.stardust.reporting.ide.integration.ReportRunner;
import org.eclipse.stardust.reporting.ide.integration.ReportingUtils;
import org.eclipse.stardust.reporting.ide.integration.Reporting_Model_Messages;

public class ReportingAction
extends EditDomainAwareAction {
    private static final String EMF_RES_PREFIX = "/resource/";

    public ReportingAction() {
        this.setId(ReportingAction.class.getName());
        this.setText(Reporting_Model_Messages.TEXT_WorkflowModelReporting);
    }

    public void run() {
        String format = ReportingUtils.getReportFormat();
        if (format != null) {
            ModelType model = this.getModel();
            Resource eResModel = model.eResource();
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            String uriEResModel = eResModel.getURI().path();
            if (uriEResModel.startsWith(EMF_RES_PREFIX)) {
                uriEResModel = uriEResModel.substring(EMF_RES_PREFIX.length());
            }
            IResource res = wsRoot.findMember(uriEResModel);
            String path = res.getLocation().makeAbsolute().toFile().getAbsolutePath();
            ReportRunner.instance().startReportOnModel(path, model.getId(), format);
        }
    }
}

