/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.ide.integration;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.reporting.ide.integration.Reporting_Model_Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class ReportingFormatDialog
extends MessageDialogWithToggle {
    private Button htmlRadio;
    private Button pdfRadio;
    private String format;

    public ReportingFormatDialog() {
        super(null, Reporting_Model_Messages.TITLE_Format, null, "", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, Reporting_Model_Messages.LB_RememberDecision, false);
    }

    public String getReportFormat() {
        return this.format;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.setLayoutData((Object)new GridData(66));
        }
        Group group = FormBuilder.createGroup((Composite)composite, (String)Reporting_Model_Messages.MSG_SelectFormat, (int)2);
        ((GridLayout)composite.getLayout()).horizontalSpacing = 15;
        this.htmlRadio = FormBuilder.createRadioButton((Composite)group, (String)"HTML");
        this.pdfRadio = FormBuilder.createRadioButton((Composite)group, (String)"PDF");
        boolean isHTMLFormat = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat");
        boolean isPDFFormat = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat");
        this.htmlRadio.setSelection(isHTMLFormat || !isHTMLFormat && !isPDFFormat);
        this.pdfRadio.setSelection(isPDFFormat);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        this.format = this.htmlRadio.getSelection() ? "html" : "pdf";
        super.buttonPressed(buttonId);
    }
}

