/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.ide.integration;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.reporting.ide.integration.ReportRunner;
import org.eclipse.stardust.reporting.ide.integration.ReportingUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ReportingToolbarAction
implements IWorkbenchWindowActionDelegate {
    private static final String EMF_RES_PREFIX = "/resource/";

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part instanceof WorkflowModelEditor) {
            WorkflowModelEditor editor = (WorkflowModelEditor)part;
            String format = ReportingUtils.getReportFormat();
            if (format != null) {
                ModelType model = (ModelType)editor.getModel();
                Resource eResModel = model.eResource();
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                String uriEResModel = eResModel.getURI().path();
                if (uriEResModel.startsWith(EMF_RES_PREFIX)) {
                    uriEResModel = uriEResModel.substring(EMF_RES_PREFIX.length());
                }
                IResource res = wsRoot.findMember(uriEResModel);
                String path = res.getLocation().makeAbsolute().toFile().getAbsolutePath();
                ReportRunner.instance().startReportOnModel(path, model.getId(), format);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

