/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.IDBNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.TableColumnNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.Utility;
import org.eclipse.swt.graphics.Image;

public class TableNode
extends ChildrenAllowedNode
implements Comparable<TableNode> {
    private static Logger logger = Logger.getLogger(TableNode.class.getName());
    private static String TABLE_ICON = String.valueOf(TableNode.class.getName()) + ".TableIcon";
    private static String VIEW_ICON = String.valueOf(TableNode.class.getName()) + ".ViewIcon";
    private String schemaName;
    private String tableName;
    private boolean isView;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(TABLE_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/table.gif"));
        reg.put(VIEW_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/view.gif"));
    }

    public TableNode(String schemaName, String tableName, boolean isView) {
        assert (tableName != null);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.isView = isView;
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return BidiTransform.transform((String)this.tableName, (String)metadataBidiFormatStr, (String)"ILYNN");
    }

    @Override
    public Image getImage() {
        return this.isView ? JFaceResources.getImage((String)VIEW_ICON) : JFaceResources.getImage((String)TABLE_ICON);
    }

    @Override
    public int compareTo(TableNode o) {
        return this.tableName.compareTo(o.tableName);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        StringBuffer sb = new StringBuffer();
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        String schemaNameStr = this.schemaName;
        String tableNameStr = this.tableName;
        if (includeSchema && this.schemaName != null) {
            schemaNameStr = BidiTransform.transform((String)this.schemaName, (String)metadataBidiFormatStr, (String)"ILYNN");
            sb.append(Utility.quoteString(schemaNameStr, quoteFlag)).append(".");
        }
        tableNameStr = BidiTransform.transform((String)tableNameStr, (String)metadataBidiFormatStr, (String)"ILYNN");
        sb.append(Utility.quoteString(tableNameStr, quoteFlag));
        return sb.toString();
    }

    @Override
    protected IDBNode[] refetchChildren(FilterConfig fc) {
        ArrayList<TableColumnNode> columns = new ArrayList<TableColumnNode>();
        ResultSet rs = JdbcMetaDataProvider.getInstance().getTableColumns(this.schemaName, this.tableName, null);
        if (rs != null) {
            try {
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    String typeName = rs.getString("TYPE_NAME");
                    TableColumnNode column = new TableColumnNode(this.schemaName, this.tableName, columnName, typeName);
                    columns.add(column);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return columns.toArray(new TableColumnNode[0]);
    }
}

