/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.preference;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.Utility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DateSetPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor maxDisplaySchemaEditor;
    private IntegerFieldEditor maxDisplayTableEditor;
    private IntegerFieldEditor timeOutLimitEditor;
    private Button schemasPrefetchConfigCheckbox;
    private Button enableCodeAssistCheckbox;
    public static final int DEFAULT_MAX_NUM_OF_SCHEMA = 20;
    public static final int DEFAULT_MAX_NUM_OF_TABLE_EACH_SCHEMA = 100;
    public static final int DEFAULT_TIMEOUT_LIMIT = 60;
    private static final int MAX_MAX_ROW = Integer.MAX_VALUE;
    public static final String ENABLED = "YES";
    public static final String DISABLED = "NO";
    public static final String USER_MAXROW = "user_maxrow";
    public static final String SCHEMAS_PREFETCH_CONFIG = "shemas_prefetch_config";
    public static final String USER_MAX_NUM_OF_SCHEMA = "user_max_num_of_schema";
    public static final String USER_MAX_NUM_OF_TABLE_EACH_SCHEMA = "user_max_num_of_table_each_schema";
    public static final String USER_TIMEOUT_LIMIT = "user_timeout_limit";
    public static final String ENABLE_CODE_ASSIST = "enable_code_assit";

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalSpan = 6;
        GridLayout layout = new GridLayout();
        mainComposite.setLayout((Layout)layout);
        Group sqlDataSetGroup = new Group(mainComposite, 0);
        sqlDataSetGroup.setLayout((Layout)layout);
        sqlDataSetGroup.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.sqldatasetpage.group.title"));
        sqlDataSetGroup.setLayoutData((Object)data);
        sqlDataSetGroup.setEnabled(true);
        data = new GridData(768);
        data.horizontalSpan = 2;
        Label invisibleRow = new Label((Composite)sqlDataSetGroup, 0);
        invisibleRow.setLayoutData((Object)data);
        this.schemasPrefetchConfigCheckbox = new Button((Composite)sqlDataSetGroup, 32);
        this.schemasPrefetchConfigCheckbox.setLayoutData((Object)data);
        this.schemasPrefetchConfigCheckbox.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.schemasPrefetchCheckbox.description"));
        this.enableCodeAssistCheckbox = new Button((Composite)sqlDataSetGroup, 32);
        this.enableCodeAssistCheckbox.setLayoutData((Object)data);
        this.enableCodeAssistCheckbox.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.enableCodeAssist.description"));
        this.initializeSchemaPrefetchConfig();
        this.initializeEnableCodeAssistConfig();
        this.maxDisplaySchemaEditor = new IntegerFieldEditor(USER_MAX_NUM_OF_SCHEMA, "", (Composite)sqlDataSetGroup);
        Label lab = this.maxDisplaySchemaEditor.getLabelControl((Composite)sqlDataSetGroup);
        lab.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.maxNoOfSchema.description"));
        this.maxDisplaySchemaEditor.setPage((DialogPage)this);
        this.maxDisplaySchemaEditor.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        this.maxDisplaySchemaEditor.setValidateStrategy(0);
        this.maxDisplaySchemaEditor.setValidRange(0, Integer.MAX_VALUE);
        this.maxDisplaySchemaEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    DateSetPreferencePage.this.setValid(DateSetPreferencePage.this.maxDisplaySchemaEditor.isValid());
                }
            }
        });
        this.maxDisplaySchemaEditor.setErrorMessage(JdbcPlugin.getFormattedString("designer.preview.preference.resultset.maxNoOfSchema.errormessage", new Object[]{new Integer(Integer.MAX_VALUE)}));
        String defaultMaxSchema = JdbcPlugin.getDefault().getPluginPreferences().getString(USER_MAX_NUM_OF_SCHEMA);
        if (defaultMaxSchema == null || defaultMaxSchema.trim().length() <= 0) {
            defaultMaxSchema = String.valueOf(20);
        }
        this.maxDisplaySchemaEditor.setStringValue(defaultMaxSchema);
        this.maxDisplayTableEditor = new IntegerFieldEditor(USER_MAX_NUM_OF_TABLE_EACH_SCHEMA, "", (Composite)sqlDataSetGroup);
        lab = this.maxDisplayTableEditor.getLabelControl((Composite)sqlDataSetGroup);
        lab.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.maxNoOfTable.description"));
        this.maxDisplayTableEditor.setPage((DialogPage)this);
        this.maxDisplayTableEditor.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        this.maxDisplayTableEditor.setValidateStrategy(0);
        this.maxDisplayTableEditor.setValidRange(0, Integer.MAX_VALUE);
        this.maxDisplayTableEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    DateSetPreferencePage.this.setValid(DateSetPreferencePage.this.maxDisplayTableEditor.isValid());
                }
            }
        });
        this.maxDisplayTableEditor.setErrorMessage(JdbcPlugin.getFormattedString("designer.preview.preference.resultset.maxNoOfTable.errormessage", new Object[]{new Integer(Integer.MAX_VALUE)}));
        String defaultMaxTable = JdbcPlugin.getDefault().getPluginPreferences().getString(USER_MAX_NUM_OF_TABLE_EACH_SCHEMA);
        if (defaultMaxTable == null || defaultMaxTable.trim().length() <= 0) {
            defaultMaxTable = String.valueOf(100);
        }
        this.maxDisplayTableEditor.setStringValue(defaultMaxTable);
        this.timeOutLimitEditor = new IntegerFieldEditor(USER_MAX_NUM_OF_SCHEMA, "", (Composite)sqlDataSetGroup);
        lab = this.timeOutLimitEditor.getLabelControl((Composite)sqlDataSetGroup);
        lab.setText(JdbcPlugin.getResourceString("designer.preview.preference.resultset.timeOutLimit.description"));
        this.timeOutLimitEditor.setPage((DialogPage)this);
        this.timeOutLimitEditor.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        this.timeOutLimitEditor.setValidateStrategy(0);
        this.timeOutLimitEditor.setValidRange(0, Integer.MAX_VALUE);
        this.timeOutLimitEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    DateSetPreferencePage.this.setValid(DateSetPreferencePage.this.timeOutLimitEditor.isValid());
                }
            }
        });
        this.timeOutLimitEditor.setErrorMessage(JdbcPlugin.getFormattedString("designer.preview.preference.resultset.timeOutLimit.errormessage", new Object[]{new Integer(Integer.MAX_VALUE)}));
        String defaultTimeOutLimit = JdbcPlugin.getDefault().getPluginPreferences().getString(USER_TIMEOUT_LIMIT);
        if (defaultTimeOutLimit == null || defaultTimeOutLimit.trim().length() <= 0) {
            defaultTimeOutLimit = String.valueOf(60);
        }
        this.timeOutLimitEditor.setStringValue(defaultTimeOutLimit);
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Preference_BIRT_DataSetEditor_JDBC_ID");
        return mainComposite;
    }

    private void initializeSchemaPrefetchConfig() {
        if (JdbcPlugin.getDefault().getPluginPreferences().contains(SCHEMAS_PREFETCH_CONFIG)) {
            String selection = JdbcPlugin.getDefault().getPluginPreferences().getString(SCHEMAS_PREFETCH_CONFIG);
            this.schemasPrefetchConfigCheckbox.setSelection(selection.equals(ENABLED));
        } else {
            JdbcPlugin.getDefault().getPluginPreferences().setValue(SCHEMAS_PREFETCH_CONFIG, ENABLED);
            this.schemasPrefetchConfigCheckbox.setSelection(true);
        }
    }

    private void initializeEnableCodeAssistConfig() {
        if (JdbcPlugin.getDefault().getPluginPreferences().contains(ENABLE_CODE_ASSIST)) {
            String selection = JdbcPlugin.getDefault().getPluginPreferences().getString(ENABLE_CODE_ASSIST);
            this.enableCodeAssistCheckbox.setSelection(selection.equals(ENABLED));
        } else {
            JdbcPlugin.getDefault().getPluginPreferences().setValue(ENABLE_CODE_ASSIST, ENABLED);
            this.enableCodeAssistCheckbox.setSelection(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.maxDisplaySchemaEditor.setStringValue(String.valueOf(20));
        this.maxDisplayTableEditor.setStringValue(String.valueOf(100));
        this.enableCodeAssistCheckbox.setSelection(true);
        this.schemasPrefetchConfigCheckbox.setSelection(true);
        this.timeOutLimitEditor.setStringValue(String.valueOf(60));
        super.performDefaults();
    }

    public boolean performOk() {
        JdbcPlugin.getDefault().getPluginPreferences().setValue(SCHEMAS_PREFETCH_CONFIG, this.schemasPrefetchConfigCheckbox.getSelection() ? ENABLED : DISABLED);
        JdbcPlugin.getDefault().getPluginPreferences().setValue(ENABLE_CODE_ASSIST, this.enableCodeAssistCheckbox.getSelection() ? ENABLED : DISABLED);
        JdbcPlugin.getDefault().getPluginPreferences().setValue(USER_MAX_NUM_OF_SCHEMA, this.maxDisplaySchemaEditor.getStringValue());
        JdbcPlugin.getDefault().getPluginPreferences().setValue(USER_MAX_NUM_OF_TABLE_EACH_SCHEMA, this.maxDisplayTableEditor.getStringValue());
        JdbcPlugin.getDefault().getPluginPreferences().setValue(USER_TIMEOUT_LIMIT, this.timeOutLimitEditor.getStringValue());
        JdbcPlugin.getDefault().savePluginPreferences();
        return true;
    }
}

