/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.ui.PlatformUI;

public class JarFile
implements Serializable {
    private static final long serialVersionUID = -765442524028110564L;
    private String fileName;
    private String filePath;
    private String state;
    private boolean toBeDeleted;
    private transient boolean hasRestored;
    public static final String FILE_HAS_BEEN_RESOTRED = "+";
    public static final String ODA_FILE_NOT_EXIST_TOKEN = "x";
    public static final String ORIGINAL_FILE_NOT_EXIST_TOKEN = "*";

    public JarFile(String fileName, String filePath, String state, boolean toBeDeleted) {
        this.fileName = fileName;
        this.filePath = filePath;
        this.state = state;
        this.toBeDeleted = toBeDeleted;
        this.hasRestored = false;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getState() {
        return this.state;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public void setRestored() {
        this.hasRestored = true;
    }

    public void copyJarToODADir() {
        block32: {
            File source = new File(this.filePath);
            File odaDir = JarFile.getDriverLocation();
            File dest1 = null;
            if (odaDir != null) {
                dest1 = new File(String.valueOf(odaDir.getAbsolutePath()) + File.separator + source.getName());
            }
            if (source.exists()) {
                AbstractInterruptibleChannel in = null;
                AbstractInterruptibleChannel out1 = null;
                try {
                    if (dest1 != null) {
                        try {
                            out1 = new FileOutputStream(dest1).getChannel();
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                    if (out1 != null) {
                        in = new FileInputStream(source).getChannel();
                        long size = ((FileChannel)in).size();
                        MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
                        ((FileChannel)out1).write(buf);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out1 != null) {
                            out1.close();
                        }
                        break block32;
                    }
                    catch (IOException iOException) {}
                    break block32;
                }
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (out1 != null) {
                                out1.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out1 != null) {
                            out1.close();
                        }
                        break block32;
                    }
                    catch (IOException iOException3) {}
                    break block32;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out1 != null) {
                        out1.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void deleteJarFromODADir() {
        File source = new File(this.filePath);
        File odaDir = JarFile.getDriverLocation();
        File dest1 = null;
        if (odaDir != null && (dest1 = new File(String.valueOf(odaDir.getAbsolutePath()) + File.separator + source.getName())).exists() && !dest1.delete()) {
            dest1.deleteOnExit();
        }
    }

    public void checkJarState() {
        File f;
        this.state = this.hasRestored ? FILE_HAS_BEEN_RESOTRED : (!this.isUnderODAPath(f = new File(this.filePath)) ? (f.exists() ? ODA_FILE_NOT_EXIST_TOKEN : "x*") : (f.exists() ? "" : ORIGINAL_FILE_NOT_EXIST_TOKEN));
    }

    public static File getDriverLocation() {
        try {
            return OdaJdbcDriver.getDriverDirectory();
        }
        catch (IOException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        catch (OdaException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return null;
    }

    private boolean isUnderODAPath(File f) {
        File odaPath = JarFile.getDriverLocation();
        File ff = new File(odaPath + File.separator + f.getName());
        return ff.exists();
    }
}

