/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.util;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.Column;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.Schema;

public class Table
implements Serializable {
    private static final long serialVersionUID = 8386854614853850187L;
    private String name = null;
    private String type = null;
    private ArrayList columns = null;
    private Schema schema = null;

    public Table(Schema schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ArrayList getColumns() throws SQLException {
        if (this.columns == null) {
            this.retrieveColumns();
        }
        return this.columns;
    }

    private synchronized void retrieveColumns() throws SQLException {
        if (this.columns == null) {
            this.columns = new ArrayList();
            ResultSet resultSet = this.schema.getMetaData().getMetaData().getColumns(this.schema.getMetaData().getCatalogname(), this.schema.getName(), this.getName(), null);
            while (resultSet.next()) {
                Column column = new Column();
                column.setName(resultSet.getString("COLUMN_NAME"));
                this.columns.add(column);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.columns.clear();
        super.finalize();
    }
}

