/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.model;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.beans.EngineContext;
import org.eclipse.stardust.reporting.common.metamodel.Path;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.oda.model.Connection;
import org.eclipse.stardust.reporting.oda.model.ParameterMetaData;
import org.eclipse.stardust.reporting.oda.model.ProcessModel_Messages;
import org.eclipse.stardust.reporting.oda.model.ResultSet;
import org.eclipse.stardust.reporting.oda.model.ResultSetMetaData;

public class Query
implements IQuery {
    private static final Logger log = LogUtils.getLogger(Query.class);
    private static final int DEFAULT_MAX_ROWS = 1000;
    private Path path;
    private int maxRows;
    private Connection connection;
    private ResultSetMetaData resultSetMetaData = null;
    private Object[] parameterValues;
    private final int MODEL_PARAMETER_SIZE = 2;

    Query(String homeDir, Connection host) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("JNDI Path: " + homeDir));
        }
        this.connection = host;
        this.maxRows = 1000;
    }

    public void prepare(String query) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"prepare()");
        try {
            log.debug((Object)("=> prepare(" + query + ")"));
            this.path = new Path(query);
            this.parameterValues = new Object[this.path.getSize() + 2];
            this.resultSetMetaData = new ResultSetMetaData(this.path);
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"prepare()");
        }
    }

    public void setAppContext(Object arg0) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAppContext(" + arg0 + ")"));
        }
    }

    public void setProperty(String arg0, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty(" + arg0 + ", " + arg1 + ")"));
        }
    }

    public void close() throws OdaException {
        log.debug((Object)"close()");
    }

    public void setMaxRows(int maxRows) throws OdaException {
        log.debug((Object)("setMaxRows(" + maxRows + ")"));
        this.maxRows = maxRows;
    }

    public int getMaxRows() throws OdaException {
        log.debug((Object)"getMaxRows()");
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        log.debug((Object)"getMetaData()");
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"executeQuery()");
        EngineContext engineContext = null;
        try {
            IModel model;
            Object[] vals = new Object[this.parameterValues.length - 2];
            int i = 2;
            while (i < this.parameterValues.length) {
                vals[i - 2] = this.parameterValues[i];
                ++i;
            }
            try {
                engineContext = this.connection.getQueryService().getEngineContext();
                if (engineContext != null) {
                    engineContext.startupEngine();
                }
            }
            catch (ProcessDatabaseQueryException e) {
                log.error((Object)e);
            }
            if ((model = this.connection.getModel(this.parameterValues)) != null) {
                ResultSet resultSet = new ResultSet(this.resultSetMetaData, this.path.evaluateAgainstModel(model, vals));
                return resultSet;
            }
            ResultSet resultSet = new ResultSet(this.resultSetMetaData, new Object[0][0]);
            return resultSet;
        }
        finally {
            if (engineContext != null) {
                engineContext.shutdownEngine();
            }
            LogUtils.exitApi((Logger)log, (Object)"executeQuery()");
        }
    }

    public void clearInParameters() throws OdaException {
        log.debug((Object)"clearInParameters()");
    }

    public void setNull(String parameterName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setNull(" + parameterName + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterId) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setNull(" + parameterId + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterId, (Object[])this.parameterValues);
        this.parameterValues[parameterId - 1] = null;
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBoolean(" + parameterName + ", " + value + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBoolean(" + parameterId + ", " + value + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterId, (Object[])this.parameterValues);
        this.parameterValues[parameterId - 1] = value;
    }

    public void setInt(String arg0, int arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setInt(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setInt(int arg0, int arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setInt(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = new Integer(arg1);
    }

    public void setDouble(String arg0, double arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDouble(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setDouble(int arg0, double arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDouble(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = new Double(arg1);
    }

    public void setBigDecimal(String arg0, BigDecimal arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBigDecimal(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBigDecimal(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = arg1;
    }

    public void setString(String arg0, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setString(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setString(int arg0, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setString(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = arg1;
    }

    public void setDate(String arg0, Date arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDate(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setDate(int arg0, Date arg1) throws OdaException {
        log.debug((Object)("=> setDate(" + arg0 + ", " + arg1 + ")"));
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = arg1;
    }

    public void setTime(String arg0, Time arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTime(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setTime(int arg0, Time arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTime(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = arg1;
    }

    public void setTimestamp(String arg0, Timestamp arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTimestamp(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTimestamp(" + arg0 + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)arg0, (Object[])this.parameterValues);
        this.parameterValues[arg0 - 1] = arg1;
    }

    public int findInParameter(String arg0) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("findInParameter(" + arg0 + ")"));
        }
        return 1;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        log.debug((Object)"getParameterMetaData()");
        return new ParameterMetaData(this.path);
    }

    public void setSortSpec(SortSpec arg0) throws OdaException {
        log.debug((Object)"setSortSpec()");
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        log.debug((Object)"getSortSpec()");
        throw new UnsupportedOperationException();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException(ProcessModel_Messages.CancelQueryNotSupported);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return null;
    }
}

