/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.processes;

import java.util.HashMap;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.oda.processes.ProcessDatabase_Messages;

public final class DataTypes {
    private static Logger log = LogUtils.getLogger(DataTypes.class);
    private static HashMap typeStringIntPair = new HashMap();

    static {
        typeStringIntPair.put("INT", new Integer(4));
        typeStringIntPair.put("DOUBLE", new Integer(8));
        typeStringIntPair.put("STRING", new Integer(12));
        typeStringIntPair.put("DATE", new Integer(91));
        typeStringIntPair.put("TIME", new Integer(92));
        typeStringIntPair.put("TIMESTAMP", new Integer(93));
        typeStringIntPair.put("BLOB", new Integer(2004));
        typeStringIntPair.put("CLOB", new Integer(2005));
        typeStringIntPair.put("BIGDECIMAL", new Integer(3));
        typeStringIntPair.put("NULL", new Integer(0));
        typeStringIntPair.put("JAVA.LANG.BOOLEAN", new Integer(16));
        typeStringIntPair.put("JAVA.LANG.BYTE", new Integer(4));
        typeStringIntPair.put("JAVA.LANG.SHORT", new Integer(4));
        typeStringIntPair.put("JAVA.LANG.INT", new Integer(4));
        typeStringIntPair.put("JAVA.LANG.INTEGER", new Integer(4));
        typeStringIntPair.put("JAVA.LANG.LONG", new Integer(-5));
        typeStringIntPair.put("JAVA.LANG.FLOAT", new Integer(8));
        typeStringIntPair.put("JAVA.LANG.DOUBLE", new Integer(8));
        typeStringIntPair.put("JAVA.LANG.STRING", new Integer(12));
        typeStringIntPair.put("JAVA.UTIL.DATE", new Integer(91));
        typeStringIntPair.put("JAVA.SQL.DATE", new Integer(91));
        typeStringIntPair.put("JAVA.SQL.TIME", new Integer(92));
        typeStringIntPair.put("JAVA.SQL.TIMESTAMP", new Integer(93));
        typeStringIntPair.put("JAVA.MATH.BIGDECIMAL", new Integer(3));
    }

    public static int getTypeCode(String typeName) throws OdaException {
        String preparedTypeName = typeName.trim().toUpperCase();
        log.debug((Object)("Retrieving type code for type " + preparedTypeName));
        if (typeStringIntPair.containsKey(preparedTypeName)) {
            return (Integer)typeStringIntPair.get(preparedTypeName);
        }
        log.debug((Object)("Invalid type name " + typeName));
        String errorMsg = NLS.bind((String)ProcessDatabase_Messages.InvalidTypeName, (Object)typeName);
        throw new OdaException(errorMsg);
    }

    public static boolean isValidType(String typeName) {
        return typeStringIntPair.containsKey(typeName.trim().toUpperCase());
    }

    private DataTypes() {
    }
}

