/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.processes;

import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.oda.processes.Connection;
import org.eclipse.stardust.reporting.oda.processes.ParameterMetaData;
import org.eclipse.stardust.reporting.oda.processes.ProcessDatabase_Messages;
import org.eclipse.stardust.reporting.oda.processes.ResultSet;
import org.eclipse.stardust.reporting.oda.processes.ResultSetMetaData;

public class Query
implements IQuery {
    private static final Logger log = LogUtils.getLogger(Query.class);
    private static final int DEFAULT_MAX_ROWS = 1000;
    private int maxRows;
    private Connection connection;
    private View view;
    private ResultSetMetaData resultSetMetaData = null;
    private Object[] parameterValues;

    Query(String homeDir, Connection host) throws OdaException {
        log.debug((Object)("JNDI Path: " + homeDir));
        this.connection = host;
        this.maxRows = 1000;
    }

    public void prepare(String query) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"prepare()");
        log.debug((Object)("=> prepare(" + query + ")"));
        try {
            try {
                this.view = View.readFromXMLEncoded((String)query);
                log.debug((Object)("Retrieved view from query: " + this.view));
                org.eclipse.stardust.reporting.common.ResultSetMetaData remoteData = this.connection.getQueryService().getMetaData(this.view);
                this.resultSetMetaData = new ResultSetMetaData(remoteData.getViewName(), remoteData.getColumnNames(), remoteData.getColumnTypeNames(), remoteData.getColumnLabels());
                int n = 0;
                while (n < remoteData.getColumnNames().length) {
                    log.debug((Object)("Column: " + remoteData.getColumnNames()[n]));
                    ++n;
                }
                this.parameterValues = new Object[this.view.getParameters().size()];
                log.debug((Object)("Parameter values initialized: " + this.parameterValues.length));
            }
            catch (ProcessDatabaseQueryException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
            catch (RemoteException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"prepare()");
        }
    }

    public void setAppContext(Object arg0) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAppContext(" + arg0 + ")"));
        }
    }

    public void setProperty(String arg0, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setProperty(" + arg0 + ", " + arg1 + ")"));
        }
    }

    public void close() throws OdaException {
        log.debug((Object)"close()");
    }

    public void setMaxRows(int maxRows) throws OdaException {
        log.debug((Object)"setMaxRows()");
        this.maxRows = maxRows;
    }

    public int getMaxRows() throws OdaException {
        log.debug((Object)"getMaxRows()");
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        log.debug((Object)"getMetadata()");
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"executeQuery()");
        try {
            ResultSet resultSet = new ResultSet(this.connection.getQueryService().executeQuery(this.view, this.parameterValues));
            return resultSet;
        }
        catch (ProcessDatabaseQueryException e) {
            log.error((Object)e);
            throw new OdaException(e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw new OdaException(e.getLocalizedMessage());
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"executeQuery()");
        }
    }

    public void clearInParameters() throws OdaException {
        log.debug((Object)"clearInParameters()");
    }

    public void setNull(String parameterName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setNull(" + parameterName + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterIndex) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setNull(" + parameterIndex + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = null;
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBoolean(" + parameterName + ", " + value + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int parameterIndex, boolean value) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBoolean(" + parameterIndex + ", " + value + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = value;
    }

    public void setInt(String arg0, int arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setInt(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setInt(int parameterIndex, int arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setInt(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = new Integer(arg1);
    }

    public void setDouble(String arg0, double arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDouble(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setDouble(int parameterIndex, double arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDouble(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = new Double(arg1);
    }

    public void setBigDecimal(String arg0, BigDecimal arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBigDecimal(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int parameterIndex, BigDecimal arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setBigDecimal(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = arg1;
    }

    public void setString(String arg0, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setString(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setString(int parameterIndex, String arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setString(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = arg1;
    }

    public void setDate(String arg0, Date arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDate(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setDate(int parameterIndex, Date arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDate(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = arg1;
    }

    public void setTime(String arg0, Time arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTime(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setTime(int parameterIndex, Time arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTime(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = arg1;
    }

    public void setTimestamp(String arg0, Timestamp arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTimestamp(" + arg0 + ", " + arg1 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int parameterIndex, Timestamp arg1) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setTimestamp(" + parameterIndex + ", " + arg1 + ")"));
        }
        ViewUtils.checkParameterRange((int)parameterIndex, (Object[])this.parameterValues);
        this.parameterValues[parameterIndex - 1] = arg1;
    }

    public int findInParameter(String arg0) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getParameterMetaData(" + arg0 + ")"));
        }
        throw new UnsupportedOperationException();
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getParameterMetaData()");
        }
        return new ParameterMetaData(this.view);
    }

    public void setSortSpec(SortSpec arg0) throws OdaException {
        log.debug((Object)"setSortSpec()");
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        log.debug((Object)"getSortSpec()");
        throw new UnsupportedOperationException();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException(ProcessDatabase_Messages.CancelQueryNotSupported);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
    }

    public void setObject(int parameterId, Object value) throws OdaException {
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return null;
    }
}

