/**
 * 
 */

function getIntervalParameterValue()
{
	paramValue = params["CodeDetailsInterval"].value;
    if(paramValue == null || paramValue.length == 0)
    {
    	paramValue = "month";
    }	
	
    return paramValue;
}

function getQaDistributionCategory(rowValue)
{	
	if(rowValue == "QUALITY_ASSURANCE_TRIGGERED")
	{
	    return reportContext.getMessage("TriggeredQA");
	}
	if(rowValue == "NO_QUALITY_ASSURANCE")
	{
	    return reportContext.getMessage("NoQA");
	}
}

function setIntervalToQaCodeTrendChart()
{
	importPackage(Packages.org.eclipse.birt.chart.model);
	importPackage(Packages.org.eclipse.birt.chart.model.attribute);

	intervalParamValue = getIntervalParameterValue();
	qaTrendChartElemenent = reportContext.getDesignHandle().findElement("QaCodeTrendChart");
	qaTrendChart = qaTrendChartElemenent.getReportItem().getProperty( "chart.instance" );

	xAxis = qaTrendChart.getAxes().get(0);
	xSeriesDef = xAxis.getSeriesDefinitions().get(0);
	xGrouping = xSeriesDef.getGrouping();
	
	if(typeof GroupingUnitType !== "undefined")
	{
		if(intervalParamValue == "year")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.YEARS));
		}
		else if(intervalParamValue == "quarter")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.QUARTERS));
		}
		else if(intervalParamValue == "month")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.MONTHS));
		}
		else if(intervalParamValue == "week")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.WEEKS));
		}
		else if(intervalParamValue == "day")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.DAYS));
		}
		else if(intervalParamValue == "hour")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.HOURS));
		}
		else if(intervalParamValue == "minute")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.MINUTES));
		}
		else if(intervalParamValue == "second")
		{
			xGrouping.setGroupingUnit(GroupingUnitType.get(GroupingUnitType.SECONDS));
		}
	}	
}

function setIntervalToTableGroup(context) {
	var intervalParamValue = getIntervalParameterValue();
	context.interval = intervalParamValue;
}


function getIntervalColumnHeader()
{
	intervalWord = reportContext.getMessage("Interval");
	intervalUnit = reportContext.getMessage(getIntervalParameterValue());
	
	
	return intervalWord 
	       +" ("
	       + intervalUnit
	       + ")";
}

function getIntervalGroupHeader(value) {
	var intervalUnit = getIntervalParameterValue();
	return formatIntervalGroupHeader(value, intervalUnit)
}

function formatIntervalGroupHeader(value, intervalUnit) {
	var formatPattern = null;
	if (intervalUnit == "year") 
	{
		formatPattern = "yyyy";
	} 
	else if (intervalUnit == "quarter") 
	{
		var yearFormat = new com.ibm.icu.text.SimpleDateFormat("yyyy",
				reportContext.getLocale());
		var quarterFormat = new com.ibm.icu.text.SimpleDateFormat("QQ",
				reportContext.getLocale());
		var quarterWord = reportContext.getMessage("quarter");

		var returnValue = yearFormat.format(value) + " (" + quarterWord + " "
				+ quarterFormat.format(value) + ")";
		return returnValue;
	} 
	else if (intervalUnit == "month") 
	{
		formatPattern = "MMMM yyyy";	
	} 
	else if (intervalUnit == "week") 
	{
		var monthFormat = new com.ibm.icu.text.SimpleDateFormat("MMMM yyyy",
				reportContext.getLocale());
		var weekFormat = new com.ibm.icu.text.SimpleDateFormat("WW",
				reportContext.getLocale());
		var weekWord = reportContext.getMessage("week");

		var returnValue = monthFormat.format(value) + " (" + weekWord + " "
				+ weekFormat.format(value) + ")";
		return returnValue;
	} 
	else if (intervalUnit == "day") 
	{
		formatPattern = "dd.MM.yyyy";
	} 
	else if (intervalUnit == "hour") 
	{
		formatPattern = "dd.MM.yyyy HH:00";
	} 
	else if (intervalUnit == "minute") 
	{
		formatPattern = "dd.MM.yyyy HH:mm";
	} 
	else if (intervalUnit == "second") 
	{
		formatPattern = "dd.MM.yyyy HH:mm:ss";
	}

	var dateFormat = new com.ibm.icu.text.SimpleDateFormat(formatPattern, reportContext.getLocale());
	return dateFormat.format(value);
}