/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedUnarchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.PMResolution;
import org.eclipse.swt.internal.cocoa.SWTPrinterView;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    NSPrinter printer;
    NSPrintInfo printInfo;
    NSPrintOperation operation;
    NSView view;
    NSWindow window;
    boolean isGCCreated;
    static final String DRIVER = "Mac";

    public static PrinterData[] getPrinterList() {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSArray printers = NSPrinter.printerNames();
            int count = printers.count();
            PrinterData[] result = new PrinterData[count];
            int i = 0;
            while (i < count) {
                NSString str = new NSString(printers.objectAtIndex(i));
                result[i] = new PrinterData(DRIVER, str.getString());
                ++i;
            }
            PrinterData[] printerDataArray = result;
            return printerDataArray;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public static PrinterData getDefaultPrinterData() {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPrinter printer = NSPrintInfo.defaultPrinter();
            if (printer == null) {
                return null;
            }
            NSString str = printer.name();
            PrinterData printerData = new PrinterData(DRIVER, str.getString());
            return printerData;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSSize paperSize = this.printInfo.paperSize();
            NSRect bounds = this.printInfo.imageablePageBounds();
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            float scaling = this.scalingFactor();
            x = (int)((float)x - bounds.x * (float)dpi.x / (float)screenDPI.x / scaling);
            y = (int)((float)y - bounds.y * (float)dpi.y / (float)screenDPI.y / scaling);
            width = (int)((float)width + (paperSize.width - bounds.width) * (float)dpi.x / (float)screenDPI.x / scaling);
            height = (int)((float)height + (paperSize.height - bounds.height) * (float)dpi.y / (float)screenDPI.y / scaling);
            Rectangle rectangle = new Rectangle(x, y, width, height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    protected void create(DeviceData deviceData) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString job;
            NSApplication.sharedApplication();
            this.data = (PrinterData)deviceData;
            if (this.data.otherData != null) {
                NSData nsData = NSData.dataWithBytes(this.data.otherData, this.data.otherData.length);
                this.printInfo = new NSPrintInfo(NSKeyedUnarchiver.unarchiveObjectWithData((NSData)nsData).id);
            } else {
                this.printInfo = NSPrintInfo.sharedPrintInfo();
            }
            this.printInfo.retain();
            this.printer = NSPrinter.printerWithName(NSString.stringWith(this.data.name));
            if (this.printer != null) {
                this.printer.retain();
                this.printInfo.setPrinter(this.printer);
            }
            if (this.data.duplex != -1) {
                int settings = this.printInfo.PMPrintSettings();
                int duplex = this.data.duplex == 2 ? 3 : (this.data.duplex == 1 ? 2 : 1);
                OS.PMSetDuplex(settings, duplex);
            }
            this.printInfo.updateFromPMPrintSettings();
            NSMutableDictionary dict = this.printInfo.dictionary();
            if (this.data.collate) {
                dict.setValue(NSNumber.numberWithBool(this.data.collate), OS.NSPrintMustCollate);
            }
            if (this.data.copyCount != 1) {
                dict.setValue(NSNumber.numberWithInt(this.data.copyCount), OS.NSPrintCopies);
            }
            dict.setValue(NSNumber.numberWithInt(this.data.orientation == 2 ? 1 : 0), OS.NSPrintOrientation);
            if (this.data.printToFile) {
                dict.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
                if (this.data.fileName != null) {
                    dict.setValue(NSString.stringWith(this.data.fileName), OS.NSPrintSavePath);
                }
            }
            if ((job = this.printInfo.jobDisposition()).isEqual(new NSString(OS.NSPrintPreviewJob()))) {
                this.printInfo.setJobDisposition(job);
            }
            NSRect rect = new NSRect();
            this.window = (NSWindow)new NSWindow().alloc();
            this.window.initWithContentRect(rect, 0, 2, false);
            String className = "SWTPrinterView";
            if (OS.objc_lookUpClass(className) == 0) {
                int cls = OS.objc_allocateClassPair(OS.class_NSView, className, 0);
                OS.class_addMethod(cls, OS.sel_isFlipped, OS.isFlipped_CALLBACK(), "@:");
                OS.objc_registerClassPair(cls);
            }
            this.view = (NSView)new SWTPrinterView().alloc();
            this.view.initWithFrame(rect);
            this.window.setContentView(this.view);
            this.operation = NSPrintOperation.printOperationWithView(this.view, this.printInfo);
            this.operation.retain();
            this.operation.setShowsPrintPanel(false);
            this.operation.setShowsProgressPanel(false);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    protected void destroy() {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.printer != null) {
                this.printer.release();
            }
            if (this.printInfo != null) {
                this.printInfo.release();
            }
            if (this.view != null) {
                this.view.release();
            }
            if (this.window != null) {
                this.window.release();
            }
            if (this.operation != null) {
                this.operation.release();
            }
            this.printer = null;
            this.printInfo = null;
            this.view = null;
            this.window = null;
            this.operation = null;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (data != null) {
                if (this.isGCCreated) {
                    SWT.error(5);
                }
                data.device = this;
                data.background = this.getSystemColor((int)1).handle;
                data.foreground = this.getSystemColor((int)2).handle;
                data.font = this.getSystemFont();
                float scaling = this.scalingFactor();
                Point dpi = this.getDPI();
                Point screenDPI = this.getIndependentDPI();
                NSSize size = this.printInfo.paperSize();
                size.width = size.width * (float)(dpi.x / screenDPI.x) / scaling;
                size.height = size.height * (float)dpi.y / (float)screenDPI.y / scaling;
                data.size = size;
                this.isGCCreated = true;
            }
            this.createContext();
            int n = this.operation.context().id;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    protected void init() {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            super.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        super.release();
    }

    float scalingFactor() {
        NSNumber scale = new NSNumber(this.printInfo.dictionary().objectForKey(OS.NSPrintScalingFactor));
        return scale.floatValue();
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (jobName != null && jobName.length() != 0) {
                this.operation.setJobTitle(NSString.stringWith(jobName));
            }
            if (this.createContext()) {
                this.view.beginDocument();
                return true;
            }
            return false;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    boolean createContext() {
        if (this.operation.context() != null) {
            return true;
        }
        this.printInfo.setUpPrintOperationDefaultValues();
        NSPrintOperation.setCurrentOperation(this.operation);
        return this.operation.createContext() != null;
    }

    public void endJob() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.view.endDocument();
            this.operation.deliverResult();
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void cancelJob() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.destroyContext();
            this.operation.cleanUpOperation();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            PrinterData defaultPrinter = Printer.getDefaultPrinterData();
            if (defaultPrinter == null) {
                SWT.error(2);
            }
            data.driver = defaultPrinter.driver;
            data.name = defaultPrinter.name;
        }
        return data;
    }

    public boolean startPage() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            float scaling = this.scalingFactor();
            NSSize paperSize = this.printInfo.paperSize();
            paperSize.width /= scaling;
            paperSize.height /= scaling;
            NSRect rect = new NSRect();
            rect.width = paperSize.width;
            rect.height = paperSize.height;
            this.view.beginPageInRect(rect, new NSPoint());
            NSRect imageBounds = this.printInfo.imageablePageBounds();
            imageBounds.x /= scaling;
            imageBounds.y /= scaling;
            imageBounds.width /= scaling;
            imageBounds.height /= scaling;
            NSBezierPath.bezierPathWithRect(imageBounds).setClip();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(imageBounds.x, imageBounds.y);
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            transform.scaleXBy((float)screenDPI.x / (float)dpi.x, (float)screenDPI.y / (float)dpi.y);
            transform.concat();
            this.operation.context().saveGraphicsState();
            return true;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void endPage() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.operation.context().restoreGraphicsState();
            this.view.endPage();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Point getDPI() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] destType;
            int printSettings;
            int pmPrintSession = this.printInfo.PMPrintSession();
            int[] printer = new int[1];
            int err = OS.PMSessionGetCurrentPrinter(pmPrintSession, printer);
            if (err == 0 && OS.PMSessionGetDestinationType(pmPrintSession, printSettings = this.printInfo.PMPrintSettings(), destType = new short[1]) == 0 && destType[0] == 1) {
                int[] numberOfResolutions;
                PMResolution resolution = new PMResolution();
                if (OS.PMPrinterGetOutputResolution(printer[0], printSettings, resolution) != 0 && OS.PMPrinterGetPrinterResolutionCount(printer[0], numberOfResolutions = new int[1]) == 0) {
                    PMResolution tempResolution = new PMResolution();
                    tempResolution.vRes = 300.0;
                    tempResolution.hRes = 300.0;
                    int i = 1;
                    while (i <= numberOfResolutions[0]) {
                        if (OS.PMPrinterGetIndexedPrinterResolution(printer[0], i, tempResolution) == 0 && tempResolution.vRes > resolution.vRes && tempResolution.hRes > resolution.hRes) {
                            resolution = tempResolution;
                        }
                        ++i;
                    }
                }
                Point point = new Point((int)resolution.hRes, (int)resolution.vRes);
                return point;
            }
            Point point = this.getIndependentDPI();
            return point;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSSize size = this.printInfo.paperSize();
            float scaling = this.scalingFactor();
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            Rectangle rectangle = new Rectangle(0, 0, (int)(size.width * (float)dpi.x / (float)screenDPI.x / scaling), (int)(size.height * (float)dpi.y / (float)screenDPI.y / scaling));
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            float scaling = this.scalingFactor();
            NSRect rect = this.printInfo.imageablePageBounds();
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            Rectangle rectangle = new Rectangle(0, 0, (int)(rect.width * (float)dpi.x / (float)screenDPI.x / scaling), (int)(rect.height * (float)dpi.y / (float)screenDPI.y / scaling));
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

