/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IWorkbenchWindow;

public class CastToArrayCommand
extends AbstractActionDelegate {
    @Override
    protected void run() {
        new GetBaseTypeName(this.getSelectedNode()){

            @Override
            void done() {
                if (this.base_type_name == null) {
                    return;
                }
                IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                CastToTypeDialog dialog = new CastToTypeDialog(window.getShell(), this.cur_length);
                if (dialog.open() != 0) {
                    return;
                }
                final String new_type = dialog.getValue().trim();
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        node.getModel().setCastToType(node.getID(), String.valueOf(base_type_name) + "[" + new_type + "]");
                    }
                });
            }
        };
    }

    @Override
    protected void selectionChanged() {
        new GetBaseTypeName(this.getSelectedNode()){

            @Override
            void done() {
                CastToArrayCommand.this.setEnabled(this.base_type_name != null);
            }
        };
    }

    private static class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell shell, String initial_value) {
            super(shell, "Cast To Array", "Enter array length", initial_value, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(ImageCache.getImage("icons/tcf.gif"));
        }
    }

    private static class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String new_text) {
            block4: {
                try {
                    if (new_text.length() != 0) break block4;
                    return "";
                }
                catch (Exception exception) {
                    return "Invalid number";
                }
            }
            int i = Integer.parseInt(new_text);
            if (i < 1) {
                return "Array length must be >= 1";
            }
            return null;
        }
    }

    private static class GetBaseTypeName
    implements Runnable {
        final TCFNode node;
        String base_type_name;
        String cur_length;

        GetBaseTypeName(TCFNode n) {
            TCFNode tCFNode = this.node = n instanceof ICastToType ? n : null;
            if (this.node == null) {
                this.done();
            } else {
                Protocol.invokeLater((Runnable)this);
            }
        }

        @Override
        public void run() {
            TCFDataCache<ISymbols.Symbol> type_cache;
            this.cur_length = null;
            String cast = this.node.getModel().getCastToType(this.node.getID());
            if (cast != null) {
                int i;
                if (cast.endsWith("]") && (i = cast.lastIndexOf(91)) > 0) {
                    this.cur_length = cast.substring(i + 1, cast.length() - 1);
                    this.done(cast.substring(0, i));
                    return;
                }
                this.done(null);
            }
            if (!(type_cache = ((ICastToType)((Object)this.node)).getType()).validate((Runnable)this)) {
                return;
            }
            ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
            if (type_data != null && type_data.getTypeClass() == ISymbols.TypeClass.pointer) {
                int i = 0;
                while (true) {
                    TCFDataCache<ISymbols.Symbol> base_type_cache;
                    if (!(base_type_cache = this.node.getModel().getSymbolInfoCache(type_data.getBaseTypeID())).validate((Runnable)this)) {
                        return;
                    }
                    ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                    if (base_type_data == null) {
                        this.done(null);
                        return;
                    }
                    if (base_type_data.getName() != null) {
                        this.done(this.makePtrTypeName(base_type_data.getName(), i));
                        return;
                    }
                    if (base_type_data.getTypeClass() != ISymbols.TypeClass.pointer) {
                        if (!base_type_data.getID().equals(base_type_data.getTypeID())) {
                            base_type_cache = this.node.getModel().getSymbolInfoCache(base_type_data.getTypeID());
                            if (!base_type_cache.validate((Runnable)this)) {
                                return;
                            }
                            base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                            if (base_type_data != null && base_type_data.getName() != null) {
                                this.done(this.makePtrTypeName(base_type_data.getName(), i));
                            } else {
                                this.done(null);
                            }
                            return;
                        }
                        this.done(null);
                        return;
                    }
                    type_data = base_type_data;
                    ++i;
                }
            }
            this.done(null);
        }

        private String makePtrTypeName(String base, int cnt) {
            StringBuffer bf = new StringBuffer();
            bf.append(base);
            if (cnt > 0) {
                bf.append(' ');
                while (cnt > 0) {
                    bf.append('*');
                    --cnt;
                }
            }
            return bf.toString();
        }

        private void done(String base_type_name) {
            this.base_type_name = base_type_name;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GetBaseTypeName.this.done();
                }
            });
        }

        void done() {
        }
    }
}

