/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.ImageCache;

public class PeerPropsControl {
    private static final int SIZING_TABLE_WIDTH = 400;
    private static final int SIZING_TABLE_HEIGHT = 200;
    private static final String[] column_names = new String[]{"Name", "Value"};
    private final Map<String, String> attrs;
    private final ArrayList<Attribute> attr_table_data;
    private final boolean create_new;
    private final boolean enable_editing;
    private final Runnable listener;
    private Text id_text;
    private Text name_text;
    private Table attr_table;
    private TableViewer table_viewer;
    private Image attr_image;

    public PeerPropsControl(Composite parent, Map<String, String> attrs, boolean enable_editing, Runnable listener) {
        this.attrs = attrs;
        this.enable_editing = enable_editing;
        this.listener = listener;
        this.create_new = attrs.isEmpty();
        this.attr_table_data = new ArrayList();
        this.createTextFields(parent);
        this.createAttrTable(parent);
    }

    private void createTextFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label id_label = new Label(composite, 64);
        id_label.setLayoutData((Object)new GridData(32));
        id_label.setFont(font);
        id_label.setText("Peer &ID:");
        this.id_text = new Text(composite, 2052);
        this.id_text.setLayoutData((Object)new GridData(768));
        this.id_text.setFont(font);
        this.id_text.setEditable(false);
        Label name_label = new Label(composite, 64);
        name_label.setLayoutData((Object)new GridData(32));
        name_label.setFont(font);
        name_label.setText("Peer &name:");
        this.name_text = new Text(composite, 2052);
        this.name_text.setLayoutData((Object)new GridData(768));
        this.name_text.setFont(font);
        this.name_text.setEditable(this.enable_editing);
        this.name_text.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                PeerPropsControl.this.listener.run();
            }
        });
    }

    private void createAttrTable(Composite parent) {
        Font font = parent.getFont();
        Label props_label = new Label(parent, 64);
        props_label.setLayoutData((Object)new GridData(768));
        props_label.setFont(font);
        props_label.setText("Peer &properties:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.attr_table = new Table(composite, 101124);
        this.attr_table.setFont(font);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 200;
        this.attr_table.setLayoutData((Object)data);
        int i = 0;
        while (i < column_names.length) {
            final TableColumn column = new TableColumn(this.attr_table, 16384, i);
            column.setMoveable(false);
            column.setText(column_names[i]);
            column.setWidth(400 / column_names.length);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (column == PeerPropsControl.this.attr_table.getSortColumn()) {
                        switch (PeerPropsControl.this.attr_table.getSortDirection()) {
                            case 0: {
                                PeerPropsControl.this.attr_table.setSortDirection(1024);
                                break;
                            }
                            case 1024: {
                                PeerPropsControl.this.attr_table.setSortDirection(128);
                                break;
                            }
                            case 128: {
                                PeerPropsControl.this.attr_table.setSortDirection(0);
                            }
                        }
                    } else {
                        PeerPropsControl.this.attr_table.setSortColumn(column);
                        PeerPropsControl.this.attr_table.setSortDirection(1024);
                    }
                    PeerPropsControl.this.table_viewer.refresh();
                }
            });
            ++i;
        }
        this.attr_table.setHeaderVisible(true);
        this.attr_table.setLinesVisible(true);
        this.attr_image = ImageCache.getImage("icons/attribute.gif");
        this.table_viewer = new TableViewer(this.attr_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        CellEditor[] editors = new CellEditor[column_names.length];
        int i2 = 0;
        while (i2 < column_names.length) {
            TextCellEditor editor = new TextCellEditor((Composite)this.attr_table);
            ((Text)editor.getControl()).setTextLimit(250);
            editors[i2] = editor;
            ++i2;
        }
        this.table_viewer.setCellEditors(editors);
        this.table_viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return PeerPropsControl.this.enable_editing;
            }

            public Object getValue(Object element, String property) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                Attribute a = (Attribute)element;
                return property.equals(column_names[0]) ? a.name : a.value;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                Attribute a = (Attribute)element;
                if (property.equals(column_names[0])) {
                    a.name = (String)value;
                } else {
                    a.value = (String)value;
                }
                PeerPropsControl.this.table_viewer.update(element, new String[]{property});
            }
        });
        Object[] keys = this.attrs.keySet().toArray(new String[this.attrs.size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (((String)key).equals("ID")) {
                this.id_text.setText(this.attrs.get(key));
            } else if (((String)key).equals("Name")) {
                this.name_text.setText(this.attrs.get(key));
            } else {
                Attribute a = new Attribute();
                a.name = key;
                a.value = this.attrs.get(key);
                this.attr_table_data.add(a);
            }
            ++n2;
        }
        if (this.create_new) {
            this.id_text.setText("USR:" + System.currentTimeMillis());
        }
        this.table_viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                if (!$assertionsDisabled && input != PeerPropsControl.this.attr_table_data) {
                    throw new AssertionError();
                }
                return PeerPropsControl.this.attr_table_data.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.table_viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.table_viewer.setInput(this.attr_table_data);
        this.table_viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                switch (PeerPropsControl.this.attr_table.getSortDirection()) {
                    case 128: {
                        return -super.compare(viewer, e1, e2);
                    }
                    case 1024: {
                        return super.compare(viewer, e1, e2);
                    }
                }
                return 0;
            }
        });
        this.createTableButtons(composite);
    }

    private void createTableButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Button button_new = new Button(composite, 8);
        button_new.setText("&Add");
        button_new.setLayoutData((Object)new GridData(256));
        button_new.setEnabled(this.enable_editing);
        button_new.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Attribute a = new Attribute();
                a.name = "";
                a.value = "";
                PeerPropsControl.this.attr_table_data.add(a);
                PeerPropsControl.this.table_viewer.add((Object)a);
                PeerPropsControl.this.table_viewer.setSelection((ISelection)new StructuredSelection((Object)a), true);
                PeerPropsControl.this.attr_table.setFocus();
            }
        });
        Button button_remove = new Button(composite, 8);
        button_remove.setText("&Remove");
        button_remove.setLayoutData((Object)new GridData(256));
        button_remove.setEnabled(this.enable_editing);
        button_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Attribute a = (Attribute)((IStructuredSelection)PeerPropsControl.this.table_viewer.getSelection()).getFirstElement();
                if (a == null) {
                    return;
                }
                PeerPropsControl.this.attr_table_data.remove(a);
                PeerPropsControl.this.table_viewer.remove((Object)a);
            }
        });
    }

    public boolean isComplete() {
        return this.name_text.getText().length() > 0;
    }

    public void okPressed() {
        if (this.enable_editing) {
            if (this.create_new) {
                this.attrs.put("ID", this.id_text.getText());
            }
            String id = this.attrs.get("ID");
            String nm = this.name_text.getText();
            this.attrs.clear();
            for (Attribute a : this.attr_table_data) {
                this.attrs.put(a.name, a.value);
            }
            this.attrs.put("ID", id);
            this.attrs.put("Name", nm);
        }
    }

    private class Attribute {
        String name;
        String value;

        private Attribute() {
        }
    }

    private class AttributeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private AttributeLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                return PeerPropsControl.this.attr_image;
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            Attribute a = (Attribute)element;
            return column == 0 ? a.name : a.value;
        }

        public String getText(Object element) {
            TableColumn column = PeerPropsControl.this.attr_table.getSortColumn();
            if (column == null) {
                return "";
            }
            return this.getColumnText(element, PeerPropsControl.this.attr_table.indexOf(column));
        }
    }
}

