/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.properties;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCommitAttr;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRefresh;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.properties.AdvancedAttributesDialog;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.dialogs.PropertyPage;

public class GeneralInformationPage
extends PropertyPage {
    private static final int RETRY_TIMES = 3;
    private static final DecimalFormat SIZE_FORMAT = new DecimalFormat();
    FSTreeNode node;
    FSTreeNode clone;
    Button btnReadOnly;
    Button btnHidden;
    Button[] btnPermissions;

    protected void createSeparator(Composite parent) {
        Label label = new Label(parent, 274);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    protected void createField(String text, String value, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        Text txt = new Text(parent, 72);
        data = new GridData();
        data.verticalAlignment = 128;
        data.widthHint = 300;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        txt.setLayoutData((Object)data);
        txt.setBackground(txt.getDisplay().getSystemColor(22));
        txt.setText(value);
    }

    protected String getSizeText(long size) {
        return NLS.bind((String)Messages.GeneralInformationPage_FileSizeInfo, (Object)SIZE_FORMAT.format(size / 1024L), (Object)SIZE_FORMAT.format(size));
    }

    protected String getDateText(long time) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        return dateFormat.format(new Date(time));
    }

    protected void createAttributesSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.GeneralInformationPage_Attributes);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        label.setLayoutData((Object)data);
        Composite attr = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        attr.setLayout((Layout)layout);
        this.btnReadOnly = new Button(attr, 32);
        this.btnReadOnly.setText(Messages.GeneralInformationPage_ReadOnly);
        this.btnReadOnly.setEnabled(this.node.isAgentOwner());
        this.btnReadOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralInformationPage.this.btnReadOnly.getSelection() != GeneralInformationPage.this.clone.isReadOnly()) {
                    GeneralInformationPage.this.clone.setReadOnly(GeneralInformationPage.this.btnReadOnly.getSelection());
                }
            }
        });
        this.btnHidden = new Button(attr, 32);
        this.btnHidden.setText(Messages.GeneralInformationPage_Hidden);
        this.btnHidden.setEnabled(this.node.isAgentOwner());
        this.btnHidden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btnHidden = (Button)e.getSource();
                if (btnHidden.getSelection() != GeneralInformationPage.this.clone.isHidden()) {
                    GeneralInformationPage.this.clone.setHidden(btnHidden.getSelection());
                }
            }
        });
        Button btnAdvanced = new Button(attr, 8);
        btnAdvanced.setText(Messages.GeneralInformationPage_Advanced);
        btnAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralInformationPage.this.showAdvancedAttributes();
            }
        });
        this.updateAttributes();
    }

    private void updateAttributes() {
        this.btnReadOnly.setSelection(this.clone.isReadOnly());
        this.btnHidden.setSelection(this.clone.isHidden());
    }

    void showAdvancedAttributes() {
        AdvancedAttributesDialog dialog = new AdvancedAttributesDialog(this.getShell(), (FSTreeNode)this.clone.clone());
        if (dialog.open() == 0) {
            FSTreeNode result = dialog.getResult();
            this.clone.attr = result.attr;
        }
    }

    protected void createPermissionsSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.GeneralInformationPage_PermissionText);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        Composite perms = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        perms.setLayout((Layout)gridLayout);
        this.btnPermissions = new Button[9];
        this.createPermissionGroup(perms, 0, Messages.PermissionsGroup_UserPermissions);
        this.createPermissionGroup(perms, 3, Messages.PermissionsGroup_GroupPermissions);
        this.createPermissionGroup(perms, 6, Messages.PermissionsGroup_OtherPermissions);
        this.updatePermissions();
    }

    protected void createPermissionGroup(Composite parent, int bit, String header) {
        Label label = new Label(parent, 0);
        label.setText(header);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        label.setLayoutData((Object)data);
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        this.createPermissionButton(Messages.PermissionsGroup_Readable, bit, group);
        this.createPermissionButton(Messages.PermissionsGroup_Writable, bit + 1, group);
        this.createPermissionButton(Messages.PermissionsGroup_Executable, bit + 2, group);
    }

    private void createPermissionButton(String label, final int index, Composite parent) {
        this.btnPermissions[index] = new Button(parent, 32);
        this.btnPermissions[index].setText(label);
        this.btnPermissions[index].setEnabled(this.node.isAgentOwner());
        this.btnPermissions[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int bit = 1 << 8 - index;
                boolean on = (GeneralInformationPage.this.clone.attr.permissions & bit) != 0;
                boolean newOn = GeneralInformationPage.this.btnPermissions[index].getSelection();
                if (newOn != on) {
                    int permissions = GeneralInformationPage.this.clone.attr.permissions;
                    permissions = newOn ? permissions | bit : permissions & ~bit;
                    GeneralInformationPage.this.clone.setPermissions(permissions);
                }
            }
        });
    }

    private void updatePermissions() {
        int i = 0;
        while (i < 9) {
            int bit = 1 << 8 - i;
            boolean on = (this.clone.attr.permissions & bit) != 0;
            this.btnPermissions[i].setSelection(on);
            ++i;
        }
    }

    protected void performDefaults() {
        this.clone = (FSTreeNode)this.node.clone();
        if (this.node.isWindowsNode()) {
            this.updateAttributes();
        } else {
            this.updatePermissions();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IStatus status;
        if (this.hasAttrsChanged() && !(status = this.commitAttr()).isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    private IStatus commitAttr() {
        OpCommitAttr op = new OpCommitAttr(this.node, this.clone.attr);
        NullOpExecutor executor = new NullOpExecutor();
        IStatus status = null;
        int i = 0;
        while (i < 3) {
            status = executor.execute((IOperation)op);
            if (status.isOK()) {
                if (!this.node.isRoot()) {
                    executor = new JobExecutor();
                    executor.execute((IOperation)new OpRefresh(this.node.getParent()));
                }
                return status;
            }
            ++i;
        }
        return status;
    }

    private boolean hasAttrsChanged() {
        if (this.node.isWindowsNode()) {
            return this.node.getWin32Attrs() != this.clone.getWin32Attrs();
        }
        return this.node.attr.permissions != this.clone.attr.permissions;
    }

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        Assert.isTrue((boolean)(element instanceof FSTreeNode));
        this.node = (FSTreeNode)element;
        this.clone = (FSTreeNode)this.node.clone();
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        page.setLayout((Layout)gridLayout);
        this.createField(Messages.GeneralInformationPage_Name, this.clone.name, page);
        this.createField(Messages.GeneralInformationPage_Type, this.clone.getFileType(), page);
        String location = this.clone.isSystemRoot() || this.clone.isRoot() ? Messages.GeneralInformationPage_Computer : this.clone.getLocation();
        this.createField(Messages.GeneralInformationPage_Location, location, page);
        if (this.clone.isFile()) {
            this.createField(Messages.GeneralInformationPage_Size, this.getSizeText(this.clone.attr.size), page);
        }
        this.createField(Messages.GeneralInformationPage_Modified, this.getDateText(this.clone.attr.mtime), page);
        if (this.clone.isFile()) {
            this.createField(Messages.GeneralInformationPage_Accessed, this.getDateText(this.clone.attr.atime), page);
        }
        this.createSeparator(page);
        if (this.clone.isWindowsNode()) {
            this.createAttributesSection(page);
        } else {
            this.createPermissionsSection(page);
        }
        return page;
    }
}

